/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.renderer.GraphicsMemento;
import oracle.bpm.draw.renderer.LaneBackgroundRenderer;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Lane;
import org.jetbrains.annotations.NotNull;

public class DrawableLaneColumn
extends DrawableFlowElementImpl<Lane>
implements Renderer {
    private Color background;
    private final DrawableLaneName lane;
    public static final int LANE_COLUMN_SIZE = 20000;
    private static final int LANE_COLUMN_STROKE = 16;

    DrawableLaneColumn(@NotNull DrawableLaneName lane) {
        super(lane.getContainer(), (FlowElement)lane.getModelObject(), DesignerLayer.LANE_COLUMN);
        this.lane = lane;
        this.attachRenderer(LaneBackgroundRenderer.create(lane));
        this.attachRenderer(this);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setWidth(20000);
        this.setHeight(16);
        this.setLocation(new Point(this.getWidth() / 2, this.lane.getBounds().getTop().getY()));
        this.setBackground(Color.valueOf((int)((Lane)this.getModelObject()).getBackgroundColor(), (boolean)true));
    }

    @Override
    public void render() {
        DrawContext context = this.getContext();
        Graphics g = context.getGraphics();
        GraphicsMemento memento = GraphicsMemento.create(g);
        Color background = this.getBackground();
        if (background != null) {
            Graphics graphics = this.getContext().getGraphics();
            Color backgroundColor = background;
            if (this.lane.isShowSelection()) {
                backgroundColor = backgroundColor.darker();
            }
            graphics.setForeground(backgroundColor);
            Rectangle label = this.lane.getBounds();
            Rectangle bounds = this.getContext().scale(Rectangle.valueOf((Point)label.getOrigin(), (int)20000, (int)label.getHeight()));
        }
        g.setForeground(this.getColumnColor());
        g.setStroke(Stroke.TWO_SOLID);
        Point location = context.scale(this.getLocation());
        g.drawLine(0, 0, this.getWidth(), 0);
        g.drawLine(0, location.getY(), this.getWidth(), location.getY());
        memento.restore(g);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        return this.lane.intersects(rectangle);
    }

    public DrawableLaneName getLaneLabel() {
        return this.lane;
    }

    @Override
    public int getRightBound() {
        return 0;
    }

    @Override
    public int getUnderBound() {
        return 0;
    }

    private Color getColumnColor() {
        return Color.GRAY.brighter();
    }
}

