/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowNodeImpl;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class DrawableEvent
extends DrawableFlowNodeImpl<Event> {
    public DrawableEvent(@NotNull DrawableNodeContainer<?> container, @NotNull Event event) {
        super(container, event, ModelUtils.isBoundaryEvent((FlowNode)event) ? DesignerLayer.BOUNDARY : DesignerLayer.EVENT);
    }

    public static Point calculateLocationFromActivity(@NotNull Drawable drawable, @NotNull Point location) {
        Point begin = drawable.getLocation();
        Point end = location;
        while (drawable.contains(end.getX(), end.getY())) {
            if (!begin.equals((Object)(end = new Point(end.getX() + 2 * (end.getX() - begin.getX()), end.getY() + 2 * (end.getY() - begin.getY()))))) continue;
            end = begin.translate(drawable.getWidth(), 0);
            break;
        }
        Line path = new Line(begin, end);
        double point = DrawableHelper.outbound(drawable, (Path)path, true);
        return new Point(path.eval(point));
    }

    public static void updateBoundaries(@NotNull Drawable container, @NotNull Activity activity) {
        DrawableFlowElement drawable = ((DrawableNodeContainer)container).asDrawable((FlowElement)activity);
        for (BoundaryEvent boundary : activity.getActivityBoundaryEvents()) {
            Point calculated;
            Point original = boundary.getLocation();
            if (!(original.distanceSq(calculated = DrawableEvent.calculateLocationFromActivity(drawable, original)) > 2.0)) continue;
            boundary.setLocation(calculated);
        }
    }

    @Override
    protected void initLocation() {
        boolean isBoundary = ((Event)this.getModelObject()).isCatchEvent() && ((CatchEvent)((Event)this.getModelObject()).asAnyNode(CatchEvent.class)).isBoundaryEvent();
        super.initLocation();
        if (isBoundary) {
            DrawableFlowElement activity = this.getContainer().asDrawable((FlowElement)this.getBoundaryActivity());
            Point calculated = DrawableEvent.calculateLocationFromActivity(activity, ((Event)this.getModelObject()).getLocation());
            this.setLocation(calculated);
        }
    }

    private Activity getBoundaryActivity() {
        return ((BoundaryEvent)((Event)this.getModelObject()).asAnyNode(BoundaryEvent.class)).getBoundaryActivity();
    }
}

