/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.compositeutil;

import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.casemgmt.compositeutil.exceptions.CompositeCaseUtilException;
import oracle.bpm.casemgmt.compositeutil.exceptions.CompositeElementAlreadyExists;
import oracle.bpm.casemgmt.compositeutil.exceptions.CompositeElementNotFound;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.catalog.composite.ScaBindingInfoDirect;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;

public class CompositeCaseUtil {
    private ScaController scaController;
    private VFileSystem vFileSystem;
    static final String CASE_SUFFIX = ".case";
    static final String DECISION_SUFFIX = ".decs";
    static final String WSDL_SUFFIX = ".wsdl";
    static final String CASE_SERVICE = "CaseService";
    static final String CASE_WSDL = "CaseService.wsdl";
    static final String CASEMGMT_IMPLEMENTATION = "casemanagement";
    static final String RULES_IMPLEMENTATION = "decision";
    static final String RULES_SERVICE = "IDecisionService";
    static final String ORACLE_NAMESPACE = "http://xmlns.oracle.com/";
    static final String RULES_NAMESPACE = "bpm/case/caseDecision/";
    static final String PORT_TYPE = "PortType";
    static final String SERVICE_SUFFIX = ".service";
    static final String BPMN_TYPE = "BPMN";
    static final String TASK_TYPE = "HWF";
    static final String TASK_SERVICE = "TaskService";
    static final String SERVICE_REFERENCE_SUFFIX = ".service.reference";
    static final String ADD_OPERATION = "add";
    static final String REMOVE_OPERATION = "remove";
    static final String UPDATE_OPERATION = "update";
    static final String WARNING_PREFIX = "CCU INFO: ";
    static final String DIRECTBINDING_SUFFIX = ".directBindingService";
    static final String ORAMDS_CASE_URL = "oramds:/soa/shared/casemgmt/";
    static final String DEFAULT_SOA_HT_SERVICE = "client";

    private CompositeCaseUtil(@NotNull Project project) throws CompositeCaseUtilException {
        if (project == null) {
            throw new CompositeCaseUtilException("Project Cannot be null.");
        }
        this.scaController = CompositeAccessorFactory.createScaController((Project)project);
        this.vFileSystem = project.getWriter().getProjectFileSystem().getDataFileSystem();
    }

    public static CompositeCaseUtil create(@NotNull Project project) throws CompositeCaseUtilException {
        return new CompositeCaseUtil(project);
    }

    public void addCase(@NotNull String caseName) throws CompositeCaseUtilException {
        if (caseName == null || caseName.length() == 0) {
            throw new CompositeCaseUtilException("ComponentName parameter cannot be null or empty.");
        }
        String serviceName = caseName + SERVICE_SUFFIX;
        String directBindingServiceName = caseName + DIRECTBINDING_SUFFIX;
        if (this.alreadyExists(serviceName)) {
            throw new CompositeElementAlreadyExists("Service " + serviceName + " already exists.");
        }
        String wsdlLocation = "oramds:/soa/shared/casemgmt/CaseService.wsdl";
        String requestPortTypeStr = "CaseServicePortType";
        String nameSpace = "http://xmlns.oracle.com/CaseService";
        QName requestPortType = new QName("http://xmlns.oracle.com/CaseService", "CaseServicePortType");
        ScaWsdlInfo scaWsdlInfo = new ScaWsdlInfo(wsdlLocation, requestPortType, null);
        if (this.alreadyExists(caseName)) {
            throw new CompositeElementAlreadyExists("Component " + caseName + " already exists.");
        }
        String componentType = CASEMGMT_IMPLEMENTATION;
        String sourcePath = "case/" + caseName + CASE_SUFFIX;
        this.scaController.createComponent(caseName, componentType, sourcePath);
        this.scaController.addService(caseName, serviceName, scaWsdlInfo);
        this.scaController.addServiceEntrypoint(serviceName, scaWsdlInfo);
        this.scaController.addWire(serviceName, null, caseName, serviceName);
        ScaBindingInfoDirect scaDirectBindingInfo = new ScaBindingInfoDirect();
        this.scaController.commitChanges();
    }

    public void addActivityToCase(@NotNull String caseName, @NotNull String processOrTask, @NotNull String activityType) throws CompositeCaseUtilException {
        if (caseName == null || caseName.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot add " + processOrTask + " to " + caseName + ". caseName cannot be null.");
        }
        if (processOrTask == null || processOrTask.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot add " + processOrTask + " to " + caseName + ". processOrTask cannot be null.");
        }
        if (activityType == null || activityType.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot add " + processOrTask + " to " + caseName + ". activityType cannot be null.");
        }
        if (!this.alreadyExists(caseName)) {
            throw new CompositeElementNotFound("Cannot add " + processOrTask + " to " + caseName + ". Case " + caseName + " does not exist.");
        }
        if (!this.alreadyExists(processOrTask)) {
            throw new CompositeElementNotFound("Cannot add " + processOrTask + " to " + caseName + ". CaseActivity " + processOrTask + " does not exist.");
        }
        String targetService = this.findTargetService(caseName, processOrTask, activityType, ADD_OPERATION);
        String sourceReferenceName = processOrTask + SERVICE_REFERENCE_SUFFIX;
        if (this.wireAlreadyExists(caseName, sourceReferenceName, processOrTask, targetService)) {
            throw new CompositeElementAlreadyExists("Cannot add " + processOrTask + " to " + caseName + ". Wire " + caseName + "/" + sourceReferenceName + " -> " + processOrTask + "/" + targetService + " already exists.");
        }
        ScaWsdlInfo scaWsdlInfo = this.scaController.getWsdlInfoForName(processOrTask, targetService);
        this.scaController.addReference(caseName, sourceReferenceName, scaWsdlInfo);
        this.scaController.addWire(caseName, sourceReferenceName, processOrTask, targetService);
        this.scaController.commitChanges();
    }

    public void removeActivityFromCase(@NotNull String caseName, @NotNull String processOrTask, @NotNull String activityType) throws CompositeCaseUtilException {
        this.updateRemoveCaseActivity(caseName, processOrTask, activityType, REMOVE_OPERATION);
    }

    public void updateCaseActivityInCase(@NotNull String caseName, @NotNull String process) throws CompositeCaseUtilException {
        this.updateRemoveCaseActivity(caseName, process, BPMN_TYPE, UPDATE_OPERATION);
    }

    public boolean alreadyExists(@NotNull String componentName) {
        return !this.scaController.isNameUniqueWithinComposite(componentName);
    }

    public VFileSystem getVFileSystem() {
        return this.vFileSystem;
    }

    public void removeCase(@NotNull String caseName) throws CompositeCaseUtilException {
        if (caseName == null || caseName.length() == 0) {
            throw new CompositeElementNotFound("ComponentName parameter cannot be null or empty.");
        }
        String serviceName = caseName + SERVICE_SUFFIX;
        String directBindingServiceName = caseName + DIRECTBINDING_SUFFIX;
        if (!this.alreadyExists(serviceName)) {
            CompositeCaseUtil.warn("Service " + serviceName + " does not exists.");
        }
        this.scaController.deleteServiceEntrypoint(serviceName);
        this.scaController.deleteServiceEntrypoint(directBindingServiceName);
        try {
            this.scaController.deleteComponent(caseName);
        }
        catch (IllegalArgumentException e) {
            CompositeCaseUtil.warn("Could not delete component " + caseName + " from composite. " + e.getMessage());
        }
        this.scaController.commitChanges();
    }

    public void addCaseRulesIntegration(@NotNull String caseName) throws CompositeCaseUtilException {
        if (caseName == null || caseName.length() == 0) {
            throw new CompositeCaseUtilException("Cannot create Rules integration for case.  ComponentName parameter cannot be null or empty.");
        }
        if (!this.alreadyExists(caseName)) {
            throw new CompositeElementAlreadyExists("Cannot create Rules integration for case.  Case " + caseName + " does not exists.");
        }
        String ruleComponentName = caseName + "Rules";
        String componentType = RULES_IMPLEMENTATION;
        String serviceName = ruleComponentName + "_" + ruleComponentName;
        String sourcePath = ruleComponentName + DECISION_SUFFIX;
        String wsdlLocation = serviceName + WSDL_SUFFIX;
        String requestPortTypeStr = RULES_SERVICE;
        String nameSpace = "http://xmlns.oracle.com/bpm/case/caseDecision/" + serviceName;
        QName requestPortType = new QName(nameSpace, RULES_SERVICE);
        ScaWsdlInfo scaWsdlInfo = new ScaWsdlInfo(wsdlLocation, requestPortType, null);
        QName replyPortType = requestPortType;
        ScaWsdlInfo scaWsdlInfoWithCallback = new ScaWsdlInfo(wsdlLocation, requestPortType, replyPortType);
        if (this.alreadyExists(ruleComponentName)) {
            throw new CompositeElementAlreadyExists("Cannot create Rules integration for case " + caseName + ".  Rules component " + ruleComponentName + " already exists.");
        }
        this.scaController.createComponent(ruleComponentName, RULES_IMPLEMENTATION, sourcePath);
        this.scaController.addService(ruleComponentName, serviceName, scaWsdlInfo);
        this.scaController.addReference(caseName, serviceName, scaWsdlInfoWithCallback);
        this.scaController.addServiceEntrypoint(serviceName, scaWsdlInfo);
        this.scaController.deleteServiceEntrypoint(serviceName);
        this.scaController.addWire(caseName, serviceName, ruleComponentName, serviceName);
        this.scaController.commitChanges();
    }

    public void removeCaseRulesIntegration(@NotNull String caseName) throws CompositeCaseUtilException {
        if (caseName == null || caseName.length() == 0) {
            throw new CompositeCaseUtilException("Cannot delete Rules integration for case.  ComponentName parameter cannot be null or empty.");
        }
        if (!this.alreadyExists(caseName)) {
            CompositeCaseUtil.warn("Warning deleting Rules integration for case.  Case " + caseName + " does not exists.");
        }
        String ruleComponentName = caseName + "Rules";
        String serviceName = ruleComponentName + "_" + ruleComponentName;
        try {
            this.scaController.deleteReference(caseName, serviceName);
        }
        catch (Exception e) {
            CompositeCaseUtil.warn("Warning deleting Rules integration for case.  Case " + caseName + ". Deleting service reference: " + serviceName);
        }
        if (!this.alreadyExists(ruleComponentName)) {
            CompositeCaseUtil.warn("Cannot delete Rules integration for case " + caseName + ".  Rules component " + ruleComponentName + " does not already exists.");
            return;
        }
        this.scaController.deleteService(ruleComponentName, serviceName);
        this.scaController.deleteComponent(ruleComponentName);
        this.scaController.commitChanges();
    }

    private static void warn(String message) {
        System.out.println(WARNING_PREFIX + message);
        System.err.println(WARNING_PREFIX + message);
    }

    private static String getDefaultServiceName(@NotNull String caseName, @NotNull String processOrTaskName, @NotNull String activityType, @NotNull String operation) throws CompositeCaseUtilException {
        String defaultServiceName;
        if (activityType.equals(BPMN_TYPE)) {
            defaultServiceName = processOrTaskName + SERVICE_SUFFIX;
        } else if (activityType.equals(TASK_TYPE)) {
            defaultServiceName = TASK_SERVICE;
        } else {
            throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTaskName + " from " + caseName + ". activityType is invalid: " + activityType);
        }
        return defaultServiceName;
    }

    private String findTargetService(@NotNull String caseName, @NotNull String processOrTaskName, @NotNull String activityType, @NotNull String operation) throws CompositeCaseUtilException {
        String targetService = null;
        String defaultServiceName = CompositeCaseUtil.getDefaultServiceName(caseName, processOrTaskName, activityType, operation);
        if (this.alreadyExists(processOrTaskName, defaultServiceName)) {
            targetService = defaultServiceName;
        } else {
            List seviceList = this.scaController.getComponentServices(processOrTaskName);
            if (seviceList == null || seviceList.isEmpty()) {
                throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTaskName + " from " + caseName + ". " + defaultServiceName + ". seviceList is null or empty.");
            }
            targetService = seviceList.size() > 1 && seviceList.contains(DEFAULT_SOA_HT_SERVICE) ? DEFAULT_SOA_HT_SERVICE : (String)seviceList.iterator().next();
            if (targetService == null || targetService.trim().length() == 0) {
                throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTaskName + " from " + caseName + ". targetService is null or empty.");
            }
            if (!this.alreadyExists(processOrTaskName, targetService)) {
                throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTaskName + " from " + caseName + ". " + targetService + " is not present in " + processOrTaskName);
            }
        }
        return targetService;
    }

    private boolean alreadyExists(@NotNull String componentName, @NotNull String serviceName) {
        return !this.scaController.isNameUniqueWithinComponent(componentName, serviceName);
    }

    private void updateRemoveCaseActivity(@NotNull String caseName, @NotNull String processOrTask, @NotNull String activityType, @NotNull String operation) throws CompositeCaseUtilException {
        String msg;
        if (operation == null || !operation.equals(REMOVE_OPERATION) && !operation.equals(UPDATE_OPERATION)) {
            throw new CompositeCaseUtilException("Cannot proceed with updateRemoveCaseActivity " + processOrTask + " from " + caseName + ". operation parameter is not valid:" + operation);
        }
        if (caseName == null || caseName.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTask + " at " + caseName + ". caseName cannot be null.");
        }
        if (processOrTask == null || processOrTask.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTask + " at " + caseName + ". processOrTask cannot be null.");
        }
        if (activityType == null || activityType.trim().length() == 0) {
            throw new CompositeCaseUtilException("Cannot " + operation + " " + processOrTask + " at " + caseName + ". activityType cannot be null.");
        }
        if (!this.alreadyExists(caseName)) {
            msg = operation + " " + processOrTask + " at " + caseName + ". Case " + caseName + " does not exist.";
            if (operation.equals(UPDATE_OPERATION)) {
                throw new CompositeElementNotFound(msg);
            }
            CompositeCaseUtil.warn(msg);
        }
        if (!this.alreadyExists(processOrTask)) {
            msg = operation + " " + processOrTask + " at " + caseName + ". CaseActivity " + processOrTask + " does not exist.";
            if (operation.equals(UPDATE_OPERATION)) {
                throw new CompositeElementNotFound(msg);
            }
            CompositeCaseUtil.warn(msg);
        }
        String targetService = this.findTargetService(caseName, processOrTask, activityType, operation);
        String sourceReferenceName = processOrTask + SERVICE_REFERENCE_SUFFIX;
        if (!this.wireAlreadyExists(caseName, sourceReferenceName, processOrTask, targetService)) {
            String msg2 = operation + " " + processOrTask + " at " + caseName + ". Wire " + caseName + "/" + sourceReferenceName + " -> " + processOrTask + "/" + targetService + " not found.";
            if (operation.equals(UPDATE_OPERATION)) {
                throw new CompositeElementNotFound(msg2);
            }
            CompositeCaseUtil.warn(msg2);
        }
        try {
            this.scaController.deleteReference(caseName, sourceReferenceName);
        }
        catch (IllegalArgumentException e) {
            CompositeCaseUtil.warn("Could not delete reference " + sourceReferenceName + " on case " + sourceReferenceName + " from composite. " + e.getMessage());
        }
        if (operation.equals(UPDATE_OPERATION)) {
            ScaWsdlInfo scaWsdlInfo = this.scaController.getWsdlInfoForName(processOrTask, targetService);
            this.scaController.addReference(caseName, sourceReferenceName, scaWsdlInfo);
            this.scaController.addWire(caseName, sourceReferenceName, processOrTask, targetService);
        }
        this.scaController.commitChanges();
    }

    private boolean wireAlreadyExists(@NotNull String caseName, @NotNull String sourceReferenceName, @NotNull String processOrTaskName, @NotNull String targetService) {
        List wires = this.scaController.getWireSourcesByTarget(processOrTaskName, targetService);
        String newSource = caseName + "/" + sourceReferenceName;
        for (String aWire : wires) {
            if (!aWire.equals(newSource)) continue;
            return true;
        }
        return false;
    }
}

