/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bpm.fusion.internal.views.BaseTimerPanel;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.tree.Tree;
import oracle.ide.help.Helpable;
import oracle.ideimpl.explorer.ExplorerNode;

public class UiSpyView
extends BaseView {
    private static UiSpyView instance;
    static final String VIEW_ID = "SpyWindow";

    private UiSpyView() {
        super(VIEW_ID);
    }

    public static UiSpyView getInstance() {
        if (instance == null) {
            instance = new UiSpyView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Ui Spy");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        return SpyViewer.create(parent);
    }

    private static class SpyViewer
    extends Panel {
        private static final String TAB = "    ";

        SpyViewer(UiContainer parent) {
            super(parent);
            this.init();
        }

        public static SpyViewer create(UiContainer parent) {
            return new SpyViewer(parent);
        }

        private static String getUiInformation() {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            Component c = null;
            if (w != null) {
                Point pt = SpyViewer.getMousePointer(w);
                c = SwingUtilities.getDeepestComponentAt(w, pt.x, pt.y);
            }
            return c != null ? SpyViewer.getInfo(c) : "<Nothing>";
        }

        private static Point getMousePointer(Component c) {
            PointerInfo info = MouseInfo.getPointerInfo();
            Point pt = info.getLocation();
            SwingUtilities.convertPointFromScreen(pt, c);
            return pt;
        }

        private static String getInfo(Component component) {
            String result = "Component:\n";
            result = result + SpyViewer.getComponentInfo(component) + "\n";
            Container parent = component.getParent();
            if (parent != null) {
                result = result + "\nParent:\n";
                ArrayList<Container> list = new ArrayList<Container>();
                while (parent != null) {
                    list.add(parent);
                    parent = parent.getParent();
                }
                String prefix = "";
                for (Component component2 : list) {
                    result = result + prefix + SpyViewer.getComponentInfo(component2) + "\n";
                    prefix = prefix + TAB;
                }
            }
            return result;
        }

        private static String getComponentInfo(Component component) {
            String componentName;
            Object treeNode;
            TreePath path;
            Point pt;
            JTree tree;
            UiComponent uiComponent = UiComponent.get((Object)component);
            if (uiComponent != null && uiComponent.isWrapper()) {
                uiComponent = null;
            }
            String treeInfo = "";
            if (component instanceof JTree) {
                tree = (JTree)component;
                pt = SpyViewer.getMousePointer(component);
                path = tree.getPathForLocation(pt.x, pt.y);
                Object object = treeNode = path == null ? null : path.getLastPathComponent();
                if (treeNode != null) {
                    treeInfo = "\n\tTreeNode: " + treeNode.getClass();
                    if (treeNode instanceof ExplorerNode) {
                        ExplorerNode explorerNode = (ExplorerNode)treeNode;
                        treeInfo = treeInfo + " [" + treeNode + ", " + explorerNode.getData().getClass() + "]";
                    }
                }
            }
            if (uiComponent instanceof Tree) {
                tree = (Tree)uiComponent;
                pt = SpyViewer.getMousePointer(component);
                path = tree.getPathForLocation(pt.x, pt.y);
                Object object = treeNode = path == null ? null : path.getLastPathComponent();
                if (treeNode != null) {
                    treeInfo = "\n\tUi TreeNode: " + treeNode.getClass();
                }
            }
            String contextHelpId = null;
            if (component instanceof Helpable) {
                Helpable helpable = (Helpable)component;
                contextHelpId = helpable.getHelpInfo().getHelpTopicID();
            }
            String contextHelpInfo = contextHelpId != null ? " Help Id: " + contextHelpId : "";
            String uiHelpId = "";
            String componentClass = "NONE";
            String prefSize = "N/A";
            String layoutName = "";
            if (uiComponent != null) {
                componentClass = uiComponent.getClass().getName();
                prefSize = uiComponent.getPreferredSize().toString();
                if (uiComponent instanceof UiContainer) {
                    Layout layout = ((UiContainer)uiComponent).getLayout();
                    if (layout != null) {
                        layoutName = "\n\tLayout: " + layout.getClass().getSimpleName();
                    }
                    uiHelpId = " Ui Help Id: " + uiComponent.getHelpId();
                }
            }
            if ((componentName = component.getClass().getName()).startsWith("fuego") || componentName.startsWith("java")) {
                componentName = component.getClass().getSimpleName();
            }
            return "UiComponent: " + componentClass + " Swing: " + componentName + contextHelpInfo + uiHelpId + treeInfo + layoutName;
        }

        private void init() {
            this.setLayout((Layout)new BorderLayout());
            BaseTimerPanel panel = new BaseTimerPanel((UiContainer)this, false){

                @Override
                protected String getText() {
                    return SpyViewer.getUiInformation();
                }
            };
            this.add((UiComponent)panel, "Center");
        }
    }
}

