/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import oracle.bpm.draw.Font;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.script.ScriptUtil;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.ide.Ide;

public class ScriptDebugView
extends BaseView {
    private static ScriptDebugView instance;
    static final String VIEW_ID = "ScriptDebugWindow";

    private ScriptDebugView() {
        super(VIEW_ID);
    }

    public static ScriptDebugView getInstance() {
        if (instance == null) {
            instance = new ScriptDebugView();
        }
        return instance;
    }

    @Override
    protected Msg getMsg() {
        return Msg.QUOTE("Script Debug Pane");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        return UiComponent.get((Object)((Object)new ScriptDebugPanel(parent)));
    }

    private static class ScriptDebugPanel
    extends Panel {
        private TextArea textArea;

        ScriptDebugPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private void init() {
            this.setLayout((Layout)new BorderLayout());
            this.textArea = new TextArea((UiContainer)this);
            this.textArea.setAutoscrolls(false);
            this.textArea.setFont(Font.MONOSPACED);
            ToolBar toolBar = new ToolBar((UiContainer)this, ToolBar.Orientation.VERTICAL);
            BaseAction startAction = new BaseAction(UIMsg.LEFT_ARROW){

                public void run() {
                    ScriptDebugPanel.this.runScript();
                }
            };
            BaseAction clearAction = new BaseAction(UIMsg.CLEAR){

                public void run() {
                    ScriptDebugPanel.this.clear();
                }
            };
            ToolBarItem toolBarItem = toolBar.add(startAction, ToolBar.OPTIONS);
            toolBarItem.setToolTipText("Run Script");
            toolBarItem = toolBar.add(clearAction, ToolBar.OPTIONS);
            toolBarItem.setToolTipText("Clear");
            this.add((UiComponent)toolBar, "East");
            this.add((UiComponent)this.textArea, "Center");
        }

        private void clear() {
            this.textArea.setText("");
        }

        private void runScript() {
            Project project = JdevRepositoryService.getInstance().getProject(Ide.getActiveProject());
            if (project != null) {
                ScriptUtil.execute((ComponentCatalog)project.getComponentCatalog(), (String)this.textArea.getText());
            }
        }
    }
}

