/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import javax.swing.JOptionPane;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.JDevDictionaryFileBuilder;

public class RulesIntegrationView
extends BaseView {
    private static RulesIntegrationView instance;
    static final String VIEW_ID = "RulesIntegrationWindow";

    private RulesIntegrationView() {
        super(VIEW_ID);
    }

    public static RulesIntegrationView getInstance() {
        if (instance == null) {
            instance = new RulesIntegrationView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Rules Integration");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        Panel panel = new Panel(parent);
        MigLayout layout = new MigLayout("wrap 2");
        panel.setLayout((Layout)layout);
        final TextField ruleTextField = new TextField((UiContainer)panel, "MyRule", 30);
        final TextField packageTextField = new TextField((UiContainer)panel, "mypackage", 30);
        CheckBox decisionFunctionCheckBox = CheckBox.create((UiContainer)panel, (Msg)Msg.QUOTE("Decision Function"));
        BaseAction createAction = new BaseAction(Msg.QUOTE("Create Rule")){

            public void run() {
                Project project = Ide.getActiveProject();
                RulesIntegrationView.this.createRule(project, ruleTextField.getText(), packageTextField.getText());
            }
        };
        Button createRuleButton = new Button((UiContainer)panel, createAction);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)Msg.QUOTE("Name")));
        panel.add((UiComponent)ruleTextField);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)Msg.QUOTE("Package")));
        panel.add((UiComponent)packageTextField);
        panel.add((UiComponent)decisionFunctionCheckBox, (Object)"wrap");
        panel.add((UiComponent)createRuleButton);
        return panel;
    }

    private void createRule(Project project, String ruleName, String packageName) {
        WizardData data = new WizardData();
        data.setName(ruleName);
        data.setPackageName(packageName);
        JDevDictionaryFileBuilder builder = new JDevDictionaryFileBuilder(project);
        builder.createRuleDictionary(data);
        JOptionPane.showMessageDialog(null, "Rule '" + ruleName + "' CREATED OK in Project '" + project.getShortLabel() + "'");
    }
}

