/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.fusion.internal.views.AbstractEventsViewer;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.util.StackTrace;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public class ProjectEventsSpyView
extends BaseView {
    private ProjectEventsViewer eventsViewer;
    private static ProjectEventsSpyView instance;
    static final String VIEW_ID = "ProjectEventsSpyWindow";

    private ProjectEventsSpyView() {
        super(VIEW_ID);
    }

    public static ProjectEventsSpyView getInstance() {
        if (instance == null) {
            instance = new ProjectEventsSpyView();
        }
        return instance;
    }

    @Override
    protected Msg getMsg() {
        return Msg.QUOTE("Project Events Spy View");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        this.eventsViewer = new ProjectEventsViewer(parent);
        return UiComponent.get((Object)((Object)this.eventsViewer));
    }

    @Override
    protected void onCloseView() {
        this.eventsViewer.stopListening();
    }

    private static class ProjectEventsViewer
    extends AbstractEventsViewer {
        private oracle.bpm.project.model.Project bpmProject;
        private ProjectListener<ResourceObject> projectListener;
        private CheckBox showCatalogObjectImplCheckBox;
        private CheckBox showStacktraceCheckBox;

        ProjectEventsViewer(UiContainer parent) {
            super(parent);
        }

        @Override
        protected UiComponent buildHeaderPanel(UiContainer parent) {
            ToolBar toolBar = new ToolBar(parent);
            this.showStacktraceCheckBox = CheckBox.create((UiContainer)toolBar, (Msg)Msg.QUOTE("Show Stacktrace"), (boolean)false);
            toolBar.add((UiComponent)this.showStacktraceCheckBox);
            this.showCatalogObjectImplCheckBox = CheckBox.create((UiContainer)toolBar, (Msg)Msg.QUOTE("Show CatalogObjectImpl events"), (boolean)true);
            toolBar.add((UiComponent)this.showCatalogObjectImplCheckBox);
            return toolBar;
        }

        @Override
        protected boolean startListening(Workspace workspace, Project project) {
            boolean result = false;
            FusionProjectRepository repository = (FusionProjectRepository)AbstractStudioWorkbench.getInstance().getRepository();
            this.bpmProject = repository.getProject(project);
            if (this.bpmProject != null) {
                this.bpmProject.addListener(this.getProjectListener());
                result = true;
            } else {
                this.show("ERROR: BPM Project is NULL. Project '" + project.getShortLabel() + "' not found in repository '" + repository.getWorkspace().getShortLabel() + "'");
            }
            return result;
        }

        @Override
        protected boolean stopListening(Workspace workspace, Project project) {
            boolean result = false;
            if (this.bpmProject != null && this.projectListener != null) {
                this.bpmProject.removeListener(this.projectListener);
                this.bpmProject = null;
                this.projectListener = null;
                result = true;
            }
            return result;
        }

        protected ProjectListener<ResourceObject> getProjectListener() {
            if (this.projectListener == null) {
                this.projectListener = new BatchProjectListenerAdapter<ResourceObject>(ResourceObject.class){

                    public void processPostEvents(ProjectEventSet events) {
                        ProjectEventsViewer.this.show("EventSet: " + events.size());
                        for (ProjectEvent event : events) {
                            ProjectObject po = event.getProjectObject();
                            boolean showCatalog = ProjectEventsViewer.this.showCatalogObjectImplCheckBox.isSelected();
                            boolean isCatalogObject = po instanceof CatalogObjectImpl;
                            boolean isValid = !isCatalogObject || showCatalog;
                            if (!isValid) continue;
                            if (event.getType() == ProjectEvent.Type.CHANGE) {
                                ProjectEventsViewer.this.show("  CHANGE->" + event.toString());
                            } else if (event.getType() == ProjectEvent.Type.POST_ADD) {
                                ProjectEventsViewer.this.show("  ADD->" + event.toString());
                            } else if (event.getType() == ProjectEvent.Type.POST_REMOVE) {
                                ProjectEventsViewer.this.show("  REMOVE->" + event.toString());
                            }
                            if (!ProjectEventsViewer.this.showStacktraceCheckBox.isSelected()) continue;
                            String st = StackTrace.getStackTrace();
                            ProjectEventsViewer.this.show("      " + st);
                        }
                    }
                };
            }
            return this.projectListener;
        }
    }
}

