/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public class NodeFactoryCacheView
extends BaseView {
    private static NodeFactoryCacheView instance;
    static final String VIEW_ID = "NodeFactoryInfoWindow";

    private NodeFactoryCacheView() {
        super(VIEW_ID);
    }

    public static NodeFactoryCacheView getInstance() {
        if (instance == null) {
            instance = new NodeFactoryCacheView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("NodeFactory Info");
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        TabbedPane tabbedPane = new TabbedPane(parent);
        tabbedPane.addTab("Cached Nodes", this.createViewerPanel((UiContainer)tabbedPane, NodeModel.createCachedModel()));
        tabbedPane.addTab("Loaded Nodes", this.createViewerPanel((UiContainer)tabbedPane, NodeModel.createLoadedModel()));
        tabbedPane.addTab("Open Nodes", this.createViewerPanel((UiContainer)tabbedPane, NodeModel.createOpenModel()));
        return tabbedPane;
    }

    private UiComponent createViewerPanel(UiContainer parent, NodeModel model) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0, wrap 1"));
        Table table = new Table((UiContainer)panel, (TableModel)model);
        LabelProvider.Default<Node> labelProvider = new LabelProvider.Default<Node>(){

            public String getText(Node element) {
                return element.getShortLabel();
            }

            public Image getIcon(Node element) {
                Icon icon = element.getIcon();
                return icon != null ? Image.create((Icon)icon) : null;
            }
        };
        table.getColumn(0).setLabelProvider((LabelProvider)labelProvider);
        table.getColumn(1).setWidth(5);
        table.getColumn(2).setWidth(5);
        UiComponent toolBarPanel = this.createToolBarPanel((UiContainer)panel, model);
        panel.add(toolBarPanel, (Object)"growx");
        panel.add((UiComponent)table, (Object)"grow");
        return panel;
    }

    private UiComponent createToolBarPanel(UiContainer parent, final NodeModel model) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
        ToolBar toolBar = new ToolBar((UiContainer)panel);
        BaseAction refreshAction = new BaseAction(UIMsg.REFRESH){

            public void run() {
                model.refresh();
            }
        };
        toolBar.add(refreshAction);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)Msg.QUOTE("")), (Object)"growx");
        panel.add((UiComponent)toolBar, (Object)"wrap");
        return panel;
    }

    private static abstract class NodeModel
    extends ProviderTableModel<Node> {
        private static final MsgList TITLES = MsgList.create(Msg.QUOTE("Short Label"), Msg.QUOTE("Dirty"), Msg.QUOTE("May Have Children"), Msg.QUOTE("URL"), Msg.QUOTE("Class"));
        private static final int COLUMN_NODE = 0;
        private static final int COLUMN_DIRTY = 1;
        private static final int COLUMN_MAYHAVECHILDREN = 2;
        private static final int COLUMN_URL = 3;
        private static final int COLUMN_CLASS = 4;

        NodeModel() {
            super(TITLES);
            this.populate();
        }

        public static NodeModel createCachedModel() {
            return new NodeCachedModel();
        }

        public static NodeModel createLoadedModel() {
            return new NodeLoadedModel();
        }

        public static NodeModel createOpenModel() {
            return new NodeOpenModel();
        }

        public Object getValueAt(int row, int column) {
            Node node = (Node)this.getRow(row);
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    return node.isDirty();
                }
                case 2: {
                    return node.mayHaveChildren();
                }
                case 3: {
                    return node.getURL().toString();
                }
                case 4: {
                    return node.getClass().getName() + "@" + node.hashCode();
                }
            }
            return "";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Node.class;
                }
                case 1: 
                case 2: {
                    return Boolean.class;
                }
                case 3: 
                case 4: {
                    return String.class;
                }
            }
            return Object.class;
        }

        abstract Iterator<Node> getNodes();

        void populate() {
            Iterator<Node> it = this.getNodes();
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (it.hasNext()) {
                nodes.add(it.next());
            }
            this.addRows(CollectionUtils.sort(nodes, this.getComparator()));
        }

        void refresh() {
            this.removeAllElements();
            this.populate();
        }

        private Comparator<Node> getComparator() {
            return new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.getShortLabel().compareTo(o2.getShortLabel());
                }
            };
        }

        private static class NodeOpenModel
        extends NodeModel {
            private NodeOpenModel() {
            }

            @Override
            Iterator<Node> getNodes() {
                return NodeFactory.getOpenNodes();
            }
        }

        private static class NodeLoadedModel
        extends NodeModel {
            private NodeLoadedModel() {
            }

            @Override
            Iterator<Node> getNodes() {
                return NodeFactory.getLoadedNodes();
            }
        }

        private static class NodeCachedModel
        extends NodeModel {
            private NodeCachedModel() {
            }

            @Override
            Iterator<Node> getNodes() {
                return NodeFactory.getCachedNodes();
            }
        }
    }
}

