/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.io.File;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.selection.DesignerSelection;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.fusion.internal.views.BaseView;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.humantask.HumanTaskPanel;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceManager;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.soa.humantask.Factory;
import oracle.bpm.soa.humantask.HumanTaskBpm;
import oracle.bpm.soa.humantask.IdentityType;
import oracle.bpm.soa.humantask.Participant;
import oracle.bpm.soa.humantask.Participants;
import oracle.bpm.soa.humantask.Payload;
import oracle.bpm.soa.humantask.Resource;
import oracle.bpm.soa.humantask.RoutingSlip;
import oracle.bpm.soa.humantask.RoutingSlipFactory;
import oracle.bpm.soa.humantask.Title;
import oracle.bpm.soa.humantask.ValueType;
import oracle.bpm.soa.humantask.WorkflowConfiguration;
import oracle.bpm.soa.io.IOFactory;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.ui.text.TextField;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.editor.outcomes.OutComesDataUtil;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;

public class HumanTaskIntegrationView
extends BaseView {
    private HumanTaskIntegrationCardPanel cardPanel;
    private SelectionListener processSelectionListener;
    private ProcessDomain selectedProcessDomain;
    private SelectionListener selectionListener;
    private static final String OUTPUT_DIR = "/home/ale/Desktop";
    private static final String TASK_DEFINITION = "MyTaskDefinition";
    private static HumanTaskIntegrationView instance;
    static final String VIEW_ID = "HumanTaskIntegrationWindow";

    private HumanTaskIntegrationView() {
        super(VIEW_ID);
    }

    public static HumanTaskIntegrationView getInstance() {
        if (instance == null) {
            instance = new HumanTaskIntegrationView();
        }
        return instance;
    }

    @Override
    public Msg getMsg() {
        return Msg.QUOTE("Human Task Integration");
    }

    @Override
    protected void onCloseView() {
        this.stopListening();
    }

    @Override
    protected void onShowView() {
        this.startListening();
    }

    @Override
    protected UiComponent createView(UiContainer parent) {
        this.cardPanel = new HumanTaskIntegrationCardPanel(parent);
        this.processSelectionListener = new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                UserTask userTask = HumanTaskIntegrationView.getUserTaskFromSelection(newSelection);
                HumanTaskIntegrationView.this.cardPanel.show(userTask);
            }
        };
        return this.cardPanel;
    }

    private static UserTask getUserTaskFromSelection(Selection newSelection) {
        UserTask result = null;
        FlowNode flowNode = (FlowNode)newSelection.as(FlowNode.class);
        if (flowNode != null && flowNode.isActivity() && ((Activity)flowNode).isUserTask()) {
            result = (UserTask)flowNode.asAnyNode(UserTask.class);
        }
        return result;
    }

    private static SelectionProvider getEditorAreaSelectionProvider() {
        StudioWorkbench studioWorkbench = AbstractStudioWorkbench.getInstance();
        return studioWorkbench.getEditorAreaSelectionProvider();
    }

    private void stopListening() {
        this.stopProcessListening();
        if (this.selectionListener != null) {
            HumanTaskIntegrationView.getEditorAreaSelectionProvider().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    private void stopProcessListening() {
        if (this.selectedProcessDomain != null) {
            this.selectedProcessDomain.getSelectionProvider().removeSelectionListener(this.processSelectionListener);
            this.selectedProcessDomain = null;
        }
    }

    private void startListening() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void selectionChanged(Selection newSelection) {
                    HumanTaskIntegrationView.this.editorChanged(newSelection);
                }
            };
            SelectionProvider selectionProvider = HumanTaskIntegrationView.getEditorAreaSelectionProvider();
            selectionProvider.addSelectionListener(this.selectionListener);
            Selection defaultSelection = selectionProvider.getSelection();
            this.editorChanged(defaultSelection);
        }
    }

    private void editorChanged(Selection newSelection) {
        Process process = (Process)newSelection.as(Process.class);
        this.stopProcessListening();
        UserTask userTask = null;
        if (process != null) {
            this.selectedProcessDomain = Context.getDomainFor((Process)process);
            if (this.selectedProcessDomain != null) {
                DesignerSelectionProvider selectionProvider = this.selectedProcessDomain.getSelectionProvider();
                selectionProvider.addSelectionListener(this.processSelectionListener);
                DesignerSelection designerSelection = selectionProvider.getSelection();
                userTask = HumanTaskIntegrationView.getUserTaskFromSelection((Selection)designerSelection);
            }
        }
        this.cardPanel.show(userTask);
    }

    private static class XMLSchema {
        private static final String URI = "http://www.w3.org/2001/XMLSchema";
        public static QName[] TYPES = new QName[36];
        public static final QName QNAME_STRING = XMLSchema.makeQName("http://www.w3.org/2001/XMLSchema", "string");
        public static final QName QNAME_INTEGER = XMLSchema.makeQName("http://www.w3.org/2001/XMLSchema", "integer");
        public static final QName QNAME_BOOLEAN = XMLSchema.makeQName("http://www.w3.org/2001/XMLSchema", "boolean");

        private XMLSchema() {
        }

        private static QName makeQName(String ns, String local) {
            return new QName(ns, local);
        }

        static {
            int i = 0;
            XMLSchema.TYPES[i++] = QNAME_STRING;
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "normalizedString");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "token");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "byte");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "unsignedByte");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "base64Binary");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "hexBinary");
            XMLSchema.TYPES[i++] = QNAME_INTEGER;
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "positiveInteger");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "negativeInteger");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "nonNegativeInteger");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "nonPositiveInteger");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "int");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "unsignedInt");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "long");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "unsignedLong");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "short");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "unsignedShort");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "decimal");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "float");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "double");
            XMLSchema.TYPES[i++] = QNAME_BOOLEAN;
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "time");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "dateTime");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "duration");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "date");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "gMonth");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "gYear");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "gYearMonth");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "gDay");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "gMonthDay");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "Name");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "QName");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "NCName");
            XMLSchema.TYPES[i++] = XMLSchema.makeQName(URI, "anyURI");
            XMLSchema.TYPES[i] = XMLSchema.makeQName(URI, "language");
        }
    }

    private static class HumanTaskIntegrationPanel
    extends Panel {
        private BaseAction applyAction;
        private BaseAction deleteAction;
        private Label editorModeLabel;
        private CheckBox saveCopy;
        private TextField targetTextField;
        private UserTask userTask;
        private static final String BPM_PERFORMER = "bpm:getPerformer()";

        public HumanTaskIntegrationPanel(UiContainer parent, UserTask userTask) {
            super(parent);
            this.userTask = userTask;
            this.init();
        }

        public void setUserTask(UserTask userTask) {
            this.userTask = userTask;
            this.updateEditorMode();
        }

        private static void updateWorkflowConfiguration(WorkflowConfiguration wc, Collection<String> outcomesValues) {
            WorkflowConfiguration.Outcomes outcomes = wc.getOutcomes();
            outcomes.setValues(CollectionUtils.asSequence(outcomesValues));
        }

        private static void updateRoutingSlip(RoutingSlip rs) {
            RoutingSlipFactory routingSlipFactory = Factory.task().routingSlip();
            Participants participants = routingSlipFactory.createParticipants();
            Participants.Stage stage = routingSlipFactory.createStage("MyStageName");
            Participant.Single single = routingSlipFactory.createSingle("MySingleName");
            Participant.ParallelBlock parallel = routingSlipFactory.createParallelBlock("MyParallelBlock");
            RoutingSlip routingSlip1 = routingSlipFactory.createRoutingSlip();
            Participants participants1 = routingSlipFactory.createParticipants();
            Participant.Fyi fyi1 = routingSlipFactory.createFyi("MyFyiName1");
            Resource resource = routingSlipFactory.createResource();
            resource.setType(ValueType.XPATH);
            resource.setIdentityType(IdentityType.APPLICATION_ROLE);
            resource.setValue(BPM_PERFORMER);
            fyi1.addResource(resource);
            Participant.Single single1 = routingSlipFactory.createSingle("MySingleName1");
            Participant.Serial serial1 = routingSlipFactory.createSerial("MySerialName1");
            Participant.ParallelSingle parallel1 = routingSlipFactory.createParallelSingle("MyParallel1");
            participants1.add((Participant)fyi1);
            participants1.add((Participant)single1);
            participants1.add((Participant)serial1);
            participants1.add((Participant)parallel1);
            routingSlip1.setParticipants(participants1);
            RoutingSlip routingSlip2 = routingSlipFactory.createRoutingSlip();
            Participants participants2 = routingSlipFactory.createParticipants();
            Participant.Single single2 = routingSlipFactory.createSingle("MySingleName2");
            participants2.add((Participant)single2);
            routingSlip2.setParticipants(participants2);
            parallel.addRoutingSlip(routingSlip1);
            parallel.addRoutingSlip(routingSlip2);
            stage.add((Participant)single);
            stage.add((Participant)parallel);
            participants.add((Participant)stage);
            rs.setParticipants(participants);
        }

        private static void updatePayload(Payload payload) {
            Payload.Attribute strAttribute = Factory.task().payload().createSimpleAttribute("StringParameter", XMLSchema.QNAME_STRING);
            strAttribute.setEditable(true);
            payload.addAttribute(strAttribute);
            Payload.Attribute intAttribute = Factory.task().payload().createSimpleAttribute("IntegerParameter", XMLSchema.QNAME_INTEGER);
            payload.addAttribute(intAttribute);
            Payload.Attribute booleanAttribute = Factory.task().payload().createSimpleAttribute("BooleanParameter", XMLSchema.QNAME_BOOLEAN);
            payload.addAttribute(booleanAttribute);
            payload.removeAttribute(strAttribute);
            payload.removeAttribute(intAttribute);
            payload.removeAttribute(booleanAttribute);
        }

        private void init() {
            this.setLayout((Layout)new BorderLayout());
            Panel headerPanel = new Panel((UiContainer)this);
            HumanTaskPreferences pref = new HumanTaskPreferences(2);
            final HumanTaskPanel humanTaskPanel = new HumanTaskPanel((UiContainer)this, this.userTask, pref, HumanTaskIntegrationView.TASK_DEFINITION);
            headerPanel.setLayout((Layout)new MigLayout("gap 5, fillx, ins 2"));
            this.targetTextField = new TextField((UiContainer)headerPanel, HumanTaskIntegrationView.OUTPUT_DIR, 30);
            this.applyAction = new BaseAction(Msg.QUOTE("Apply Changes")){

                public void run() {
                    if (HumanTaskIntegrationPanel.this.isEdition()) {
                        WFEditorData editorData = humanTaskPanel.getWFEditorData();
                        HumanTask task = HumanTaskIntegrationPanel.this.userTask.getHumanTask();
                        String titleValue = editorData.getTaskTitle().getText();
                        Title title = task.getTitle();
                        title.setType(Title.Type.STATIC);
                        title.setValue(titleValue);
                        int priority = editorData.getPriority();
                        task.setPriority(priority);
                        Collection outcomesValues = OutComesDataUtil.customOutcomesToStrings((Collection)editorData.getOutComes());
                        WorkflowConfiguration.Outcomes outcomes = task.getWorkflowConfiguration().getOutcomes();
                        outcomes.setValues(CollectionUtils.asSequence(outcomesValues));
                    }
                }
            };
            BaseAction saveAction = new BaseAction(Msg.QUOTE("Save HumanTask")){

                public void run() {
                    Project project = HumanTaskIntegrationPanel.this.userTask.getProject();
                    WizardData data = humanTaskPanel.getWizardData();
                    WFEditorData editorData = humanTaskPanel.getWFEditorData();
                    HumanTaskInfo humanTaskInfo = humanTaskPanel.getHumanTaskInfo();
                    HumanTaskIntegrationPanel.this.saveHumanTask(project, data, editorData, humanTaskInfo);
                }
            };
            this.deleteAction = new BaseAction(Msg.QUOTE("Delete HumanTask")){

                public void run() {
                    if (HumanTaskIntegrationPanel.this.isEdition()) {
                        HumanTask task = HumanTaskIntegrationPanel.this.userTask.getHumanTask();
                        String msg = "Do you want delete the HumanTask " + task.getName() + " ?";
                        int rc = JOptionPane.showConfirmDialog(HumanTaskIntegrationPanel.this.asSwing(), msg, "Delete HumanTask", 0);
                        if (rc == 0) {
                            try {
                                HumanTaskIntegrationPanel.this.userTask.setHumanTask(null);
                                task.getProject().getWriter().delete(new ProjectObject[]{task});
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "ERROR deleting HumanTask '" + task.getName());
                            }
                        }
                    }
                }
            };
            this.saveCopy = CheckBox.create((UiContainer)this, (Msg)Msg.QUOTE("Save Copy in Target Dir"), (boolean)true);
            headerPanel.add((UiComponent)this.saveCopy);
            headerPanel.add((UiComponent)this.targetTextField);
            headerPanel.add((UiComponent)new Button((UiContainer)headerPanel, this.applyAction));
            headerPanel.add((UiComponent)new Button((UiContainer)headerPanel, saveAction));
            headerPanel.add((UiComponent)new Button((UiContainer)headerPanel, this.deleteAction));
            Label editorLabel = Label.create((UiContainer)headerPanel, (Msg)Msg.QUOTE("Editor Mode"));
            editorLabel.setHorizontalAlignment(4);
            headerPanel.add((UiComponent)editorLabel, (Object)"growx");
            this.editorModeLabel = Label.createWithNoColon((UiContainer)headerPanel, (Msg)Msg.QUOTE(""));
            this.updateEditorMode();
            Font font = this.editorModeLabel.getFont();
            Font fontBold = font.bold();
            this.editorModeLabel.setFont(fontBold);
            this.editorModeLabel.setForeground(Color.BLUE);
            headerPanel.add((UiComponent)this.editorModeLabel, (Object)"wrap");
            this.add((UiComponent)headerPanel, "North");
            this.add((UiComponent)humanTaskPanel, "Center");
        }

        private void saveHumanTask(Project project, WizardData data, WFEditorData editorData, HumanTaskInfo humanTaskInfo) {
            String projectName = project.getName();
            String taskName = data.getWorkflowName();
            try {
                HumanTask task;
                String titleValue = editorData.getTaskTitle().getText();
                int priority = editorData.getPriority();
                Collection outcomesValues = OutComesDataUtil.customOutcomesToStrings((Collection)editorData.getOutComes());
                if (this.isEdition()) {
                    task = this.userTask.getHumanTask();
                } else {
                    ResourceManager resourceManager = project.getResourceManager();
                    task = resourceManager.addHumanTask(taskName);
                    if (task == null) {
                        System.out.println("HumanTaskIntegration.saveHumanTask ERROR task = null");
                    }
                }
                if (task != null) {
                    Title title = task.getTitle();
                    title.setType(Title.Type.STATIC);
                    title.setValue(titleValue);
                    task.setPriority(priority);
                    HumanTaskIntegrationPanel.updateWorkflowConfiguration(task.getWorkflowConfiguration(), outcomesValues);
                    if (!this.isEdition()) {
                        HumanTaskIntegrationPanel.updateRoutingSlip(task.getRoutingSlip());
                        HumanTaskIntegrationPanel.updatePayload(task.getWorkflowConfiguration().getPayload());
                    }
                    task.getProject().getWriter().write(new ProjectObject[]{task});
                }
                if (this.saveCopy.isSelected()) {
                    File targetDir = new File(this.targetTextField.getText());
                    JavaFileSystem fs = new JavaFileSystem(targetDir);
                    VFile root = fs.getRoot();
                    oracle.bpm.soa.humantask.HumanTask humanTask = HumanTaskBpm.createHumanTaskForBpm((String)projectName, (String)taskName);
                    humanTask.setId(taskName + "_ID");
                    Title title1 = humanTask.getTitle();
                    title1.setType(Title.Type.STATIC);
                    title1.setValue(titleValue);
                    humanTask.setPriority(priority);
                    humanTask.setDescription(taskName + "_DESCRIPTION");
                    humanTask.setTargetNamespace(data.getNamespace());
                    HumanTaskIntegrationPanel.updateWorkflowConfiguration(task.getWorkflowConfiguration(), outcomesValues);
                    HumanTaskIntegrationPanel.updateRoutingSlip(task.getRoutingSlip());
                    HumanTaskIntegrationPanel.updatePayload(task.getWorkflowConfiguration().getPayload());
                    IOFactory.createTaskVFileIO().saveTask((Object)root, humanTask);
                    JOptionPane.showMessageDialog(null, "HumanTask '" + taskName + "' was created Ok in '" + targetDir.getAbsolutePath() + "'");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "ERROR creating HumanTask '" + taskName + "'");
            }
        }

        private void updateEditorMode() {
            this.editorModeLabel.setText(this.isEdition() ? "EDITION" : "CREATION");
            this.applyAction.setEnabled(this.isEdition());
        }

        private boolean isEdition() {
            return this.userTask.getHumanTask() != null;
        }
    }

    private static class HumanTaskIntegrationCardPanel
    extends Panel {
        private HumanTaskIntegrationPanel integrationPanel;
        private static final String EMPTY_EDITOR = "EmptyEditor";
        private static final String INTEGRATION_EDITOR = "IntegrationEditor";

        public HumanTaskIntegrationCardPanel(UiContainer parent) {
            super(parent);
            this.setLayout((Layout)new CardLayout());
            EmptyPanel emptyDocumentationPanel = new EmptyPanel((UiContainer)this);
            this.add((UiComponent)emptyDocumentationPanel, EMPTY_EDITOR);
        }

        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void show(UserTask userTask) {
            String key;
            if (userTask != null) {
                key = INTEGRATION_EDITOR;
                if (this.integrationPanel == null) {
                    this.integrationPanel = new HumanTaskIntegrationPanel((UiContainer)this, userTask);
                    this.add((UiComponent)this.integrationPanel, INTEGRATION_EDITOR);
                } else {
                    this.integrationPanel.setUserTask(userTask);
                }
            } else {
                key = EMPTY_EDITOR;
            }
            this.getLayout().show((UiContainer)this, key);
        }
    }

    private static class EmptyPanel
    extends Panel {
        public EmptyPanel(UiContainer parent) {
            super(parent);
            this.init();
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("align 50% 50%"));
            Label label = Label.createWithNoColon((UiContainer)this, (Msg)Msg.QUOTE("Available only with a BPMN opened with an UserTask task selected."));
            this.add((UiComponent)label);
        }
    }
}

