/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.views;

import java.awt.Component;
import javax.swing.Icon;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;

abstract class BaseView
extends DockableWindow {
    private Component ui;
    private static final Image DEFAULT_IMAGE = Image.create((Msg)UIMsg.FUEGO);

    BaseView(String viewId) {
        super("BpmInternalWindows." + viewId);
    }

    public Component getGUI() {
        if (this.ui == null) {
            UiComponent component = this.createView(UiContainer.NULL);
            this.ui = (Component)component.getNative();
        }
        return this.ui;
    }

    public String getTabName() {
        return this.getMsg().getString();
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Icon getTabIcon() {
        Msg msg = this.getMsg();
        Image image = Image.create((Msg)msg);
        if (image == null) {
            image = DEFAULT_IMAGE;
        }
        return image.asSwingIcon();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(this.getId());
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 2: {
                this.onHideView();
                return;
            }
            case 3: {
                this.onCloseView();
                return;
            }
            case 1: {
                this.onShowView();
                return;
            }
        }
    }

    protected abstract Msg getMsg();

    protected abstract UiComponent createView(UiContainer var1);

    protected void onHideView() {
    }

    protected void onCloseView() {
    }

    protected void onShowView() {
    }
}

