/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.bpm.fusion.internal.methodeditor.language.MethodLanguageModule;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.SourceCode;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.TextNode;

public class MethodNode
extends TextNode {
    private MethodTypeDescription method;

    public MethodNode(MethodTypeDescription method) {
        this.method = method;
        String extension = "Java".equalsIgnoreCase(method.getCodeLanguage()) ? MethodLanguageModule.LANGUAGE_JAVA_EXT : ("VisualBasic".equalsIgnoreCase(method.getCodeLanguage()) ? MethodLanguageModule.LANGUAGE_VISUALBASIC_EXT : MethodLanguageModule.LANGUAGE_FUEGO_EXT);
        try {
            this.setURL(new File("dummy." + extension).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("");
        }
        this.getAttributes().set(ElementAttributes.NON_HISTORIED);
    }

    public boolean mayHaveChildren() {
        return false;
    }

    protected Reader createReader(URL url) {
        SourceCode sourceCode = this.method.getCode();
        final String source = sourceCode == null ? "" : String.valueOf(sourceCode.getText());
        return new InputStreamReader(new InputStream(){
            private int current = 0;
            private int length = source.length();

            @Override
            public int read() throws IOException {
                if (this.current >= this.length) {
                    return -1;
                }
                return source.charAt(this.current++);
            }
        });
    }
}

