/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.language.visualbasic;

import oracle.bpm.compiler.langs.visualbasic.VisualBasicLanguageSpec;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntax;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntaxImpl;
import org.jetbrains.annotations.NotNull;

public final class VisualBasicSyntax
extends MethodSyntaxImpl {
    public static final String BPMVB_COMMENT_STYLE = "bpmvb-comment-style";
    public static final String BPMVB_KEYWORD_STYLE = "bpmvb-keyword-style";
    public static final String BPMVB_IDENTIFIER_STYLE = "bpmvb-identifier-style";
    public static final String BPMVB_STRING_STYLE = "bpmvb-string-style";
    public static final String BPMVB_NUMBER_STYLE = "bpmvb-number-style";
    public static final String BPMVB_TIME_STYLE = "bpmvb-time-style";

    private VisualBasicSyntax() {
        super(VisualBasicLanguageSpec.class);
        this.addStyle(BPMVB_COMMENT_STYLE, "BPM VB Comment", "base-comment-style");
        this.addStyle(BPMVB_KEYWORD_STYLE, "BPM VB Keyword", "base-keyword-style");
        this.addStyle(BPMVB_IDENTIFIER_STYLE, "BPM VB Identifier", "base-identifier-style");
        this.addStyle(BPMVB_STRING_STYLE, "BPM VB String", "base-string-style");
        this.addStyle(BPMVB_NUMBER_STYLE, "BPM VB Number", "base-number-style");
        this.addStyle(BPMVB_TIME_STYLE, "BPM VB Time", "base-number-style");
    }

    @Override
    public String mapTokenToStyleName(int token) {
        String result = null;
        switch (token) {
            case 7: {
                result = BPMVB_IDENTIFIER_STYLE;
                break;
            }
            case 8: 
            case 9: {
                result = BPMVB_COMMENT_STYLE;
                break;
            }
            case 10: {
                result = BPMVB_STRING_STYLE;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                result = BPMVB_NUMBER_STYLE;
                break;
            }
            case 14: 
            case 15: {
                result = BPMVB_TIME_STYLE;
                break;
            }
            default: {
                if (token < 19) break;
                result = BPMVB_KEYWORD_STYLE;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public String getContentSample() {
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        result.append(" * This is written on a\n");
        result.append(" * Multi-line comment\n");
        result.append(" */\n");
        result.append("Dim firstName As String\n");
        result.append("Dim lastName As String\n");
        result.append("Dim selectedButton As String\n");
        result.append("Dim intValue As Integer\n");
        result.append("Dim timeValue As Time\n\n");
        result.append("' Ask the person's name\n");
        result.append("Input \"First Name:\" : firstName, \"Last Name:\" : lastName,\n");
        result.append("    title := \"Enter Your Name\", buttons := { \"Done\", \"Cancel\" },\n");
        result.append("    Out selection := selectedButton\n\n");
        result.append("' Check the button pressed\n");
        result.append("If selectedButton = \"Done\" OrElse selectedButton = \"Ok\" Then\n");
        result.append("    Display \"Hello \" & firstName & \"!\"\n");
        result.append("Else\n");
        result.append("    Display \"Hello!\"\n");
        result.append("End If\n");
        result.append("\n");
        result.append("intValue = 406\n");
        result.append("timeValue = #1997/12/12#\n");
        return result.toString();
    }

    @Override
    @NotNull
    public String getPresentationName() {
        return "BPM Visual Basic Skin";
    }

    @Override
    public boolean isMultiLineToken(int token) {
        return token == 9;
    }

    static {
        MethodSyntax.registerSyntax(new VisualBasicSyntax());
    }
}

