/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.language.java;

import oracle.bpm.compiler.langs.java.JavaLanguageSpec;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntax;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntaxImpl;
import org.jetbrains.annotations.NotNull;

public final class JavaSyntax
extends MethodSyntaxImpl {
    public static final String BPMJAVA_COMMENT_STYLE = "bpmjava-comment-style";
    public static final String BPMJAVA_KEYWORD_STYLE = "bpmjava-keyword-style";
    public static final String BPMJAVA_IDENTIFIER_STYLE = "bpmjava-identifier-style";
    public static final String BPMJAVA_STRING_STYLE = "bpmjava-string-style";
    public static final String BPMJAVA_NUMBER_STYLE = "bpmjava-number-style";
    public static final String BPMJAVA_TIME_STYLE = "bpmjava-timer-style";

    private JavaSyntax() {
        super(JavaLanguageSpec.class);
        this.addStyle(BPMJAVA_COMMENT_STYLE, "BPM Java Comment", "base-comment-style");
        this.addStyle(BPMJAVA_KEYWORD_STYLE, "BPM Java Keyword", "base-keyword-style");
        this.addStyle(BPMJAVA_IDENTIFIER_STYLE, "BPM Java Identifier", "base-identifier-style");
        this.addStyle(BPMJAVA_STRING_STYLE, "BPM Java String", "base-string-style");
        this.addStyle(BPMJAVA_NUMBER_STYLE, "BPM Java Number", "base-number-style");
        this.addStyle(BPMJAVA_TIME_STYLE, "BPM Java Time", "base-number-style");
    }

    @Override
    public String mapTokenToStyleName(int token) {
        String result = null;
        switch (token) {
            case 7: {
                result = BPMJAVA_IDENTIFIER_STYLE;
                break;
            }
            case 8: 
            case 9: {
                result = BPMJAVA_COMMENT_STYLE;
                break;
            }
            case 10: {
                result = BPMJAVA_STRING_STYLE;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                result = BPMJAVA_NUMBER_STYLE;
                break;
            }
            case 14: 
            case 15: {
                result = BPMJAVA_TIME_STYLE;
                break;
            }
            default: {
                if (token < 19) break;
                result = BPMJAVA_KEYWORD_STYLE;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public String getContentSample() {
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        result.append(" * This is written on a\n");
        result.append(" * Multi-line comment\n");
        result.append(" */\n\n");
        result.append("String firstName;\n");
        result.append("String lastName;\n");
        result.append("String selectedButton;\n\n");
        result.append("int intValue;\n");
        result.append("Time timeValue;\n\n");
        result.append("// Ask the person's name\n");
        result.append("input(\"First Name:\" : firstName, \"Last Name:\" lastName,\n");
        result.append("    title : \"Enter Your Name\", buttons : {\"Done\", \"Cancel\"},\n");
        result.append("    out selection : selectedButton);\n\n");
        result.append("// Check the button pressed\n");
        result.append("if (selectedButton == \"Done\" || selectedButton == \"Ok\") {\n");
        result.append("    display(\"Hello \" + firstName + \"!\");\n}\n");
        result.append("else {\n");
        result.append("    display(\"Hello!\");\n}\n\n");
        result.append("intValue = 406;\n");
        result.append("timeValue = '1997/12/12';\n\n");
        return result.toString();
    }

    @Override
    @NotNull
    public String getPresentationName() {
        return "BPM Java Skin";
    }

    @Override
    public boolean isMultiLineToken(int token) {
        return token == 9;
    }

    static {
        MethodSyntax.registerSyntax(new JavaSyntax());
    }
}

