/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.language;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntaxImpl;
import oracle.javatools.editor.language.StyleRegistry;
import org.jetbrains.annotations.NotNull;

public final class MethodSyntax {
    private final MethodSyntaxImpl syntax;
    private static final Map<Class<? extends LanguageSpec>, MethodSyntaxImpl> registeredStyles = new HashMap<Class<? extends LanguageSpec>, MethodSyntaxImpl>();

    private MethodSyntax(@NotNull Class<? extends LanguageSpec> language) throws InvalidLanguageException {
        this.syntax = registeredStyles.get(language);
        if (this.syntax == null) {
            throw new InvalidLanguageException(language + " is not a valid language");
        }
    }

    public static void registerSyntax(@NotNull MethodSyntaxImpl syntax) {
        registeredStyles.put(syntax.getLanguageSpec(), syntax);
    }

    @NotNull
    public static MethodSyntax createSyntax(@NotNull Class<? extends LanguageSpec> language) throws InvalidLanguageException {
        return new MethodSyntax(language);
    }

    @NotNull
    public LanguageSpec createLanguageSpec() {
        return this.syntax.createLanguageSpec();
    }

    @NotNull
    public String[] getStyleNames() {
        return this.syntax.getStyleNames();
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        this.syntax.registerStyles(styleRegistry);
    }

    public String mapTokenToStyleName(int token) {
        return this.syntax.mapTokenToStyleName(token);
    }

    public boolean isMultiLineToken(int token) {
        return this.syntax.isMultiLineToken(token);
    }

    @NotNull
    public String getContentSample() {
        return this.syntax.getContentSample();
    }

    @NotNull
    public String getPresentationName() {
        return this.syntax.getPresentationName();
    }

    static {
        try {
            Class.forName(MethodSyntaxImpl.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

