/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.methodeditor.language;

import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.langs.fuego.FuegoLanguageSpec;
import oracle.bpm.compiler.langs.java.JavaLanguageSpec;
import oracle.bpm.compiler.langs.visualbasic.VisualBasicLanguageSpec;
import oracle.bpm.fusion.internal.methodeditor.language.BlockRendererAdapter;
import oracle.bpm.fusion.internal.methodeditor.language.DocumentRendererAdapter;
import oracle.bpm.fusion.internal.methodeditor.language.MethodSyntax;
import oracle.bpm.fusion.internal.methodeditor.model.MethodNode;
import oracle.ide.model.Recognizer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class MethodLanguageModule
extends LanguageModule {
    private MethodSyntax syntax;
    public static String LANGUAGE_FUEGO_EXT;
    public static String LANGUAGE_JAVA_EXT;
    public static String LANGUAGE_VISUALBASIC_EXT;

    private MethodLanguageModule() {
        this.getSyntax();
        for (String extension : this.getSupportedFileTypes()) {
            Recognizer.mapExtensionToClass((String)("." + extension), MethodNode.class);
        }
    }

    public abstract String[] getSupportedFileTypes();

    public String getPresentationName() {
        return this.getSyntax().getPresentationName();
    }

    public String[] getStyleNames() {
        return this.getSyntax().getStyleNames();
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        this.getSyntax().registerStyles(styleRegistry);
    }

    public String getContentSample() {
        return this.getSyntax().getContentSample();
    }

    public LanguageSupport createLanguageSupport() {
        return new AbstractLanguageSupport(){

            protected DocumentRenderer createDocumentRenderer() {
                return new DocumentRendererAdapter(MethodLanguageModule.this.getSyntax(), (LanguageSupport)this);
            }
        };
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new BlockRendererAdapter(this.getSyntax(), textBuffer);
    }

    @NotNull
    protected abstract Class<? extends LanguageSpec> getSyntaxLanguage();

    @NotNull
    private MethodSyntax getSyntax() {
        if (this.syntax == null) {
            try {
                this.syntax = MethodSyntax.createSyntax(this.getSyntaxLanguage());
            }
            catch (InvalidLanguageException e) {
                throw new RuntimeException(e);
            }
        }
        return this.syntax;
    }

    static {
        new FuegoLanguageModule();
        new VisualBasicLanguageModule();
        new JavaLanguageModule();
        LANGUAGE_FUEGO_EXT = "bpmfuego";
        LANGUAGE_JAVA_EXT = "bpmjava";
        LANGUAGE_VISUALBASIC_EXT = "bpmvb";
    }

    private static class VisualBasicLanguageModule
    extends MethodLanguageModule {
        private static final String[] supportedFileTypes = new String[]{LANGUAGE_VISUALBASIC_EXT};

        private VisualBasicLanguageModule() {
        }

        @Override
        public String[] getSupportedFileTypes() {
            return supportedFileTypes;
        }

        @Override
        @NotNull
        protected Class<? extends LanguageSpec> getSyntaxLanguage() {
            return VisualBasicLanguageSpec.class;
        }
    }

    private static class JavaLanguageModule
    extends MethodLanguageModule {
        private static final String[] supportedFileTypes = new String[]{LANGUAGE_JAVA_EXT};

        private JavaLanguageModule() {
        }

        @Override
        public String[] getSupportedFileTypes() {
            return supportedFileTypes;
        }

        @Override
        @NotNull
        protected Class<? extends LanguageSpec> getSyntaxLanguage() {
            return JavaLanguageSpec.class;
        }
    }

    private static class FuegoLanguageModule
    extends MethodLanguageModule {
        private static final String[] supportedFileTypes = new String[]{LANGUAGE_FUEGO_EXT};

        private FuegoLanguageModule() {
        }

        @Override
        public String[] getSupportedFileTypes() {
            return supportedFileTypes;
        }

        @Override
        @NotNull
        protected Class<? extends LanguageSpec> getSyntaxLanguage() {
            return FuegoLanguageSpec.class;
        }
    }
}

