/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.actions;

import java.util.Map;
import oracle.bpm.fusion.internal.actions.InternalMenuActions;
import oracle.bpm.fusion.internal.views.ApplicationNavigatorSpy;
import oracle.bpm.fusion.internal.views.FileSystemEventsSpyView;
import oracle.bpm.fusion.internal.views.FuegoChartView;
import oracle.bpm.fusion.internal.views.FuegoUiView;
import oracle.bpm.fusion.internal.views.HelpIntegrationView;
import oracle.bpm.fusion.internal.views.HumanTaskIntegrationView;
import oracle.bpm.fusion.internal.views.NodeFactoryCacheView;
import oracle.bpm.fusion.internal.views.ProjectEventsSpyView;
import oracle.bpm.fusion.internal.views.RulesIntegrationView;
import oracle.bpm.fusion.internal.views.ScriptDebugView;
import oracle.bpm.fusion.internal.views.SelectionSpyView;
import oracle.bpm.fusion.internal.views.UiSpyView;
import oracle.bpm.fusion.internal.views.UpdateMessageEventsSpyView;
import oracle.bpm.fusion.internal.views.UrlFileSystemSpyView;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.MenuConstants;
import oracle.ide.docking.DockableWindow;

class InternalViewActions
extends InternalMenuActions {
    private static InternalViewActions instance;
    private static final int FUEGO_CHART_ID;
    private static final int FUEGO_UI_ID;
    private static final int SELECTION_SPY_ID;
    private static final int UI_SPY_ID;
    private static final int FILE_SYSTEM_EVENTS_SPY_ID;
    private static final int URL_FILE_SYSTEM_EVENTS_SPY_ID;
    private static final int UPDATE_MESSAGE_EVENTS_SPY_ID;
    private static final int PROJECT_EVENTS_SPY_ID;
    private static final int APPLICATION_SPY_ID;
    private static final int RULES_INTEGRATION_ID;
    private static final int HUMAN_TASK_INTEGRATION_ID;
    private static final int HELP_INTEGRATION_ID;
    private static final int NODE_FACTORY_ID;
    private static final int SCRIPT_DEBUG_ID;

    private InternalViewActions() {
    }

    static synchronized InternalViewActions getInstance() {
        if (instance == null) {
            instance = new InternalViewActions();
        }
        return instance;
    }

    @Override
    String getMenuView() {
        return "View";
    }

    @Override
    float getMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 1000.0f;
    }

    @Override
    String getActionCategoryView() {
        return IdeMainWindow.ACTION_CATEGORY_VIEW;
    }

    @Override
    void setActions(Map<Integer, DockableWindow> actions) {
        actions.put(FUEGO_CHART_ID, FuegoChartView.getInstance());
        actions.put(FUEGO_UI_ID, FuegoUiView.getInstance());
        actions.put(SELECTION_SPY_ID, SelectionSpyView.getInstance());
        actions.put(FILE_SYSTEM_EVENTS_SPY_ID, FileSystemEventsSpyView.getInstance());
        actions.put(URL_FILE_SYSTEM_EVENTS_SPY_ID, UrlFileSystemSpyView.getInstance());
        actions.put(UPDATE_MESSAGE_EVENTS_SPY_ID, UpdateMessageEventsSpyView.getInstance());
        actions.put(PROJECT_EVENTS_SPY_ID, ProjectEventsSpyView.getInstance());
        actions.put(UI_SPY_ID, UiSpyView.getInstance());
        actions.put(APPLICATION_SPY_ID, ApplicationNavigatorSpy.getInstance());
        actions.put(RULES_INTEGRATION_ID, RulesIntegrationView.getInstance());
        actions.put(HUMAN_TASK_INTEGRATION_ID, HumanTaskIntegrationView.getInstance());
        actions.put(HELP_INTEGRATION_ID, HelpIntegrationView.getInstance());
        actions.put(HELP_INTEGRATION_ID, HelpIntegrationView.getInstance());
        actions.put(NODE_FACTORY_ID, NodeFactoryCacheView.getInstance());
        actions.put(SCRIPT_DEBUG_ID, ScriptDebugView.getInstance());
    }

    private static String id(String s) {
        return "internal.view." + s;
    }

    static {
        FUEGO_CHART_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("fuegochartview"));
        FUEGO_UI_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("fuegoui"));
        SELECTION_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("selectionspy"));
        UI_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("uispy"));
        FILE_SYSTEM_EVENTS_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("filesystemeventsspy"));
        URL_FILE_SYSTEM_EVENTS_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("urlfilesystemeventsspy"));
        UPDATE_MESSAGE_EVENTS_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("updatemessageeventsspy"));
        PROJECT_EVENTS_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("projecteventsspy"));
        APPLICATION_SPY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("applicationnavigatorspy"));
        RULES_INTEGRATION_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("rulesintegrationview"));
        HUMAN_TASK_INTEGRATION_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("humantaskintegrationview"));
        HELP_INTEGRATION_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("helpintegrationview"));
        NODE_FACTORY_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("nodefactoryview"));
        SCRIPT_DEBUG_ID = Ide.findOrCreateCmdID((String)InternalViewActions.id("scriptdebugview"));
    }
}

