/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.internal.actions;

import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockableWindow;

abstract class InternalMenuActions {
    private Map<Integer, DockableWindow> actionsMap;
    private Controller controller;

    InternalMenuActions() {
    }

    abstract float getMenuWeight();

    abstract void setActions(Map<Integer, DockableWindow> var1);

    abstract String getMenuView();

    abstract String getActionCategoryView();

    Controller getController() {
        if (this.controller == null) {
            this.controller = this.createController(this.getActions());
        }
        return this.controller;
    }

    Controller createController(Map<Integer, DockableWindow> actions) {
        return new MenuController(actions);
    }

    Map<Integer, DockableWindow> getActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new LinkedHashMap<Integer, DockableWindow>();
            this.setActions(this.actionsMap);
        }
        return this.actionsMap;
    }

    void createActions() {
        Map<Integer, DockableWindow> actions = this.getActions();
        Set<Map.Entry<Integer, DockableWindow>> entrySet = actions.entrySet();
        for (Map.Entry<Integer, DockableWindow> element : entrySet) {
            this.createMenuItem(element.getKey(), element.getValue());
        }
    }

    private void createMenuItem(int id, DockableWindow view) {
        String label = view.getTabName();
        Icon icon = view.getTabIcon();
        IdeAction ideAction = IdeAction.get((int)id, null, (String)label, (String)this.getActionCategoryView(), null, (Icon)icon, null, (boolean)true);
        ideAction.addController(this.getController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem firstActionMenu = menubar.createMenuItem((ToggleAction)ideAction, this.getMenuWeight());
        menubar.add((Component)firstActionMenu, MenuManager.getJMenu((String)this.getMenuView()));
    }

    private static class MenuController
    implements Controller {
        private Map<Integer, DockableWindow> actionsMap;

        MenuController(Map<Integer, DockableWindow> actionsMap) {
            this.actionsMap = actionsMap;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            Map<Integer, DockableWindow> actions = this.getActions();
            boolean result = false;
            if (actions.containsKey(cmdId)) {
                DockableWindow view = actions.get(cmdId);
                view.show();
                result = true;
            }
            return result;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        Map<Integer, DockableWindow> getActions() {
            return this.actionsMap;
        }
    }
}

