/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.tutor.reporter.AbstractPublisher;
import org.w3c.dom.Document;

public class XMLPublisher
extends AbstractPublisher {
    private String _targetFile;
    private String _xslPath;
    private StreamSource _xslStream;

    @Override
    public void publish(Document domDoc) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        DOMSource xmlStream = new DOMSource(domDoc);
        FileOutputStream fos = new FileOutputStream(this.getTarget());
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(xmlStream, new StreamResult(fos));
        fos.close();
    }

    @Override
    public ByteArrayOutputStream publishToComposer(Document domDoc) throws TransformerException, IOException {
        DOMSource domSource = new DOMSource(domDoc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(bos);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(domSource, streamResult);
        bos.close();
        return (ByteArrayOutputStream)streamResult.getOutputStream();
    }

    @Override
    public final void setTarget(String outputFileName) {
        this._targetFile = outputFileName;
    }

    @Override
    public final String getTarget() {
        return this._targetFile;
    }

    @Override
    public final void setXslPath(String xslPath) {
        this._xslPath = xslPath;
    }

    public final String getXslPath() {
        return this._xslPath;
    }

    @Override
    public final void setXslStream(StreamSource xslStream) {
        this._xslStream = xslStream;
    }

    public final StreamSource getXslStream() {
        return this._xslStream;
    }
}

