/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.bpm.tutor.reporter.jaxb.reportdata.BpmObject;
import oracle.bpm.tutor.reporter.jaxb.reportdata.BpmObjects;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Definitions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Sorter {
    private JAXBContext _jaxbCtx = JAXBContext.newInstance((String)"oracle.bpm.tutor.reporter.jaxb.reportdata");
    private Definitions _sortedDefinitions = null;

    public Document sort(Definitions originalDefs) throws JAXBException, FileNotFoundException, ParserConfigurationException {
        this.setSortedDefinitions(originalDefs);
        BpmObjects bo = this.getSortedBpmObjects().getBpmObjects();
        List<BpmObject> bpo = bo.getBpmObject();
        for (BpmObject o : bpo) {
            ArrayList<BpmObject> laneList = this.getTypedBpmObjectList(o, "lane");
            Collections.sort(laneList, new byY());
            for (BpmObject j : laneList) {
                BpmObjects laneObj = j.getBpmObjects();
                List<BpmObject> oList = laneObj.getBpmObject();
                Collections.sort(oList, new byX());
            }
        }
        return this.marshall(this.getSortedBpmObjects());
    }

    private Definitions getSortedBpmObjects() {
        if (this._sortedDefinitions == null) {
            this._sortedDefinitions = new Definitions();
        }
        return this._sortedDefinitions;
    }

    private ArrayList<BpmObject> getTypedBpmObjectList(BpmObject obj, String objectType) {
        ArrayList<BpmObject> list = new ArrayList<BpmObject>();
        BpmObjects bo = obj.getBpmObjects();
        List<BpmObject> bpo = bo.getBpmObject();
        for (BpmObject o : bpo) {
            String tmpObjType = o.getObjectType();
            if (!tmpObjType.equalsIgnoreCase(objectType)) continue;
            list.add(o);
        }
        if (list.isEmpty()) {
            for (BpmObject o : bpo) {
                BpmObject childObjects;
                ArrayList<BpmObject> tmpList;
                if (o.getBpmObjects().getBpmObject().isEmpty() || (tmpList = this.getTypedBpmObjectList(childObjects = o, objectType)).isEmpty()) continue;
                list.addAll(tmpList.subList(0, tmpList.size()));
            }
        }
        return list;
    }

    private Document marshall(Definitions d) throws JAXBException, FileNotFoundException, ParserConfigurationException {
        Marshaller marshaller;
        DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance("oracle.xml.jaxp.JXDocumentBuilderFactory", null);
        domFact.setIgnoringComments(true);
        domFact.setCoalescing(true);
        domFact.setNamespaceAware(false);
        domFact.setValidating(false);
        Document doc = domFact.newDocumentBuilder().newDocument();
        try {
            marshaller = this._jaxbCtx.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(ReporterUtils.xlate("MESSAGE_ERROR_CANT_INIT_JAXB", Locale.US));
        }
        marshaller.setEventHandler((ValidationEventHandler)new _ReportValidationEventHandler());
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)d, (Node)doc);
        return doc;
    }

    private void setSortedDefinitions(Definitions _sortedDefinitions) {
        this._sortedDefinitions = _sortedDefinitions;
    }

    private class byY
    implements Comparator<BpmObject> {
        private byY() {
        }

        @Override
        public int compare(BpmObject node1, BpmObject node2) {
            return Double.compare(node1.getCoord().getY(), node2.getCoord().getY());
        }
    }

    private class byX
    implements Comparator<BpmObject> {
        private byX() {
        }

        @Override
        public int compare(BpmObject node1, BpmObject node2) {
            return Double.compare(node1.getCoord().getX(), node2.getCoord().getX());
        }
    }

    private class byName
    implements Comparator<BpmObject> {
        private byName() {
        }

        @Override
        public int compare(BpmObject node1, BpmObject node2) {
            return node1.getName().compareToIgnoreCase(node2.getName());
        }
    }

    private class _ReportValidationEventHandler
    implements ValidationEventHandler {
        private _ReportValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent ve) {
            if (ve.getSeverity() == 2 || ve.getSeverity() == 1) {
                ValidationEventLocator locator = ve.getLocator();
                throw new RuntimeException(MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_INVALID_XML_DOC", Locale.US), locator.getURL()) + "\n" + MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_GENERIC", Locale.US), ve.getMessage()) + "\n" + MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_AT_COLUMN", Locale.US), locator.getColumnNumber(), locator.getLineNumber()));
            }
            return true;
        }
    }
}

