/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import oracle.ide.log.LogManager;

public final class ReporterUtils {
    private ReporterUtils() {
    }

    public static String filterFilename(String str) {
        try {
            str = str.replaceAll("[\\*\\|\\?\\/\\\\\\`\\<\\>\\:\\\"\n\t\r\f\u0000]", "_");
            str = str.replaceAll("[\\$\\&\\+\\,\\;\\=\\@\\ \\#\\%\\{\\}\\^\\~\\[\\]]", "_");
        }
        catch (PatternSyntaxException pse) {
            return str;
        }
        return str;
    }

    public static void displayError(Exception e, String preface) {
        ReporterUtils.displayError(e, preface, true);
    }

    public static void displayError(Exception e, String preface, boolean translate) {
        LogManager lm = LogManager.getLogManager();
        lm.showLog();
        StringWriter stringwriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringwriter));
        lm.getMsgPage().log((Object)(preface + "\n" + stringwriter.toString()));
        if (translate) {
            JOptionPane.showMessageDialog(null, preface + "\n" + ReporterUtils.xlate("MESSAGE_CHECK_LOG", ReporterUtils.getStudioLocale()), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", ReporterUtils.getStudioLocale()), 0);
        } else {
            JOptionPane.showMessageDialog(null, preface + "\n" + "Check JDeveloper's Messages Log for details.", "BPM Process Report", 0);
        }
    }

    public static String xlate(String key, Locale locale) {
        return ResourceBundle.getBundle("oracle.bpm.tutor.reporter.i18n.AttributeReportResourceBundle", locale).getString(key);
    }

    public static Locale getStudioLocale() {
        try {
            return Locale.getDefault();
        }
        catch (Exception e) {
            return Locale.US;
        }
    }
}

