/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import oracle.bpm.tutor.reporter.AbstractPublisher;
import oracle.bpm.tutor.reporter.HTMLPublisher;
import oracle.bpm.tutor.reporter.HTMLZipPublisher;
import oracle.bpm.tutor.reporter.PDFPublisher;
import oracle.bpm.tutor.reporter.ReportType;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.bpm.tutor.reporter.XMLPublisher;
import oracle.bpm.tutor.reporter.jaxb.publisher.Publishers;

public class ReporterFactory {
    private String _jarBasePath;
    private File _mapFile;

    public ReporterFactory() {
    }

    public ReporterFactory(String fileName) {
        this(new File(fileName));
    }

    public ReporterFactory(File xmlFile) {
        if (xmlFile == null) {
            URL resourceURL = this.getClass().getResource("/publishers.xml");
            try {
                xmlFile = new File(resourceURL.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.loadPublisherMap(xmlFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_CANT_PARSE", Locale.US), xmlFile) + "\n" + e.getMessage());
        }
    }

    public void loadPublisherMap(File xmlFile) throws FileNotFoundException, JAXBException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_FILE_NOT_FOUND", Locale.US), xmlFile.getAbsoluteFile()));
        }
        Publishers reportPublishers = this._unmarshall(xmlFile);
        this.setJarBasePath(reportPublishers.getJarBasePath());
        this.setMapFile(xmlFile);
    }

    public void setJarBasePath(String jarBasePath) {
        this._jarBasePath = jarBasePath;
    }

    public String getJarBasePath() {
        return this._jarBasePath;
    }

    public void setMapFile(File _mapFile) {
        this._mapFile = _mapFile;
    }

    public File getMapFile() {
        return this._mapFile;
    }

    public AbstractPublisher getInstance(ReportType type) {
        AbstractPublisher p = type == ReportType.HTML ? new HTMLPublisher() : (type == ReportType.PDF ? new PDFPublisher() : (type == ReportType.XML ? new XMLPublisher() : (type == ReportType.HTMLZIP ? new HTMLZipPublisher() : new XMLPublisher())));
        return p;
    }

    private Publishers _unmarshall(File xmlSourceFile) throws FileNotFoundException, JAXBException {
        Unmarshaller unmarshaller;
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)"oracle.bpm.tutor.reporter.jaxb.publisher");
            unmarshaller = jaxbCtx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(ReporterUtils.xlate("MESSAGE_ERROR_CANT_INIT_JAXB", Locale.US) + "\n" + e.getMessage());
        }
        unmarshaller.setEventHandler((ValidationEventHandler)new _JaxbValidationEventHandler());
        Publishers modelConverters = (Publishers)unmarshaller.unmarshal(xmlSourceFile);
        return modelConverters;
    }

    private class _JaxbValidationEventHandler
    implements ValidationEventHandler {
        private _JaxbValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent ve) {
            if (ve.getSeverity() == 2 || ve.getSeverity() == 1) {
                ValidationEventLocator locator = ve.getLocator();
                throw new RuntimeException(MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_INVALID_XML_DOC", Locale.US), locator.getURL()) + "\n" + MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_GENERIC", Locale.US), ve.getMessage()) + "\n" + MessageFormat.format(ReporterUtils.xlate("MESSAGE_ERROR_AT_COLUMN", Locale.US), locator.getColumnNumber(), locator.getLineNumber()));
            }
            return true;
        }
    }
}

