/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.reporter.AbstractPublisher;
import oracle.bpm.tutor.reporter.Extractor;
import oracle.bpm.tutor.reporter.ProcessImage;
import oracle.bpm.tutor.reporter.ReportScope;
import oracle.bpm.tutor.reporter.ReportType;
import oracle.bpm.tutor.reporter.ReporterFactory;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.bpm.tutor.reporter.Sorter;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Definitions;
import org.w3c.dom.Document;

public class ReporterDialog
extends JDialog {
    private transient Process _bpmProcess = null;
    private transient Project _bpmProject = null;
    private Locale _locale;
    private ReportScope _reportScope;
    private JButton jBtnBrowse = new JButton();
    private JButton jBtnCancel = new JButton();
    private JButton jBtnHelp = new JButton();
    private JButton jBtnOK = new JButton();
    private JLabel jLabelReportLocation = new JLabel();
    private JLabel jLabelSelectFileType = new JLabel();
    private JPanel jPanelRadioBtns = new JPanel();
    private JRadioButton jRadioBtnHTML = new JRadioButton();
    private JRadioButton jRadioBtnPDF = new JRadioButton();
    private JRadioButton jRadioBtnXML = new JRadioButton();
    private JTextField jTextFieldReportLocation = new JTextField();
    private static File _fullPath;
    private static File _file;
    private static File _priorSaveDir;
    private static final int CROPPED_IMG_HEIGHT = 1000;
    private static final int CROPPED_IMG_WIDTH = 1000;
    private static final double CROPPED_IMG_OVERLAP_PCT = 0.1;

    public ReporterDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this._locale = ReporterUtils.getStudioLocale();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setPath() {
        if (_priorSaveDir != null) {
            this.jTextFieldReportLocation.setText(_priorSaveDir.toString());
        }
    }

    public final void setReportScope(ReportScope reportScope) {
        this._reportScope = reportScope;
    }

    public final void setBpmProcess(Process bpmProcess) {
        this._bpmProcess = bpmProcess;
    }

    public final Process getBpmProcess() {
        return this._bpmProcess;
    }

    public final void setBpmProject(Project bpmProject) {
        this._bpmProject = bpmProject;
    }

    public final Project getBpmProject() {
        return this._bpmProject;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(496, 239));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.setModal(true);
        this.jBtnOK.setText(ReporterUtils.xlate("BUTTON_OK", this._locale));
        this.jBtnOK.setBounds(new Rectangle(310, 170, 80, 21));
        this.jBtnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jBtnOK_actionPerformed();
            }
        });
        this.jBtnCancel.setText(ReporterUtils.xlate("BUTTON_CANCEL", this._locale));
        this.jBtnCancel.setBounds(new Rectangle(395, 170, 80, 21));
        this.jBtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jBtnCancel_actionPerformed();
            }
        });
        this.jBtnHelp.setBounds(new Rectangle(25, 170, 80, 20));
        this.jBtnHelp.setSize(new Dimension(80, 21));
        this.jBtnHelp.setText(ReporterUtils.xlate("BUTTON_HELP", this._locale));
        this.jBtnHelp.setMnemonic(ReporterUtils.xlate("BUTTON_HELP_AK", this._locale).toCharArray()[0]);
        this.jBtnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jBtnHelp_actionPerformed();
            }
        });
        this.jBtnBrowse.setText(ReporterUtils.xlate("BUTTON_BROWSE", this._locale));
        this.jBtnBrowse.setBounds(new Rectangle(395, 120, 80, 21));
        this.jBtnBrowse.setMnemonic(ReporterUtils.xlate("BUTTON_BROWSE_AK", this._locale).toCharArray()[0]);
        this.jBtnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jBtnBrowse_actionPerformed();
            }
        });
        this.jLabelReportLocation.setText(ReporterUtils.xlate("LABEL_REPORT_DIRECTORY", this._locale));
        this.jLabelReportLocation.setLabelFor(this.jTextFieldReportLocation);
        this.jLabelReportLocation.setBounds(new Rectangle(10, 120, 105, 20));
        this.jLabelReportLocation.setHorizontalAlignment(4);
        this.jLabelReportLocation.setDisplayedMnemonic(ReporterUtils.xlate("LABEL_REPORT_DIRECTORY_AK", this._locale).toCharArray()[0]);
        this.jPanelRadioBtns.setBounds(new Rectangle(175, 20, 155, 85));
        this.jPanelRadioBtns.setLayout(new GridLayout(0, 1));
        this.jLabelSelectFileType.setText(ReporterUtils.xlate("LABEL_SELECT_FILE_TYPE", this._locale));
        this.jLabelSelectFileType.setBounds(new Rectangle(25, 15, 135, 30));
        this.jLabelSelectFileType.setHorizontalAlignment(4);
        this.jRadioBtnHTML.setText("HTML");
        this.jRadioBtnHTML.setMnemonic('H');
        this.jRadioBtnHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jRadioBtnHTML_actionPerformed();
            }
        });
        this.jRadioBtnXML.setText("XML");
        this.jRadioBtnXML.setMnemonic('X');
        this.jRadioBtnXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jRadioBtnXML_actionPerformed();
            }
        });
        this.jRadioBtnPDF.setText("PDF");
        this.jRadioBtnPDF.setMnemonic('P');
        this.jRadioBtnPDF.setVisible(false);
        this.jRadioBtnPDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReporterDialog.this._jRadioBtnPDF_actionPerformed();
            }
        });
        this.jTextFieldReportLocation.setBounds(new Rectangle(120, 118, 255, 25));
        ButtonGroup group = new ButtonGroup();
        group.add(this.jRadioBtnHTML);
        group.add(this.jRadioBtnXML);
        group.add(this.jRadioBtnPDF);
        group.setSelected(this.jRadioBtnHTML.getModel(), true);
        this.jPanelRadioBtns.add((Component)this.jRadioBtnHTML, null);
        this.jPanelRadioBtns.add((Component)this.jRadioBtnXML, null);
        this.jPanelRadioBtns.add((Component)this.jRadioBtnPDF, null);
        this.getContentPane().add((Component)this.jTextFieldReportLocation, null);
        this.getContentPane().add((Component)this.jPanelRadioBtns, null);
        this.getContentPane().add((Component)this.jLabelSelectFileType, null);
        this.getContentPane().add((Component)this.jLabelReportLocation, null);
        this.getContentPane().add((Component)this.jBtnBrowse, null);
        this.getContentPane().add((Component)this.jBtnCancel, null);
        this.getContentPane().add((Component)this.jBtnHelp, null);
        this.getContentPane().add((Component)this.jBtnOK, null);
        this.getRootPane().setDefaultButton(this.jBtnOK);
        KeyStroke hep = KeyStroke.getKeyStroke(112, 0, true);
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0, true);
        AbstractAction anAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReporterDialog.this.disposeDialog();
            }
        };
        AbstractAction helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReporterDialog.this.showHelp();
            }
        };
        this.getRootPane().registerKeyboardAction(anAction, ks, 2);
        this.getRootPane().registerKeyboardAction(helpAction, hep, 0);
        this.setPath();
    }

    private void _jBtnBrowse_actionPerformed() {
        this._showDirectoryChooser();
    }

    private void _showDirectoryChooser() {
        JFileChooser fileChooser = this.jTextFieldReportLocation.getText().trim().equals("") ? new JFileChooser() : new JFileChooser(this.jTextFieldReportLocation.getText());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(ReporterUtils.xlate("TITLE_SELECT_DIRECTORY", this._locale));
        fileChooser.setDialogType(0);
        int result = fileChooser.showDialog(this.getFocusOwner(), ReporterUtils.xlate("BUTTON_SELECT", this._locale));
        if (result == 0) {
            this.jTextFieldReportLocation.setText(fileChooser.getSelectedFile().toString());
        }
    }

    private String _getFilenameEnd() {
        if (this.jRadioBtnHTML.isSelected()) {
            return "_Report.htm";
        }
        if (this.jRadioBtnPDF.isSelected()) {
            return "_Report.pdf";
        }
        if (this.jRadioBtnXML.isSelected()) {
            return "_Report.xml";
        }
        return null;
    }

    private void _jBtnCancel_actionPerformed() {
        this.disposeDialog();
    }

    private void disposeDialog() {
        this.dispose();
    }

    private void _jBtnHelp_actionPerformed() {
        this.showHelp();
    }

    private void showHelp() {
        try {
            Class<?> HelpServ = Class.forName("oracle.bpm.fusion.studio.help.JdevHelpService");
            Constructor<?> constructor = HelpServ.getConstructor(null);
            Object obj = constructor.newInstance(null);
            Method showHelp = HelpServ.getMethod("showHelp", String.class);
            showHelp.invoke(obj, "ProcessReportDialog");
        }
        catch (Exception e) {
            ReporterUtils.displayError(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _jBtnOK_actionPerformed() {
        try {
            _file = new File(this.jTextFieldReportLocation.getText());
            if (!_file.exists() || !_file.isDirectory()) {
                JOptionPane.showMessageDialog(null, ReporterUtils.xlate("MESSAGE_SELECT_VALID_DIRECTORY", this._locale), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", this._locale), 2);
                this.jTextFieldReportLocation.requestFocus();
                return;
            }
            String filteredFilename = null;
            if (this._reportScope == ReportScope.PROCESS) {
                filteredFilename = ReporterUtils.filterFilename(this.getBpmProcess().getName());
            } else if (this._reportScope == ReportScope.PROJECT) {
                filteredFilename = ReporterUtils.filterFilename(this.getBpmProject().getName());
            }
            _fullPath = new File(_file.toString() + File.separator + filteredFilename + File.separator + filteredFilename + this._getFilenameEnd());
            if (_fullPath.exists()) {
                int ret = JOptionPane.showConfirmDialog(this.jBtnOK, MessageFormat.format(ReporterUtils.xlate("MESSAGE_OVERWRITE_FILE_QUESTION", this._locale), _fullPath.getAbsolutePath()) + "\n\n" + ReporterUtils.xlate("MESSAGE_OVERWRITE_YES_OPTION", this._locale) + "\n" + ReporterUtils.xlate("MESSAGE_OVERWRITE_NO_OPTION", this._locale) + "\n" + ReporterUtils.xlate("MESSAGE_OVERWRITE_CANCEL_OPTION", this._locale), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", this._locale), 1, 3);
                if (ret == 1) {
                    int ctr = 0;
                    while (_fullPath.exists()) {
                        _fullPath = new File(_file.toString() + File.separator + filteredFilename + "_" + ++ctr + File.separator + filteredFilename + "_" + ctr + this._getFilenameEnd());
                    }
                } else if (ret == 2) {
                    return;
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ReporterUtils.xlate("MESSAGE_SELECT_VALID_PATH", this._locale), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", this._locale), 2);
            this.jTextFieldReportLocation.requestFocus();
            return;
        }
        this.jBtnOK.setEnabled(false);
        this.jBtnCancel.setEnabled(false);
        try {
            Report report = new Report();
            Thread t = new Thread(report);
            t.start();
            while (t.isAlive()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            t.join();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (report.getException() != null) {
                ReporterUtils.displayError(report.getException(), ReporterUtils.xlate("MESSAGE_ERROR_DURING_GENERATION", this._locale));
            } else {
                JOptionPane.showMessageDialog(null, MessageFormat.format(ReporterUtils.xlate("MESSAGE_REPORT_SUCCESS", this._locale), _fullPath.getAbsolutePath()), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", this._locale), 1);
            }
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            ReporterUtils.displayError(ex, ReporterUtils.xlate("MESSAGE_ERROR_DURING_GENERATION", this._locale));
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dispose();
        }
    }

    private void _jRadioBtnHTML_actionPerformed() {
    }

    private void _jRadioBtnPDF_actionPerformed() {
    }

    private void _jRadioBtnXML_actionPerformed() {
    }

    static {
        _priorSaveDir = null;
    }

    private class Report
    implements Runnable {
        private Exception _exception;

        private Report() {
        }

        @Override
        public void run() {
            try {
                this.createReport();
            }
            catch (Exception e) {
                this._exception = e;
            }
        }

        public Exception getException() {
            return this._exception;
        }

        private void createReport() throws Exception {
            HashMap<String, LinkedList<String>> hashmapList;
            File resourceDir;
            Extractor extractor = new Extractor();
            ProcessImage pi = new ProcessImage();
            HashMap<String, String> hashmap = new HashMap<String, String>();
            if (!_fullPath.getParentFile().exists()) {
                _fullPath.getParentFile().mkdir();
            }
            if (!(resourceDir = new File(_fullPath.getParent() + File.separator + "Resources")).exists() && !resourceDir.mkdir()) {
                throw new FileNotFoundException();
            }
            _priorSaveDir = _file;
            if (ReporterDialog.this._reportScope == ReportScope.PROCESS) {
                extractor.setLocale(ReporterDialog.this.getBpmProcess().getProject().getPreferences().getDefaultLanguage());
                if (ReporterDialog.this.jRadioBtnPDF.isSelected()) {
                    hashmapList = new HashMap();
                    LinkedList<String> list = pi.writeCroppedImages(ReporterDialog.this.getBpmProcess(), resourceDir.getPath(), 1000, 1000, 0.1);
                    hashmapList.put(ReporterDialog.this.getBpmProcess().getName(), list);
                    extractor.setCroppedImageHash(hashmapList);
                } else if (ReporterDialog.this.jRadioBtnHTML.isSelected()) {
                    String imgName = pi.writeFullImage(ReporterDialog.this.getBpmProcess(), resourceDir.getPath(), ReporterDialog.this.getBpmProcess().getName());
                    hashmap.put(ReporterDialog.this.getBpmProcess().getName(), imgName);
                    extractor.setFullSizeImageHash(hashmap);
                } else if (ReporterDialog.this.jRadioBtnXML.isSelected()) {
                    String base64Img = pi.createBase64Image(ReporterDialog.this.getBpmProcess());
                    hashmap.put(ReporterDialog.this.getBpmProcess().getName(), base64Img);
                    extractor.setBase64ImageHash(hashmap);
                }
                extractor.extractDefinitions(ReporterDialog.this.getBpmProcess());
            } else if (ReporterDialog.this._reportScope == ReportScope.PROJECT) {
                extractor.setLocale(ReporterDialog.this.getBpmProject().getPreferences().getDefaultLanguage());
                if (ReporterDialog.this.jRadioBtnPDF.isSelected()) {
                    hashmapList = pi.writeCroppedImageSets(ReporterDialog.this.getBpmProject(), resourceDir.getPath(), 1000, 1000, 0.1);
                    extractor.setCroppedImageHash(hashmapList);
                } else if (ReporterDialog.this.jRadioBtnHTML.isSelected()) {
                    hashmap = pi.writeFullImageSets(ReporterDialog.this.getBpmProject(), resourceDir.getPath());
                    extractor.setFullSizeImageHash(hashmap);
                } else if (ReporterDialog.this.jRadioBtnXML.isSelected()) {
                    hashmap = pi.createBase64ImageSets(ReporterDialog.this.getBpmProject());
                    extractor.setBase64ImageHash(hashmap);
                }
                extractor.extractDefinitions(ReporterDialog.this.getBpmProject());
            }
            Definitions definitions = extractor.getDefinitions();
            Document doc = null;
            try {
                Sorter sorter = new Sorter();
                doc = sorter.sort(definitions);
            }
            catch (Exception ex) {
                this._exception = ex;
            }
            ReporterFactory rf = new ReporterFactory();
            AbstractPublisher pub = null;
            String transformFile = "";
            if (ReporterDialog.this.jRadioBtnHTML.isSelected()) {
                pub = rf.getInstance(ReportType.HTML);
                transformFile = "BPMReport.xsl";
            } else if (ReporterDialog.this.jRadioBtnPDF.isSelected()) {
                pub = rf.getInstance(ReportType.PDF);
                transformFile = "BPMxml2fo.xsl";
            } else if (ReporterDialog.this.jRadioBtnXML.isSelected()) {
                pub = rf.getInstance(ReportType.XML);
            }
            if (pub != null) {
                pub.setXslStream(new StreamSource(this.getClass().getResourceAsStream("/oracle/bpm/tutor/reporter/resources/" + transformFile)));
                pub.setTarget(_fullPath.getAbsolutePath());
                pub.publish(doc);
            }
        }
    }
}

