/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Method;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.reporter.ReportScope;
import oracle.bpm.tutor.reporter.ReporterDialog;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorManager;

@RegisteredByExtension(value="oracle.bpm.tutor.reporter")
final class ReporterAddin
implements Addin {
    ReporterAddin() {
    }

    public void initialize() {
        NavigatorManager navigatorManager = NavigatorManager.getApplicationNavigatorManager();
        if (navigatorManager != null) {
            navigatorManager.getContextMenu().addContextMenuListener((ContextMenuListener)new _ReporterAction());
        }
    }

    private static oracle.bpm.project.model.Project _getProjectFromRepoService(Project ideProject) {
        oracle.bpm.project.model.Project bpmProj = null;
        try {
            Class<?> RepoService = Class.forName("oracle.bpm.fusion.repository.JdevRepositoryService");
            Method getInst = RepoService.getMethod("getInstance", null);
            Object rsInst = getInst.invoke(RepoService, null);
            Method getProj = RepoService.getMethod("getProject", ideProject.getClass());
            Object proj = getProj.invoke(rsInst, ideProject);
            if (proj instanceof oracle.bpm.project.model.Project) {
                bpmProj = (oracle.bpm.project.model.Project)proj;
            }
        }
        catch (Exception e) {
            ReporterUtils.displayError(e, e.getMessage());
        }
        return bpmProj;
    }

    private static class _ReporterAction
    implements ContextMenuListener {
        private _ReporterAction() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            Node node = context.getNode();
            if (node instanceof ProjectObjectNode && ((ProjectObjectNode)node).getObject() instanceof Process) {
                Process bpmProcess = (Process)((ProjectObjectNode)node).getObject();
                if (bpmProcess != null) {
                    IdeAction action = IdeAction.get((int)ReporterController.REPORT_ON_ONE_PROCESS_CMD_ID, null, (String)ReporterUtils.xlate("MENU_ACTION_PROCESS_REPORT", ReporterUtils.getStudioLocale()), null, null, null, null, (boolean)true);
                    action.addController(ReporterController.getInstance());
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)action), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
                }
            } else if (node instanceof Project) {
                Project ideProject = (Project)node;
                oracle.bpm.project.model.Project bpmProject = null;
                bpmProject = ReporterAddin._getProjectFromRepoService(ideProject);
                if (bpmProject != null) {
                    IdeAction action = IdeAction.get((int)ReporterController.REPORT_ON_PROJECT_CMD_ID, null, (String)ReporterUtils.xlate("MENU_ACTION_PROCESS_REPORT", ReporterUtils.getStudioLocale()), null, null, null, null, (boolean)true);
                    action.addController(ReporterController.getInstance());
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)action), MenuConstants.increment((float)MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES));
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public static class ReporterController
    implements Controller {
        public static final int REPORT_ON_ONE_PROCESS_CMD_ID = Ide.findOrCreateCmdID((String)"REPORT_ON_ONE_PROCESS_CMD_ID");
        public static final int REPORT_ON_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"REPORT_ON_PROJECT_CMD_ID");
        private static Controller _instance;

        private ReporterController() {
        }

        public static Controller getInstance() {
            if (_instance == null) {
                _instance = new ReporterController();
            }
            return _instance;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == REPORT_ON_ONE_PROCESS_CMD_ID) {
                return this._reportProcessClicked(context);
            }
            if (action.getCommandId() == REPORT_ON_PROJECT_CMD_ID) {
                return this._reportProjectClicked(context);
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            boolean enabled = action.getCommandId() == REPORT_ON_ONE_PROCESS_CMD_ID && this._getBpmProcess(context) != null || action.getCommandId() == REPORT_ON_PROJECT_CMD_ID && this._getBpmProject(context) != null;
            action.setEnabled(enabled);
            return enabled;
        }

        private boolean _reportProcessClicked(Context context) {
            Process bpmProcess = this._getBpmProcess(context);
            ReporterDialog rd = new ReporterDialog((Frame)Ide.getMainWindow(), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", ReporterUtils.getStudioLocale()), true);
            rd.setReportScope(ReportScope.PROCESS);
            rd.setBpmProcess(bpmProcess);
            rd.setVisible(true);
            return true;
        }

        private boolean _reportProjectClicked(Context context) {
            oracle.bpm.project.model.Project bpmProject = this._getBpmProject(context);
            ReporterDialog rd = new ReporterDialog((Frame)Ide.getMainWindow(), ReporterUtils.xlate("TITLE_BPM_PROCESS_REPORT", ReporterUtils.getStudioLocale()), true);
            rd.setReportScope(ReportScope.PROJECT);
            rd.setBpmProject(bpmProject);
            rd.setVisible(true);
            return true;
        }

        private Process _getBpmProcess(Context context) {
            Process bpmProcess = null;
            Node node = context.getNode();
            if (node instanceof ProjectObjectNode && ((ProjectObjectNode)node).getObject() instanceof Process) {
                bpmProcess = (Process)((ProjectObjectNode)node).getObject();
            }
            return bpmProcess;
        }

        private oracle.bpm.project.model.Project _getBpmProject(Context context) {
            oracle.bpm.project.model.Project bpmProject = null;
            Node node = context.getNode();
            if (node instanceof Project) {
                Project ideProject = (Project)node;
                bpmProject = ReporterAddin._getProjectFromRepoService(ideProject);
            }
            return bpmProject;
        }
    }
}

