/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public final class PublisherUtils {
    PublisherUtils() {
    }

    public void copyResourceFiles(File file) throws IOException {
        File resourceDir = new File(file.getPath() + File.separator + "Resources");
        if (!resourceDir.exists()) {
            resourceDir.mkdir();
        }
        String path = resourceDir.getPath() + File.separator;
        this._createResourceFile("btnPlus.png", "img/", new FileOutputStream(new File(path + "btnPlus.png")));
        this._createResourceFile("btnMinus.png", "img/", new FileOutputStream(new File(path + "btnMinus.png")));
        this._createResourceFile("ReportScripts.js", "js/", new FileOutputStream(new File(path + "ReportScripts.js")));
        this._createResourceFile("BPMReport.css", "css/", new FileOutputStream(new File(path + "BPMReport.css")));
        this._createResourceFile("BPMReportPrint.css", "css/", new FileOutputStream(new File(path + "BPMReportPrint.css")));
    }

    public HashMap<String, OutputStream> getResourceStreams() throws IOException {
        HashMap<String, OutputStream> hash = new HashMap<String, OutputStream>();
        hash.put("btnPlus.png", this._createResourceFile("btnPlus.png", "img/", new ByteArrayOutputStream()));
        hash.put("btnMinus.png", this._createResourceFile("btnMinus.png", "img/", new ByteArrayOutputStream()));
        hash.put("ReportScripts.js", this._createResourceFile("ReportScripts.js", "js/", new ByteArrayOutputStream()));
        hash.put("BPMReport.css", this._createResourceFile("BPMReport.css", "css/", new ByteArrayOutputStream()));
        hash.put("BPMReportPrint.css", this._createResourceFile("BPMReportPrint.css", "css/", new ByteArrayOutputStream()));
        return hash;
    }

    private OutputStream _createResourceFile(String filename, String subdir, OutputStream out) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/oracle/bpm/tutor/reporter/resources/" + subdir + filename);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = is.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
        is.close();
        out.flush();
        out.close();
        return out;
    }
}

