/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.bpm.draw.diagram.AuditProcessDiagrammer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.ui.utils.ImageIOFacade;

public class ProcessImage {
    public HashMap<String, String> writeFullImageSets(Project project, String dir) throws IOException {
        HashMap<String, String> hash = new HashMap<String, String>();
        int procCtr = 0;
        for (Process process : project.getProcesses()) {
            String imgName = this.writeFullImage(process, dir, project.getName() + "_" + procCtr++);
            hash.put(process.getName(), imgName);
        }
        return hash;
    }

    public HashMap<String, String> createBase64ImageSets(Project project) {
        HashMap<String, String> hash = new HashMap<String, String>();
        for (Process process : project.getProcesses()) {
            hash.put(process.getName(), this.createBase64Image(process));
        }
        return hash;
    }

    public String createBase64Image(Process process) {
        return new AuditProcessDiagrammer(process, false).getImage();
    }

    public String getFullImageStream(Process process, String fileName, ByteArrayOutputStream baos) throws IOException {
        Image image = Image.createFromBase64((String)this.createBase64Image(process));
        String filteredFile = ReporterUtils.filterFilename(fileName);
        ImageIOFacade.writeImage((RenderedImage)((BufferedImage)image.asAwtImage()), (ImageExtension)ImageExtension.PNG, (OutputStream)baos);
        return filteredFile + ".png";
    }

    public String writeFullImage(Process process, String dir, String fileName) throws IOException {
        Image image = Image.createFromBase64((String)this.createBase64Image(process));
        String filteredFile = ReporterUtils.filterFilename(fileName);
        File file = new File(dir + File.separator + filteredFile);
        ImageIOFacade.writeImage((RenderedImage)((BufferedImage)image.asAwtImage()), (ImageExtension)ImageExtension.PNG, (File)new File(file.getAbsolutePath() + ".png"));
        return file.getName() + ".png";
    }

    public HashMap<String, LinkedList<String>> writeCroppedImageSets(Project project, String dir, int widthPx, int heightPx, double overlapPct) throws IOException {
        HashMap<String, LinkedList<String>> hash = new HashMap<String, LinkedList<String>>();
        for (Process process : project.getProcesses()) {
            LinkedList<String> list = this.writeCroppedImages(process, dir, widthPx, heightPx, overlapPct);
            hash.put(process.getName(), list);
        }
        return hash;
    }

    public LinkedList<String> writeCroppedImages(Process process, String dir, int widthPx, int heightPx, double overlapPct) throws IOException {
        Image image = Image.createFromBase64((String)this.createBase64Image(process));
        File file = new File(dir + File.separator + ReporterUtils.filterFilename(process.getName()));
        BufferedImage bi = (BufferedImage)image.asAwtImage();
        int x = 0;
        int y = 0;
        int ctr = -1;
        LinkedList<String> list = new LinkedList<String>();
        while (y < bi.getHeight()) {
            while (x < bi.getWidth()) {
                BufferedImage croppedImage = bi.getSubimage(x, y, this._getMaxMeas(x, widthPx, bi.getWidth()), this._getMaxMeas(y, heightPx, bi.getHeight()));
                ImageIOFacade.writeImage((RenderedImage)croppedImage, (ImageExtension)ImageExtension.PNG, (File)new File(file.getAbsolutePath() + ++ctr + ".png"));
                list.add(file.getAbsolutePath() + Integer.toString(ctr) + ".png");
                x = (int)((double)x + (double)widthPx * (1.0 - overlapPct));
            }
            x = 0;
            y = (int)((double)y + (double)heightPx * (1.0 - overlapPct));
        }
        return list;
    }

    private int _getMaxMeas(int point, int dist, int imgMax) {
        if (imgMax < point + dist) {
            return imgMax - point;
        }
        return dist;
    }
}

