/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.tutor.reporter.AbstractPublisher;
import oracle.bpm.tutor.reporter.PublisherUtils;
import oracle.bpm.tutor.reporter.ReporterUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.w3c.dom.Document;

public class HTMLZipPublisher
extends AbstractPublisher {
    private ByteArrayOutputStream _byteArrayOutputStream;
    private String _htmName;
    private String _targetFile;
    private String _xslPath;
    private StreamSource _xslStream;
    private ZipArchiveOutputStream _zipOutput;

    @Override
    public void publish(Document domDoc) throws IOException, TransformerException {
    }

    @Override
    public ByteArrayOutputStream publishToComposer(Document domDoc) throws TransformerException, IOException {
        DOMSource domSource = new DOMSource(domDoc);
        StreamSource xslStream = this.getXslStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xslStream);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        transformer.transform(domSource, new StreamResult(bos));
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        this.addStreamToZip(in, ReporterUtils.filterFilename(this.getHtmName()) + ".htm");
        PublisherUtils pu = new PublisherUtils();
        for (Map.Entry<String, OutputStream> pairs : pu.getResourceStreams().entrySet()) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(((ByteArrayOutputStream)pairs.getValue()).toByteArray());
            this.addStreamToZip(inStream, "Resources/" + pairs.getKey());
        }
        this.get_zipOutput().close();
        return this._byteArrayOutputStream;
    }

    public void addStreamToZip(ByteArrayInputStream bais, String filename) throws IOException {
        ZipArchiveOutputStream zipOut = this.get_zipOutput();
        zipOut.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(filename));
        byte[] data = new byte[1024];
        int ctr = bais.read(data, 0, 1024);
        while (ctr != -1) {
            zipOut.write(data, 0, ctr);
            ctr = bais.read(data, 0, 1024);
        }
        zipOut.closeArchiveEntry();
    }

    public ZipArchiveOutputStream get_zipOutput() throws IOException {
        if (this._zipOutput == null) {
            this._byteArrayOutputStream = new ByteArrayOutputStream();
            this._zipOutput = new ZipArchiveOutputStream((OutputStream)this._byteArrayOutputStream);
        }
        return this._zipOutput;
    }

    public String getHtmName() {
        return this._htmName;
    }

    public void setHtmName(String htmName) {
        this._htmName = htmName;
    }

    @Override
    public final void setTarget(String outputFileName) {
        this._targetFile = outputFileName;
    }

    @Override
    public final String getTarget() {
        return this._targetFile;
    }

    @Override
    public final void setXslPath(String xslPath) {
        this._xslPath = xslPath;
    }

    public final String getXslPath() {
        return this._xslPath;
    }

    @Override
    public final void setXslStream(StreamSource xslStream) {
        this._xslStream = xslStream;
    }

    public final StreamSource getXslStream() {
        return this._xslStream;
    }
}

