/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bpm.tutor.reporter.AbstractPublisher;
import oracle.bpm.tutor.reporter.PublisherUtils;
import org.w3c.dom.Document;

public class HTMLPublisher
extends AbstractPublisher {
    private String _targetFile;
    private String _xslPath;
    private StreamSource _xslStream;

    @Override
    public void publish(Document domDoc) throws IOException, TransformerException {
        DOMSource xmlStream = new DOMSource(domDoc);
        StreamSource xslStream = null;
        xslStream = this.getXslPath() != null ? new StreamSource(new File(this.getXslPath())) : this.getXslStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer(xslStream);
        FileOutputStream fos = new FileOutputStream(this.getTarget());
        transformer.transform(xmlStream, new StreamResult(fos));
        fos.close();
        PublisherUtils pu = new PublisherUtils();
        pu.copyResourceFiles(new File(this._targetFile).getParentFile());
    }

    @Override
    public ByteArrayOutputStream publishToComposer(Document domDoc) throws TransformerException, IOException {
        DOMSource domSource = new DOMSource(domDoc);
        StreamSource xslStream = this.getXslStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xslStream);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(bos);
        transformer.transform(domSource, streamResult);
        bos.close();
        return (ByteArrayOutputStream)streamResult.getOutputStream();
    }

    @Override
    public final void setTarget(String outputFileName) {
        this._targetFile = outputFileName;
    }

    @Override
    public final String getTarget() {
        return this._targetFile;
    }

    @Override
    public final void setXslPath(String xslPath) {
        this._xslPath = xslPath;
    }

    public final String getXslPath() {
        return this._xslPath;
    }

    @Override
    public final void setXslStream(StreamSource xslStream) {
        this._xslStream = xslStream;
    }

    public final StreamSource getXslStream() {
        return this._xslStream;
    }
}

