/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.reporter;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.tutor.reporter.ReporterUtils;
import oracle.bpm.tutor.reporter.jaxb.reportdata.BpmObject;
import oracle.bpm.tutor.reporter.jaxb.reportdata.BpmObjects;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Coord;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Definitions;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Relationship;
import oracle.bpm.tutor.reporter.jaxb.reportdata.Relationships;
import oracle.bpm.tutor.reporter.jaxb.reportdata.TIncoming;
import oracle.bpm.tutor.reporter.jaxb.reportdata.TOutgoing;
import oracle.bpm.tutor.reporter.jaxb.reportdata.TProperty;
import oracle.bpm.tutor.reporter.jaxb.reportdata.TPropertyGroupType;

public class Extractor {
    private HashMap<String, String> _base64Image = null;
    private Locale _browserLocale;
    private HashMap<String, LinkedList<String>> _croppedImageHash = null;
    private Definitions _definitions;
    private HashMap<String, String> _fullSizeImageHash = null;
    private int _idCtr = 0;
    private Locale _locale;
    private String _processID = null;

    public void setBrowserLocale(Locale browserLocale) {
        this._browserLocale = browserLocale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setFullSizeImageHash(HashMap<String, String> fullSizeImageHash) {
        this._fullSizeImageHash = fullSizeImageHash;
    }

    public HashMap<String, String> getFullSizeImageHash() {
        return this._fullSizeImageHash;
    }

    public void setCroppedImageHash(HashMap<String, LinkedList<String>> croppedImageHash) {
        this._croppedImageHash = croppedImageHash;
    }

    public HashMap<String, LinkedList<String>> getCroppedImageHash() {
        return this._croppedImageHash;
    }

    public void setBase64ImageHash(HashMap<String, String> base64Image) {
        this._base64Image = base64Image;
    }

    public HashMap<String, String> getBase64ImageHash() {
        return this._base64Image;
    }

    public Definitions getDefinitions() {
        return this._definitions;
    }

    public void extractDefinitions(Project project) {
        Definitions definitions = new Definitions();
        this._addDefinitionsProperties(definitions);
        BpmObject projFolderNode = this._populateNodeData("prf_", "PROJECTFOLDER", null, definitions);
        BpmObject projNode = this._populateNodeData("prj_", "PROJECT", project.getName(), projFolderNode);
        BpmObject collabNode = this._populateNodeData("col_", "COLLABORATION", null, projNode);
        BpmObject participantNode = this._populateNodeData("par_", "PARTICIPANT", null, collabNode);
        BpmObjects bpmObjsNode = new BpmObjects();
        Relationships relationshipsNode = new Relationships();
        for (Process process : project.getProcesses()) {
            this._processID = process.getId();
            BpmObject processNode = new BpmObject();
            this._addProcessContent(process, processNode, bpmObjsNode);
            this._addRelationshipsProperties(relationshipsNode);
            this._addProcessRelationships(process, relationshipsNode);
        }
        definitions.setRelationships(relationshipsNode);
        participantNode.setBpmObjects(bpmObjsNode);
        this._definitions = definitions;
    }

    public void extractDefinitions(Process process) {
        Definitions definitions = new Definitions();
        this._addDefinitionsProperties(definitions);
        BpmObject projFolderNode = this._populateNodeData("prf_", "PROJECTFOLDER", null, definitions);
        BpmObject projNode = this._populateNodeData("prj_", "PROJECT", null, projFolderNode);
        BpmObject collabNode = this._populateNodeData("col_", "COLLABORATION", null, projNode);
        BpmObject particNode = this._populateNodeData("par_", "PARTICIPANT", null, collabNode);
        BpmObjects bpmObjsNode = new BpmObjects();
        this._processID = process.getId();
        BpmObject processNode = new BpmObject();
        this._addProcessContent(process, processNode, bpmObjsNode);
        particNode.setBpmObjects(bpmObjsNode);
        Relationships relationshipsNode = new Relationships();
        this._addRelationshipsProperties(relationshipsNode);
        this._addProcessRelationships(process, relationshipsNode);
        definitions.setRelationships(relationshipsNode);
        this._definitions = definitions;
    }

    private void _addRelationshipsProperties(Relationships relationshipsNode) {
        relationshipsNode.getProperty().add(this._addTProperty("outflowsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_OUTFLOWS", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("inflowsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_INFLOWS", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("seqFlowsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_SEQ_FLOWS", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("targetObjsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_TARGET_OBJS", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("seqFlowNameDisplay", null, ReporterUtils.xlate("REPORT_HEADING_SEQFLOW_NAME", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("seqFlowDescDisplay", null, ReporterUtils.xlate("REPORT_HEADING_SEQFLOW_DESC", this._locale)));
        relationshipsNode.getProperty().add(this._addTProperty("seqFlowCondDisplay", null, ReporterUtils.xlate("REPORT_HEADING_SEQFLOW_COND", this._locale)));
    }

    private void _addDefinitionsProperties(Definitions definitionsNode) {
        definitionsNode.getProperty().add(this._addTProperty("reportDate", this._getDateTime(), ReporterUtils.xlate("REPORT_HEADING_REPORT_DATE", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("processReportDisplay", null, ReporterUtils.xlate("REPORT_HEADING_PROCESS_REPORT", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("hideDetailsDisplay", null, ReporterUtils.xlate("REPORT_UI_HIDE_DETAILS", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("showDetailsDisplay", null, ReporterUtils.xlate("REPORT_UI_SHOW_DETAILS", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("processPropsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_PROC_PROPS", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("processImgDisplay", null, ReporterUtils.xlate("REPORT_HEADING_PROC_IMG", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("processStepsDisplay", null, ReporterUtils.xlate("REPORT_HEADING_PROC_STEPS", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("lanesDisplay", null, ReporterUtils.xlate("REPORT_HEADING_LANES", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("laneDisplay", null, ReporterUtils.xlate("REPORT_HEADING_LANE", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("objNameDisplay", null, ReporterUtils.xlate("REPORT_HEADING_OBJECT_NAME", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("procNameDisplay", null, ReporterUtils.xlate("REPORT_HEADING_PROCESS_NAME", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("objTypeDisplay", null, ReporterUtils.xlate("REPORT_HEADING_OBJECT_TYPE", this._locale)));
        definitionsNode.getProperty().add(this._addTProperty("noneDisplay", null, ReporterUtils.xlate("REPORT_DATA_NONE", this._locale)));
    }

    private String _getXlatedStr(FlowElement flowElement) {
        String ret = flowElement.getLabel(this._locale);
        if (ret.length() == 0) {
            if (this._browserLocale != null) {
                ret = flowElement.getLabel(this._browserLocale);
            }
            if (ret.length() == 0 && (ret = flowElement.getLabel(LocaleStringMap.getDefaultLanguage())).length() == 0) {
                ret = flowElement.getName();
            }
        }
        return ret;
    }

    private void _addProcessContent(Process process, BpmObject processNode, BpmObjects bpmObjsNode) {
        processNode = this._setBPMObjectData(processNode, "PROCESS", this._getXlatedStr((FlowElement)process), process.getId());
        processNode.getProperty().add(this._addTProperty("author", process.getAuthor(), ReporterUtils.xlate("REPORT_HEADING_AUTHOR", this._locale)));
        processNode.getProperty().add(this._addTProperty("description", process.getDescriptionMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_DESCRIPTION", this._locale)));
        processNode.getProperty().add(this._addTProperty("project", process.getProject().getName(), ReporterUtils.xlate("REPORT_HEADING_PROJECT", this._locale)));
        processNode.getProperty().add(this._addTProperty("useCaseDocumentation", process.getUseCaseDocumentationMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_USE_CASE_DOC", this._locale)));
        LinkedList<DataDeclaration> globalDecls = new LinkedList<DataDeclaration>();
        for (DataDeclaration dd : process.getDeclarations()) {
            if (process.getLocalDeclarations().contains((Object)dd)) continue;
            globalDecls.add(dd);
        }
        processNode.getPropertyGroup().add(this._addTPropertyGroupDataDecl("Declarations", ReporterUtils.xlate("REPORT_HEADING_GLOBAL_VARS", this._locale), ReporterUtils.xlate("REPORT_HEADING_GLOBAL_VAR_NAME", this._locale), ReporterUtils.xlate("REPORT_HEADING_GLOBAL_VAR_TYPE", this._locale), globalDecls));
        processNode.getPropertyGroup().add(this._addTPropertyGroupDataDecl("Local Declarations", ReporterUtils.xlate("REPORT_HEADING_LOCAL_VARS", this._locale), ReporterUtils.xlate("REPORT_HEADING_LOCAL_VAR_NAME", this._locale), ReporterUtils.xlate("REPORT_HEADING_LOCAL_VAR_TYPE", this._locale), (Iterable<DataDeclaration>)process.getLocalDeclarations()));
        try {
            if (process.getPath() != null) {
                processNode.getProperty().add(this._addTProperty("path", process.getPath().toString(), ReporterUtils.xlate("REPORT_HEADING_PATH", this._locale)));
            }
        }
        catch (NullPointerException e) {
            processNode.getProperty().add(this._addTProperty("path", null, ReporterUtils.xlate("REPORT_HEADING_PATH", this._locale)));
        }
        String imgName = null;
        if (this.getFullSizeImageHash() != null) {
            imgName = this.getFullSizeImageHash().get(process.getName());
        }
        processNode.getProperty().add(this._addTProperty("imgName", imgName, null));
        if (this.getCroppedImageHash() != null) {
            processNode.getPropertyGroup().add(this._addTPropertyGroupImage("CroppedImages", null, null, null, this.getCroppedImageHash().get(process.getName())));
        }
        if (this.getBase64ImageHash() != null) {
            String base64Img = this.getBase64ImageHash().get(process.getName());
            processNode.getProperty().add(this._addTProperty("base64ImageData", base64Img, null));
        }
        BpmObjects bpmObjectsNode = new BpmObjects();
        for (Lane lane : process.getLanes()) {
            BpmObject laneNode = new BpmObject();
            Coord c = new Coord();
            c.setX(0.0);
            c.setY(Double.valueOf(lane.getOffset()));
            laneNode.setCoord(c);
            laneNode.getProperty().add(this._addTProperty("description", lane.getDescriptionMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_DESCRIPTION", this._locale)));
            laneNode.setBpmObjects(this._addLaneActivities(lane));
            bpmObjectsNode.getBpmObject().add(this._setBPMObjectData(laneNode, "Lane", this._getXlatedStr((FlowElement)lane), lane.getId()));
        }
        processNode.setBpmObjects(bpmObjectsNode);
        bpmObjsNode.getBpmObject().add(processNode);
    }

    private BpmObject _populateNodeData(String prefix, String objType, String name, Object prevNode) {
        BpmObject newNode = new BpmObject();
        BpmObjects bpmObjects = this._addBPMObjects(prefix, newNode, objType, name);
        if (prevNode instanceof BpmObject) {
            ((BpmObject)prevNode).setBpmObjects(bpmObjects);
        } else if (prevNode instanceof Definitions) {
            ((Definitions)prevNode).setBpmObjects(bpmObjects);
        }
        return newNode;
    }

    private void _addProcessRelationships(Process process, Relationships relationshipsNode) {
        for (SequenceFlow sflow : process.getSequenceFlows()) {
            this._addRelationships(sflow, relationshipsNode);
        }
        for (Activity a : process.getActivities()) {
            if (!a.isSubprocess()) continue;
            for (SequenceFlow sflow : ((Subprocess)a).getSequenceFlows()) {
                this._addRelationships(sflow, relationshipsNode);
            }
        }
    }

    private void _addRelationships(SequenceFlow sflow, Relationships relObjects) {
        Relationship rel = new Relationship();
        rel.setId(sflow.getId() + this._processID);
        rel.setName(this._getXlatedStr((FlowElement)sflow));
        rel.setSourceObject(sflow.getSource().getId() + this._processID);
        rel.setTargetObject(sflow.getTarget().getId() + this._processID);
        rel.setRelationshipType(sflow.getSequenceFlowType().toString());
        rel.getProperty().add(this._addTProperty("description", sflow.getDescriptionMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_DESCRIPTION", this._locale)));
        rel.getProperty().add(this._addTProperty("useCaseDocumentation", sflow.getUseCaseDocumentationMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_USE_CASE_DOC", this._locale)));
        rel.getProperty().add(this._addTProperty("isDefault", String.valueOf(sflow.isDefault()), null));
        if (sflow.isConditionalFlow()) {
            ConditionalFlow condFlow = (ConditionalFlow)sflow;
            Expression condition = condFlow.getCondition();
            rel.getProperty().add(this._addTProperty("condition", condition != null ? condition.getExpressionValue() : null, null));
        }
        relObjects.getRelationship().add(rel);
    }

    private TProperty _addTProperty(String name, String content, String displayName) {
        TProperty tprop = new TProperty();
        tprop.setId("tut" + ++this._idCtr + this._processID);
        tprop.setName(name);
        tprop.setContent(content);
        tprop.setDisplayName(displayName);
        return tprop;
    }

    private TPropertyGroupType _addTPropertyGroupImage(String groupName, String groupDisplayName, String groupNameHeading, String groupValueHeading, LinkedList<String> list) {
        TPropertyGroupType tpGroup = this._setTPropertyGroupData(groupName, groupDisplayName, groupNameHeading, groupValueHeading);
        for (String imgName : list) {
            tpGroup.getProperty().add(this._addTProperty("ImageName", imgName, null));
        }
        return tpGroup;
    }

    private TPropertyGroupType _addTPropertyGroupAnnotation(String groupName, String groupDisplayName, String groupNameHeading, String groupValueHeading, Set<Map.Entry<String, String>> map) {
        TPropertyGroupType tpGroup = this._setTPropertyGroupData(groupName, groupDisplayName, groupNameHeading, groupValueHeading);
        for (Map.Entry<String, String> myMap : map) {
            TPropertyGroupType tpg = new TPropertyGroupType();
            tpg.getProperty().add(this._addTProperty("Key", myMap.getKey(), null));
            tpg.getProperty().add(this._addTProperty("Value", myMap.getValue(), null));
            tpGroup.getPropertyGroup().add(tpg);
        }
        return tpGroup;
    }

    private TPropertyGroupType _addTPropertyGroupDataDecl(String groupName, String groupDisplayName, String groupNameHeading, String groupValueHeading, Iterable<DataDeclaration> sequence) {
        TPropertyGroupType tpGroup = this._setTPropertyGroupData(groupName, groupDisplayName, groupNameHeading, groupValueHeading);
        for (DataDeclaration dataDecl : sequence) {
            if (dataDecl.getDeclarationType() == DataDeclarationType.PROCESS_PREDEFINED_VARIABLE) continue;
            TPropertyGroupType tpg = new TPropertyGroupType();
            tpg.getProperty().add(this._addTProperty("Name", dataDecl.getName(), null));
            tpg.getProperty().add(this._addTProperty("DeclarationType", dataDecl.getType().getText(), null));
            tpGroup.getPropertyGroup().add(tpg);
        }
        return tpGroup;
    }

    private TPropertyGroupType _addTPropertyGroupBoundaryEvent(String groupName, String groupDisplayName, String groupNameHeading, String groupValueHeading, Sequence<BoundaryEvent> sequence) {
        TPropertyGroupType tpGroup = this._setTPropertyGroupData(groupName, groupDisplayName, groupNameHeading, groupValueHeading);
        for (BoundaryEvent event : sequence) {
            TPropertyGroupType tpg = new TPropertyGroupType();
            tpg.getProperty().add(this._addTProperty("EventID", event.getId(), null));
            tpg.getProperty().add(this._addTProperty("EventName", this._getXlatedStr((FlowElement)event), null));
            tpg.getProperty().add(this._addTProperty("LeadsToID", event.getBoundaryActivity().getId(), null));
            tpg.getProperty().add(this._addTProperty("LeadsToName", this._getXlatedStr((FlowElement)event.getBoundaryActivity()), null));
            tpGroup.getPropertyGroup().add(tpg);
        }
        return tpGroup;
    }

    private TPropertyGroupType _setTPropertyGroupData(String groupName, String groupDisplayName, String groupNameHeading, String groupValueHeading) {
        TPropertyGroupType tpGroup = new TPropertyGroupType();
        tpGroup.setName(groupName);
        tpGroup.setDisplayName(groupDisplayName);
        tpGroup.setNameHeading(groupNameHeading);
        tpGroup.setValueHeading(groupValueHeading);
        return tpGroup;
    }

    private BpmObjects _addBPMObjects(String idpref, BpmObject bpmObj, String objType, String name) {
        bpmObj.setObjectType(objType);
        bpmObj.setName(name);
        bpmObj.setId(idpref + ++this._idCtr + this._processID);
        BpmObjects bpmObjects = new BpmObjects();
        bpmObjects.getBpmObject().add(bpmObj);
        return bpmObjects;
    }

    private BpmObject _setBPMObjectData(BpmObject bpmObj, String objType, String name, String id) {
        bpmObj.setObjectType(objType);
        bpmObj.setName(name);
        bpmObj.setId(id + this._processID);
        return bpmObj;
    }

    private BpmObjects _addLaneActivities(Lane lane) {
        BpmObjects bpmObjs = new BpmObjects();
        for (FlowNode fn : lane.getActivities()) {
            this._addActivities(fn, bpmObjs);
        }
        return bpmObjs;
    }

    private void _addActivities(FlowNode fn, BpmObjects bpmObjs) {
        BpmObject obj = this._addFlowNodeCommonProperties(fn);
        if (fn.isEvent()) {
            Event ev = (Event)fn;
            obj.getProperty().add(this._addTProperty("eventDefinition", ev.getEventDefinition() != null ? ev.getEventDefinition().toString() : null, ReporterUtils.xlate("REPORT_HEADING_EVENT_DEFINITION", this._locale)));
            obj.getProperty().add(this._addTProperty("trigger", ev.getEventTriggerType().toString(), ReporterUtils.xlate("REPORT_HEADING_EVENT_TRIGGER", this._locale)));
        } else if (fn.isGateway()) {
            Gateway gw = (Gateway)fn;
            obj.getProperty().add(this._addTProperty("gatewayDirection", gw.getDirection().getString(), ReporterUtils.xlate("REPORT_HEADING_GATEWAY_DIRECTION", this._locale)));
        } else if (fn.getBpmnType().equals((Object)BpmnType.SUBPROCESS)) {
            Subprocess sub = (Subprocess)fn;
            for (Activity fnSub : sub.getActivities()) {
                this._addActivities((FlowNode)fnSub, bpmObjs);
            }
            for (Activity fnSub : sub.getEvents()) {
                this._addActivities((FlowNode)fnSub, bpmObjs);
            }
            for (Activity fnSub : sub.getGateways()) {
                this._addActivities((FlowNode)fnSub, bpmObjs);
            }
            obj.getProperty().add(this._addTProperty("LoopCharacteristicsType", sub.getLoopCharacteristicsType() != null ? sub.getLoopCharacteristicsType().getString() : null, ReporterUtils.xlate("REPORT_HEADING_LOOP_TYPE", this._locale)));
            if (!sub.getActivityBoundaryEvents().isEmpty()) {
                obj.getPropertyGroup().add(this._addTPropertyGroupBoundaryEvent("Boundary Events", ReporterUtils.xlate("REPORT_HEADING_BOUNDARY_EVENTS", this._locale), ReporterUtils.xlate("REPORT_HEADING_EVENT_NAME", this._locale), ReporterUtils.xlate("REPORT_HEADING_LEADS_TO", this._locale), (Sequence<BoundaryEvent>)sub.getActivityBoundaryEvents()));
            }
        } else if (fn.getBpmnType().isActivity()) {
            Activity act = (Activity)fn;
            obj.getProperty().add(this._addTProperty("LoopCharacteristicsType", act.getLoopCharacteristicsType() != null ? act.getLoopCharacteristicsType().getString() : null, ReporterUtils.xlate("REPORT_HEADING_LOOP_TYPE", this._locale)));
            if (!act.getActivityBoundaryEvents().isEmpty()) {
                obj.getPropertyGroup().add(this._addTPropertyGroupBoundaryEvent("Boundary Events", ReporterUtils.xlate("REPORT_HEADING_BOUNDARY_EVENTS", this._locale), ReporterUtils.xlate("REPORT_HEADING_EVENT_NAME", this._locale), ReporterUtils.xlate("REPORT_HEADING_LEADS_TO", this._locale), (Sequence<BoundaryEvent>)act.getActivityBoundaryEvents()));
            }
        }
        bpmObjs.getBpmObject().add(obj);
    }

    private String _getDateTime() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, this._locale);
        Date date = new Date();
        return dateFormat.format(date);
    }

    private BpmObject _addFlowNodeCommonProperties(FlowNode fn) {
        BpmObject bpmObj = new BpmObject();
        bpmObj.setId(fn.getId() + this._processID);
        String nodeName = this._getXlatedStr((FlowElement)fn);
        bpmObj.setName(nodeName);
        bpmObj.setObjectType(fn.getBpmnType().getString());
        bpmObj.setHeight(Double.valueOf(fn.getHeight()));
        bpmObj.setWidth(Double.valueOf(fn.getWidth()));
        for (SequenceFlow seq : fn.getIncomingSequenceFlows()) {
            TIncoming tinc = new TIncoming();
            tinc.setId(seq.getId() + this._processID);
            bpmObj.getIncoming().add(tinc);
        }
        for (SequenceFlow seq : fn.getOutgoingSequenceFlows()) {
            TOutgoing tout = new TOutgoing();
            tout.setId(seq.getId() + this._processID);
            bpmObj.getOutgoing().add(tout);
        }
        Coord c = new Coord();
        c.setX(Double.valueOf(fn.getX()));
        c.setY(Double.valueOf(fn.getY()));
        bpmObj.setCoord(c);
        bpmObj.getProperty().add(this._addTProperty("useCaseDocumentation", fn.getUseCaseDocumentationMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_USE_CASE_DOC", this._locale)));
        bpmObj.getProperty().add(this._addTProperty("description", fn.getDescriptionMap().getString(this._locale), ReporterUtils.xlate("REPORT_HEADING_DESCRIPTION", this._locale)));
        bpmObj.getProperty().add(this._addTProperty("parentSubprocess", fn.getSubprocess() != null ? fn.getSubprocess().getId() + this._processID : null, ReporterUtils.xlate("REPORT_HEADING_PARENT_SUBPROCESS", this._locale)));
        bpmObj.getPropertyGroup().add(this._addTPropertyGroupAnnotation("Annotations", ReporterUtils.xlate("REPORT_HEADING_ANNOTATIONS", this._locale), ReporterUtils.xlate("REPORT_HEADING_ANNOTATION_NAME", this._locale), ReporterUtils.xlate("REPORT_HEADING_ANNOTATION_VALUE", this._locale), fn.getAnnotations(true).entrySet()));
        return bpmObj;
    }
}

