/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.msg;

import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NotNull;

public class MetadataMsg
extends MsgBundle {
    public static final ErrorMsg PML_IO_ERROR = MetadataMsg.errorMsg("An I/O error occurred", "", "");
    public static final ErrorMsg METADATA_EXCEPTION = MetadataMsg.errorMsg("Metadata operation failed", "", "");
    public static final ErrorMsg NO_ACTIVE_TRANSACTIONS = MetadataMsg.errorMsg("There is not active transactions to commit", "", "");
    public static final ErrorMsg ROLLBACKED_TRANSACTION = MetadataMsg.errorMsg("The transaction is rollbacked", "", "");
    public static final ErrorMsg COPY_FILE_ERROR = MetadataMsg.errorMsg("Error while copying file", "The project could not be copied", "");
    public static final ErrorMsg DEPLOYMENT_AUTHENTICATION_FAILED = MetadataMsg.errorMsg("Incorrect Username/Password", "The username or password entered was incorrect", "Try again");
    public static final ErrorMsg DEPLOYMENT_REVISION_ERROR = MetadataMsg.errorMsg("Revision ID already exists", "A deployed project with the same revision ID was found", "Use a different revision ID");
    public static final ErrorMsg DEPLOYMENT_INVALID_USER_ROLE = MetadataMsg.errorMsg("User cannot deploy/undeploy projects", "The user did not have the privilege of deploying/undeploying projects", "Use a different user ID");
    public static final ErrorMsg DEPLOYMENT_CONFIGURATION = MetadataMsg.errorMsg("Deployment data is invalid", "The deployment configuration is invalid", "");
    public static final ErrorMsg DEPLOYMENT_FAILED = MetadataMsg.errorMsg("Deployment failed", "An unexpected error has occurred during deployment", "");
    public static final ErrorMsg DEPLOYMENT_VALIDATION_ERROR = MetadataMsg.errorMsg("Deployment validation failed", "An unexpected error has occurred during deployment validation", "");
    public static final ErrorMsg DEPLOYMENT_URL_ERROR = MetadataMsg.errorMsg("The deployment server URL is invalid", "An error has occurred when trying to connect to the specified server URL", "");
    public static final ErrorMsg DEPLOYMENT_NOT_AVAILABLE = MetadataMsg.errorMsg("There is no deployment configuration information available", "", "");
    public static final ErrorMsg INVALID_PROJECT = MetadataMsg.errorMsg("The project is invalid", "", "");
    public static final ErrorMsg VERSIONING_NOT_SUPPORTED = MetadataMsg.errorMsg("The metadata store on which the operation would take effect does not support versioning.", "Versioning not supported", "");
    public static final ErrorMsg USER_AUTHENTICATION_ERROR = MetadataMsg.errorMsg("Invalid user name or password", "An invalid user name or password was provided", "");
    public static final ErrorMsg HOST_NOT_SET = MetadataMsg.errorMsg("The Hostname is not set", "The field Hostname is required", "");
    public static final ErrorMsg PORT_NOT_SET = MetadataMsg.errorMsg("The Port is not set", "The field Port is required", "");
    public static final ErrorMsg SID_NOT_SET = MetadataMsg.errorMsg("The SID is not set", "The field SID is required", "");
    public static final ErrorMsg USERNAME_NOT_SET = MetadataMsg.errorMsg("The Username is not set", "The field Username is required", "");
    public static final ErrorMsg PASSWORD_NOT_SET = MetadataMsg.errorMsg("The Password is not set", "The field Password is required", "");
    public static final Msg ADMIN_ANY_PROJECT = MetadataMsg.msg("Project Administrator");
    public static final Msg DEVELOP_ANY_PROJECT = MetadataMsg.msg("Developer");
    public static final Msg VIEW_ANY_PROJECT = MetadataMsg.msg("Project Viewer");
    public static final Msg SOA_DESIGNER = MetadataMsg.msg("SOA Designer");
    public static final ErrorMsg PROJECT_IS_NOT_TEMPLATE = MetadataMsg.errorMsg("The specified project is not a template", "", "");
    public static final ErrorMsg PROJECT_IS_NOT_PUBLIC_SHARE = MetadataMsg.errorMsg("The specified project is not a public share", "", "");
    public static final ErrorMsg OWNER_NOT_SET = MetadataMsg.errorMsg("The owner is not set", "", "");
    private static final TErrorMsg INVALID_NAMESPACE = MetadataMsg.tErrorMsg("Namespace '%0' is not a valid namespace", "Not a valid namespace", "Check namespace is correct");
    private static final TErrorMsg LABEL_NOT_FOUND = MetadataMsg.tErrorMsg("Label '%0' could not be found", "The specified label could not be found", "Check that the label exists");
    private static final TErrorMsg MULTIPLE_LABELS = MetadataMsg.tErrorMsg("There are more than one version selector for the namespace '%0'", "Only one Label may be used at a time to select metadata from a namespace", "Check that you are using only one label to select metadata from the namespace");
    private static final TErrorMsg FOLDER_NOT_EXISTS = MetadataMsg.tErrorMsg("Folder '%0' does not exist", "The specified folder was not found", "Check the name of the folder is correct");
    public static final TErrorMsg NOT_OWNER = MetadataMsg.tErrorMsg("The current user is not the owner of the project %0", "", "");
    private static final TErrorMsg PACKAGE_ALREADY_EXISTS = MetadataMsg.tErrorMsg("Folder '%0' already exists", "The specified folder already exists", "Check the name of the folder is correct");
    private static final TErrorMsg FOLDER_NOT_EMPTY = MetadataMsg.tErrorMsg("Cannot delete folder '%0'", "The specified folder is not empty", "Remove any artifact inside the folder before removing it");
    private static final TErrorMsg PROCESS_NOT_FOUND = MetadataMsg.tErrorMsg("Process '%0' not found", "The specified process was not found", "Check that the name of the process is correct");
    private static final TErrorMsg PROJECT_NOT_FOUND = MetadataMsg.tErrorMsg("Project not found in folder '%0'", "The specified project was not found", "Check that the name of the project is correct");
    private static final TErrorMsg PROJECT_ALREADY_EXISTS = MetadataMsg.tErrorMsg("The Project '%0' already exists in '%1'", "A project with the same name already exists in the specified location", "Use a new name or delete the existing project");
    private static final TErrorMsg STUDIO_PROJECT_ALREADY_EXISTS = MetadataMsg.tErrorMsg("Cannot create the Project '%0', it already exists'", "A project with the same name as the specified was found in the repository", "Change the project name");
    private static final TErrorMsg PROJECT_LOCKED = MetadataMsg.tErrorMsg("The project is locked by the user '%0'%1", "The project was already locked by another user or from a different application", "The lock has to be released using the same user and application");
    public static final Msg APPLICATION_STUDIO = MetadataMsg.msg(" in Studio application");
    public static final Msg APPLICATION_COMPOSER = MetadataMsg.msg(" in Composer application");
    public static final TErrorMsg PROJECT_VERSION_OUTDATED = MetadataMsg.tErrorMsg("The project %0 has a newer version", "An attempt to update was made with an outdated project version", "Update to the most recent project version first");
    public static final TErrorMsg INVALID_PATH = MetadataMsg.tErrorMsg("The path '%0' is invalid", "The path contained invalid characters", "Try to avoid using special characters in the path");
    public static final TErrorMsg ARTIFACT_NOT_FOUND = MetadataMsg.tErrorMsg("Artifact '%0' not found", "The artifact was not found", "");
    public static final TErrorMsg PML_FATAL_ERROR = MetadataMsg.tErrorMsg("An error occurs when trying to access the '%0' resource", "", "");
    public static final TErrorMsg ARTIFACT_ALREADY_EXISTS = MetadataMsg.tErrorMsg("The artifact '%0' already exists", "", "");
    public static final TErrorMsg ARTIFACT_LOCATION_MISMATCH = MetadataMsg.tErrorMsg("The artifact '%0' already exists in a different location", "An artifact with the same name was found in a different location than the specified", "Change the artifact name or delete the existing artifact first");
    public static final TErrorMsg UNABLE_TO_UPDATE_FROM_BASE_TEMPLATE = MetadataMsg.tErrorMsg("Could not update project %0, there is not enough metadata or it is malformed.", "An attempt to update from base template was made but there is not enough metadata (or it is malformed) to complete the operation on project %0", "");
    private static final TErrorMsg UNABLE_TO_DELETE_TEMPLATE = MetadataMsg.tErrorMsg("Could not delete template %0.", "An attempt to delete template %0 was made but the following public shares still hold referenceto the template %1", "Choose to remove references automatically or manually delete the public shares created from the template");
    public static final TErrorMsg NEGATIVE_MAX_ROW_PER_PAGE = MsgBundle.tErrorMsg("Invalid Max Row Per Page value", "The Max Row Per Page value is: %0. It should be greater than 0", "Specify a value which is greater than 0");
    public static final TErrorMsg NEGATIVE_FROM_PAGE = MsgBundle.tErrorMsg("Invalid From page value", "The From page value is: %0. It should be greater than 0", "Specify a value which is greater than 0");
    public static final TErrorMsg TO_PAGE_LESS_THAN_ONE = MsgBundle.tErrorMsg("Invalid To Page value", "The To Page value is: %0. It should be greater than 1", "Specify a value which is greater than 1");
    public static final TErrorMsg FROM_GREATER_THAN_TO = MsgBundle.tErrorMsg("Invalid From Page and To Page values", "The From page value is: %0 and To page is: %1. To Page must be greater than From page", "Specify a value for To Page which is greater that the one for From Page");
    public static final TErrorMsg INVALID_FROM_TO_TIMESTAMPS = MetadataMsg.tErrorMsg("Query could not be created. Invalid From and To timestamps", "The From timestamp is: %0 and To timestamp is: %1. To timestamp must refer to a date after from timestamp", "Specify a value for To timestamp which is greater that the one for From timestamp");
    public static final TErrorMsg NEGATIVE_RECENTLY_CHANGED_QTY = MetadataMsg.tErrorMsg("Invalid amount of recently changed items", "The amount of recently changed items is: %0. It should be greater than 0", "Specify a value which is greater than 0");
    public static final Msg ADDED = MetadataMsg.msg("Added");
    public static final Msg DELETED = MetadataMsg.msg("Deleted");
    public static final Msg MODIFIED = MetadataMsg.msg("Modified");
    public static final Msg CHANGE_TITLE_CREATION = MetadataMsg.msg("Project creation");
    public static final Msg CHANGE_TITLE_RESOURCE = MetadataMsg.msg("Modified Resources");
    public static final TMsg CHANGE_TITLE = MetadataMsg.tmsg(" %0 %1 ");
    public static final TMsg CHANGE_TITLE_MULTIPLE = MetadataMsg.tmsg(" %0 %1 ...");
    public static final TMsg CHANGE_SUBTITLE = MetadataMsg.tmsg(" %0 - %1 ");

    public static ErrorMsg INVALID_NAMESPACE(String _arg0) {
        return INVALID_NAMESPACE.args(_arg0);
    }

    public static ErrorMsg LABEL_NOT_FOUND(String _arg0) {
        return LABEL_NOT_FOUND.args(_arg0);
    }

    public static ErrorMsg MULTIPLE_LABELS(String _arg0) {
        return MULTIPLE_LABELS.args(_arg0);
    }

    public static ErrorMsg FOLDER_NOT_EXISTS(String _arg0) {
        return FOLDER_NOT_EXISTS.args(_arg0);
    }

    public static ErrorMsg PACKAGE_ALREADY_EXISTS(String _arg0) {
        return PACKAGE_ALREADY_EXISTS.args(_arg0);
    }

    public static ErrorMsg FOLDER_NOT_EMPTY(String _arg0) {
        return FOLDER_NOT_EMPTY.args(_arg0);
    }

    public static ErrorMsg PROJECT_NOT_FOUND(String _arg0) {
        return PROJECT_NOT_FOUND.args(_arg0);
    }

    public static ErrorMsg PROCESS_NOT_FOUND(String _arg0) {
        return PROCESS_NOT_FOUND.args(_arg0);
    }

    public static ErrorMsg PROJECT_ALREADY_EXISTS(String projectName, String path) {
        return PROJECT_ALREADY_EXISTS.args(projectName, path);
    }

    public static ErrorMsg STUDIO_PROJECT_ALREADY_EXISTS(String applicationName) {
        return STUDIO_PROJECT_ALREADY_EXISTS.args(applicationName);
    }

    public static ErrorMsg PROJECT_LOCKED(String userName, String applicationName) {
        return PROJECT_LOCKED.args(userName, applicationName);
    }

    public static ErrorMsg PROJECT_VERSION_OUTDATED(String _arg0) {
        return PROJECT_VERSION_OUTDATED.args(_arg0);
    }

    public static ErrorMsg INVALID_PATH(String _arg0) {
        return INVALID_PATH.args(_arg0);
    }

    public static ErrorMsg ARTIFACT_NOT_FOUND(String _arg0) {
        return ARTIFACT_NOT_FOUND.args(_arg0);
    }

    public static ErrorMsg PML_FATAL_ERROR(String _arg0) {
        return PML_FATAL_ERROR.args(_arg0);
    }

    public static ErrorMsg ARTIFACT_ALREADY_EXISTS(String _arg0) {
        return ARTIFACT_ALREADY_EXISTS.args(_arg0);
    }

    public static ErrorMsg ARTIFACT_LOCATION_MISMATCH(String _arg0) {
        return ARTIFACT_LOCATION_MISMATCH.args(_arg0);
    }

    public static ErrorMsg NOT_OWNER(String _arg0) {
        return NOT_OWNER.args(_arg0);
    }

    public static ErrorMsg UNABLE_TO_UPDATE_FROM_BASE_TEMPLATE(@NotNull String _arg0) {
        if (_arg0 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/msg/MetadataMsg.UNABLE_TO_UPDATE_FROM_BASE_TEMPLATE must not be null");
        }
        return UNABLE_TO_UPDATE_FROM_BASE_TEMPLATE.args(_arg0);
    }

    public static ErrorMsg UNABLE_TO_DELETE_TEMPLATE(@NotNull String templateName, @NotNull String linkedProjectsNames) {
        if (templateName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/msg/MetadataMsg.UNABLE_TO_DELETE_TEMPLATE must not be null");
        }
        if (linkedProjectsNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/msg/MetadataMsg.UNABLE_TO_DELETE_TEMPLATE must not be null");
        }
        return UNABLE_TO_DELETE_TEMPLATE.args(templateName, linkedProjectsNames);
    }

    public static Msg CHANGE_TITLE_MULTIPLE(String action, String artifactName) {
        return CHANGE_TITLE_MULTIPLE.args(action, artifactName);
    }

    public static Msg CHANGE_TITLE(String action, String artifactName) {
        return CHANGE_TITLE.args(action, artifactName);
    }

    public static Msg CHANGE_SUBTITLE(String date, String author) {
        return CHANGE_SUBTITLE.args(date, author);
    }

    public static ErrorMsg NEGATIVE_MAX_ROW_PER_PAGE(String _arg0) {
        return NEGATIVE_MAX_ROW_PER_PAGE.args(_arg0);
    }

    public static ErrorMsg NEGATIVE_FROM_PAGE(String _arg0) {
        return NEGATIVE_FROM_PAGE.args(_arg0);
    }

    public static ErrorMsg TO_PAGE_LESS_THAN_ONE(String _arg0) {
        return TO_PAGE_LESS_THAN_ONE.args(_arg0);
    }

    public static ErrorMsg FROM_GREATER_THAN_TO(String _arg0, String _arg1) {
        return FROM_GREATER_THAN_TO.args(_arg0, _arg1);
    }

    public static ErrorMsg INVALID_FROM_TO_TIMESTAMPS(String _arg0, String _arg1) {
        return INVALID_FROM_TO_TIMESTAMPS.args(_arg0, _arg1);
    }

    public static ErrorMsg NEGATIVE_RECENTLY_CHANGED_QTY(String _arg0) {
        return NEGATIVE_RECENTLY_CHANGED_QTY.args(_arg0);
    }

    static {
        MetadataMsg.init(MetadataMsg.class, LogComponent.DEFAULT, ErrorRange.PROCESS_METADATA_SERVICE, 70800, 70979);
    }
}

