/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.metadata.history.model.ChangeAction;
import oracle.bpm.metadata.history.model.LogicalArtifactType;
import org.jetbrains.annotations.NotNull;

@Entity
@SqlResultSetMapping(name="ChangedItemWithDate", entities={@EntityResult(entityClass=ChangedItem.class)}, columns={@ColumnResult(name="CHANGEDATE")})
@Table(name="BPM_PML_HS_ITEM")
public class ChangedItem
implements Serializable {
    @Enumerated(value=EnumType.STRING)
    private ChangeAction action;
    @Enumerated(value=EnumType.STRING)
    private LogicalArtifactType artifact;
    @Transient
    private Date changeDate;
    @GeneratedValue(generator="pml_hs_item_gen")
    @Id
    @TableGenerator(name="pml_hs_item_gen", table="BPM_PML_SEQUENCE", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="HS_SEQ")
    private long id;
    private String logicalName;
    static final long serialVersionUID = 1875211792195269936L;

    public ChangedItem() {
    }

    public ChangedItem(@NotNull ChangeAction action, @NotNull String logicalName, @NotNull LogicalArtifactType artifact) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/model/ChangedItem.<init> must not be null");
        }
        if (logicalName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/model/ChangedItem.<init> must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/history/model/ChangedItem.<init> must not be null");
        }
        this.action = action;
        this.logicalName = logicalName;
        this.artifact = artifact;
    }

    @Enumerated
    public ChangeAction getChangeAction() {
        return this.action;
    }

    @Enumerated
    public String getLogicalName() {
        return this.logicalName;
    }

    public String getName() {
        return VFileUtils.getName((String)this.logicalName);
    }

    public String getFolder() {
        return VFileUtils.getFolder((String)this.logicalName);
    }

    public LogicalArtifactType getType() {
        return this.artifact;
    }

    public boolean equals(Object o) {
        ChangedItem changedItem;
        boolean equals = false;
        if (o instanceof ChangedItem && this.logicalName.equals((changedItem = (ChangedItem)o).getLogicalName()) && this.action.equals((Object)changedItem.getChangeAction()) && this.artifact.equals((Object)changedItem.getType())) {
            equals = true;
        }
        return equals;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
}

