/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history.exceptions;

import java.util.Date;
import oracle.bpm.metadata.history.exceptions.HistoryException;
import oracle.bpm.metadata.history.exceptions.IllegalPageContext;
import oracle.bpm.metadata.msg.MetadataMsg;
import org.jetbrains.annotations.NotNull;

public final class HistoryExceptionFactory {
    public static RuntimeException createNegativeMaxRowsPerPage(int maxRowsPerPage) {
        return new IllegalPageContext(MetadataMsg.NEGATIVE_MAX_ROW_PER_PAGE(Integer.toString(maxRowsPerPage)));
    }

    public static RuntimeException createNegativeFromPage(int fromPage) {
        return new IllegalPageContext(MetadataMsg.NEGATIVE_FROM_PAGE(Integer.toString(fromPage)));
    }

    public static RuntimeException createToPageLessThanOne(int toPage) {
        return new IllegalPageContext(MetadataMsg.TO_PAGE_LESS_THAN_ONE(Integer.toString(toPage)));
    }

    public static RuntimeException createFromGreaterThanTo(int fromPage, int toPage) {
        return new IllegalPageContext(MetadataMsg.FROM_GREATER_THAN_TO(Integer.toString(fromPage), Integer.toString(toPage)));
    }

    public static HistoryException createInvalidFromToTimestamp(@NotNull Date fromPage, @NotNull Date toPage) {
        if (fromPage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/history/exceptions/HistoryExceptionFactory.createInvalidFromToTimestamp must not be null");
        }
        if (toPage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/history/exceptions/HistoryExceptionFactory.createInvalidFromToTimestamp must not be null");
        }
        return new HistoryException(MetadataMsg.INVALID_FROM_TO_TIMESTAMPS(fromPage.toString(), toPage.toString()));
    }

    public static HistoryException createRecentlyChangedItemsNegativeQty(int qty) {
        return new HistoryException(MetadataMsg.NEGATIVE_RECENTLY_CHANGED_QTY(Integer.toString(qty)));
    }
}

