/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.history;

import java.io.Serializable;
import oracle.bpm.metadata.history.exceptions.HistoryExceptionFactory;
import org.jetbrains.annotations.NotNull;

public class PageContext
implements Serializable {
    private int fromPage;
    private int maxRowsPerPage;
    private int toPage;
    private static final long serialVersionUID = -1290343861701151613L;

    public PageContext(@NotNull int maxRowsPerPage, @NotNull int fromPage, @NotNull int toPage) {
        this.fromPage = fromPage;
        this.maxRowsPerPage = maxRowsPerPage;
        this.toPage = toPage;
        this.validateCriteria();
    }

    public int getFromPage() {
        return this.fromPage;
    }

    public int getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    public int getToPage() {
        return this.toPage;
    }

    private void validateCriteria() {
        if (this.maxRowsPerPage < 1) {
            throw HistoryExceptionFactory.createNegativeMaxRowsPerPage(this.maxRowsPerPage);
        }
        if (this.fromPage < 0) {
            throw HistoryExceptionFactory.createNegativeFromPage(this.fromPage);
        }
        if (this.toPage < 1) {
            throw HistoryExceptionFactory.createToPageLessThanOne(this.toPage);
        }
        if (this.fromPage > this.toPage) {
            throw HistoryExceptionFactory.createFromGreaterThanTo(this.fromPage, this.toPage);
        }
    }
}

