/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import oracle.bpm.bcgen.FieldD;
import oracle.bpm.bcgen.TD;
import oracle.bpm.component.Modifiable;
import oracle.bpm.component.Replaceable;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.ArgumentMapUtil;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Char;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Real;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.SQLObject;
import oracle.bpm.util.Conversion;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class TDKit {
    public static final String MODIFIABLE_INTERFACE = Modifiable.class.getName();
    public static final String REPLACEABLE_INTERFACE = Replaceable.class.getName();
    public static final FieldD DECIMAL_ZERO = FieldD.create(Decimal.class, "ZERO");
    public static final ObjectType INVOKEABLE = TD.getObjectType(Invokeable.class);
    public static final ObjectType INVOCATOR = TD.getObjectType(Invocator.class);
    public static final ObjectType SQL_OBJECT = TD.getObjectType(SQLObject.class);
    public static final ObjectType FUEGO_CHAR = TD.getObjectType(Char.class);
    public static final ObjectType FUEGO_BOOL = TD.getObjectType(Bool.class);
    public static final ObjectType FUEGO_DECIMAL = TD.getObjectType(Decimal.class);
    public static final ObjectType FUEGO_INT = TD.getObjectType(Int.class);
    public static final ObjectType FUEGO_REAL = TD.getObjectType(Real.class);
    public static final ObjectType INTERVAL = TD.getObjectType(Interval.class);
    public static final ObjectType TIME = TD.getObjectType(Time.class);
    public static final ObjectType STR = TD.getObjectType(Str.class);
    public static final ObjectType REGEXP = TD.getObjectType(RegExp.class);
    public static final ObjectType JAVACLASS = TD.getObjectType(JavaClass.class);
    public static final ObjectType ANY = TD.getObjectType(Any.class);
    public static final ObjectType CONVERSION = TD.getObjectType(Conversion.class);
    public static final ObjectType ARGUMENT_MAP_UTIL = TD.getObjectType(ArgumentMapUtil.class);
    public static final ObjectType ARGUMENT_MAP = TD.getObjectType(ArgumentMap.class);
    public static final ObjectType RUNTIME_CIL_EXCECUTION_EXCEPTION = TD.getObjectType(RuntimeCILExecutionException.class);
    public static final ObjectType DYNAMIC = TD.getObjectType(DynamicObject.class);

    public static Type getType(TypeDescription type, String externalType) {
        Type result;
        if (type.isArray() && type.isPrimitive()) {
            String t = externalType == null ? null : externalType.substring(0, externalType.length() - 2);
            result = TD.getArrayType(TDKit.getType(type.getElementType(), t));
        } else {
            result = TD.valueOf(TDKit.getJavaType(type, externalType));
        }
        return result;
    }

    public static ObjectType utility(TypeDescription typeDescription) {
        ObjectType result;
        if (typeDescription.isInt()) {
            result = FUEGO_INT;
        } else if (typeDescription.isReal()) {
            result = FUEGO_REAL;
        } else if (typeDescription.isDecimal()) {
            result = FUEGO_DECIMAL;
        } else if (typeDescription.isInterval()) {
            result = INTERVAL;
        } else if (typeDescription.isTime()) {
            result = TIME;
        } else if (typeDescription.isBool()) {
            result = FUEGO_BOOL;
        } else {
            throw new IllegalArgumentException("Not utility class for: " + typeDescription);
        }
        return result;
    }

    public static FieldD valueField(Type type) {
        assert (type instanceof ObjectType);
        String className = ((ObjectType)type).getClassName();
        try {
            return FieldD.create(Class.forName(className), "value");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getElementType(String type) {
        int index = type.lastIndexOf("[");
        type = index != -1 ? type.substring(0, index) : "java.lang.Object";
        return type;
    }

    public static String getJavaType(TypeDescription type, String externalType) {
        if (type.isArray()) {
            if (type.isPrimitive()) {
                String t = externalType == null ? null : externalType.substring(0, externalType.length() - 2);
                externalType = TDKit.getJavaType(type.getElementType(), t) + "[]";
            } else {
                externalType = type.javaType();
            }
        } else if (externalType == null) {
            externalType = type.javaType();
        } else if (type.isPrimitive() && !TDKit.isPrimitive(externalType)) {
            externalType = TDKit.toPrimitiveType(externalType);
        } else if (!type.isPrimitive() && TDKit.isPrimitive(externalType)) {
            externalType = TDKit.toNonPrimitiveType(externalType);
        }
        return externalType;
    }

    public static boolean isArray(String type) {
        int index = type.lastIndexOf("[");
        return index != -1 && !type.substring(0, index).trim().equals("byte");
    }

    public static String toNonPrimitiveType(String type) {
        if (type.equals("byte")) {
            type = "java.lang.Byte";
        } else if (type.equals("short")) {
            type = "java.lang.Short";
        } else if (type.equals("int")) {
            type = "java.lang.Integer";
        } else if (type.equals("float")) {
            type = "java.lang.Float";
        } else if (type.equals("char")) {
            type = "java.lang.Character";
        } else if (type.equals("long")) {
            type = "java.lang.Long";
        } else if (type.equals("double")) {
            type = "java.lang.Double";
        } else if (type.equals("boolean")) {
            type = "java.lang.Boolean";
        }
        return type;
    }

    public static String toPrimitiveType(String type) {
        if (type.equals("java.lang.Byte")) {
            type = "byte";
        } else if (type.equals("java.lang.Short")) {
            type = "short";
        } else if (type.equals("java.lang.Integer")) {
            type = "int";
        } else if (type.equals("java.lang.Float")) {
            type = "float";
        } else if (type.equals("java.lang.Character")) {
            type = "char";
        } else if (type.equals("java.lang.Long")) {
            type = "long";
        } else if (type.equals("java.lang.Double")) {
            type = "double";
        } else if (type.equals("java.lang.Boolean")) {
            type = "boolean";
        }
        return type;
    }

    public static boolean isPrimitive(String type) {
        return TDKit.isArray(type) ? TDKit.isPrimitive(TDKit.getElementType(type)) : JavaClass.isPrimitiveType(type);
    }

    public static boolean isValidXMLObjectInterface(String className) {
        String fuegoObjectClassName = "oracle.bpm.xobject.runtime.components.FuegoObject";
        String presentableInterfaceName = "oracle.bpm.xobject.runtime.components.Presentable";
        return className.equals(MODIFIABLE_INTERFACE) || className.equals(REPLACEABLE_INTERFACE) || className.equals(fuegoObjectClassName) || className.equals(presentableInterfaceName);
    }
}

