/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.collections.maps.WeakValueHashMap;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Trace;
import oracle.bpm.sql.BlobImpl;
import oracle.bpm.sql.QueryObject;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.ResourceUtils;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassLoaderRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TD {
    private static final BcelRepository bcelRepository = new BcelRepository();
    private static final int[] EMPTY_INTS;
    private static final Method[] EMPTY_METHODS;
    private static final Field[] EMPTY_FIELDS;
    private static final Attribute[] EMPTY_ATTRIBUTES;
    public static final ObjectType ARRAY_LIST;
    public static final ObjectType STRING_BUFFER;
    public static final ObjectType STRING_BUILDER;
    public static final Type VOID;
    public static final Type BOOLEAN;
    public static final Type CHAR;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type INT;
    public static final Type LONG;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    private static final Map<String, Type> nameMap;
    public static final ObjectType CHARACTER_CLASS;
    public static final ObjectType BOOLEAN_CLASS;
    public static final ObjectType DOUBLE_CLASS;
    public static final ObjectType FLOAT_CLASS;
    public static final ObjectType BYTE_CLASS;
    public static final ObjectType SHORT_CLASS;
    public static final ObjectType INTEGER_CLASS;
    public static final ObjectType LONG_CLASS;
    public static final ObjectType OBJECT;
    public static final ObjectType STRING;
    public static final ObjectType BIG_DECIMAL;
    public static final ObjectType BLOB_IMPL;
    public static final ObjectType BLOB;
    public static final ObjectType THROWABLE;
    public static final ObjectType MAP;
    public static final ObjectType SET;
    public static final ObjectType LIST;
    public static final ObjectType COLLECTION;
    public static final ObjectType ITERATOR;
    public static final ObjectType ARRAY_UTILS;
    public static final ObjectType LMAP;
    public static final ObjectType TREE_MAP;
    public static final ObjectType NUMBER;
    public static final ObjectType PRINT_STREAM;
    public static final ObjectType SYSTEM;
    public static final ObjectType RUNTIME_EXCEPTION;
    public static final ObjectType CLASS;
    public static final ObjectType QUERY_OBJECT;
    public static final ObjectType INVOKEABLE;
    public static final ObjectType OBJECT_INPUT_STREAM;
    public static final ObjectType OBJECT_OUTPUT_STREAM;
    public static final ObjectType IO_EXCEPTION;
    public static final ObjectType DYNAMIC;
    public static final ArrayType OBJECT_ARRAY;
    public static final ArrayType STRING_ARRAY;
    public static final ArrayType BYTE_ARRAY;
    public static final ArrayType INT_ARRAY;
    public static final ObjectType TRACE;

    public static ArrayType getArrayType(Type type) {
        return new ArrayType(type, 1);
    }

    public static boolean isAssignableFrom(Type to, Type from) {
        boolean result = false;
        if (to == from || TD.equals(to, from)) {
            result = true;
        } else if (to instanceof BasicType && from instanceof BasicType) {
            result = TD.isNumeric(to) && TD.isNumeric(from);
        } else if (to instanceof ReferenceType && from instanceof ReferenceType) {
            JavaClass javaClass;
            result = TD.equals(to, (Type)OBJECT) || TD.equals(from, (Type)Type.NULL) ? true : (javaClass = TD.getValidJavaClass(from.toString())) == null || ((ReferenceType)from).isAssignmentCompatibleWith(to);
        }
        return result;
    }

    public static boolean isIntWord(Type type) {
        return type.equals(INT) || type.equals(BYTE) || type.equals(SHORT);
    }

    public static ObjectType getObjectType(Class clazz) {
        if (clazz.isPrimitive() && clazz.isArray()) {
            throw new IllegalArgumentException(clazz.getName());
        }
        bcelRepository.registerType(clazz);
        return TD.getObjectType(clazz.getName());
    }

    @Nullable
    public static JavaClass getValidJavaClass(String className) {
        JavaClass result = Repository.lookupClass((String)className);
        return result != null && result.getMajor() >= 0 ? result : null;
    }

    public static ObjectType getObjectType(String name) {
        return new ObjectType(name);
    }

    public static void clearRepository() {
        Repository.clearCache();
    }

    public static ObjectType getObjectType(TypeDescription typeDescription) {
        bcelRepository.registerType(typeDescription);
        return new ObjectType(typeDescription.javaType());
    }

    public static boolean isVoid(Type type) {
        return type.getType() == 12;
    }

    public static Type valueOf(TypeDescription typeDescription) {
        if (typeDescription.isBinary()) {
            return BYTE_ARRAY;
        }
        if (typeDescription.isPredefined()) {
            return TD.valueOf(typeDescription.getJavaType());
        }
        if (typeDescription.isPrimitive() && typeDescription.getKind() == 12) {
            return new ArrayType(TD.valueOf(typeDescription.getElementType()), 1);
        }
        return TD.valueOf(typeDescription.javaType());
    }

    public static Type valueOf(String typeAsString) {
        if (typeAsString.endsWith("[]")) {
            return TD.getArrayType(TD.valueOf(typeAsString.substring(0, typeAsString.length() - 2)));
        }
        Type result = nameMap.get(typeAsString);
        if (result == null) {
            result = typeAsString.charAt(0) == '[' ? Type.getType((String)typeAsString) : TD.getObjectType(typeAsString);
        }
        return result;
    }

    static ObjectType getDummyObjectType(String name) {
        TD.bcelRepository.registerType(name, false);
        return TD.getObjectType(name);
    }

    static boolean isNumeric(Type t) {
        return t == Type.BYTE || t == Type.SHORT || t == Type.INT || t == Type.LONG || t == Type.CHAR || t == Type.FLOAT || t == Type.DOUBLE;
    }

    private static boolean equals(Type to, Type from) {
        return to == from || to != null && from != null && to.toString().equals(from.toString());
    }

    static {
        Repository.setRepository((org.apache.bcel.util.Repository)bcelRepository);
        EMPTY_INTS = new int[0];
        EMPTY_METHODS = new Method[0];
        EMPTY_FIELDS = new Field[0];
        EMPTY_ATTRIBUTES = new Attribute[0];
        ARRAY_LIST = TD.getObjectType(ArrayList.class);
        STRING_BUFFER = Type.STRINGBUFFER;
        STRING_BUILDER = TD.getObjectType(StringBuilder.class);
        VOID = Type.VOID;
        BOOLEAN = Type.BOOLEAN;
        CHAR = Type.CHAR;
        BYTE = Type.BYTE;
        SHORT = Type.SHORT;
        INT = Type.INT;
        LONG = Type.LONG;
        FLOAT = Type.FLOAT;
        DOUBLE = Type.DOUBLE;
        nameMap = new HashMap<String, Type>();
        nameMap.put(Void.TYPE.getName(), VOID);
        nameMap.put(Boolean.TYPE.getName(), BOOLEAN);
        nameMap.put(Character.TYPE.getName(), CHAR);
        nameMap.put(Byte.TYPE.getName(), BYTE);
        nameMap.put(Short.TYPE.getName(), SHORT);
        nameMap.put(Integer.TYPE.getName(), INT);
        nameMap.put(Long.TYPE.getName(), LONG);
        nameMap.put(Float.TYPE.getName(), FLOAT);
        nameMap.put(Double.TYPE.getName(), DOUBLE);
        CHARACTER_CLASS = TD.getObjectType(Character.class);
        BOOLEAN_CLASS = TD.getObjectType(Boolean.class);
        DOUBLE_CLASS = TD.getObjectType(Double.class);
        FLOAT_CLASS = TD.getObjectType(Float.class);
        BYTE_CLASS = TD.getObjectType(Byte.class);
        SHORT_CLASS = TD.getObjectType(Short.class);
        INTEGER_CLASS = TD.getObjectType(Integer.class);
        LONG_CLASS = TD.getObjectType(Long.class);
        OBJECT = Type.OBJECT;
        STRING = Type.STRING;
        BIG_DECIMAL = TD.getObjectType(BigDecimal.class);
        BLOB_IMPL = TD.getObjectType(BlobImpl.class);
        BLOB = TD.getObjectType(Blob.class);
        THROWABLE = TD.getObjectType(Throwable.class);
        MAP = TD.getObjectType(Map.class);
        SET = TD.getObjectType(Set.class);
        LIST = TD.getObjectType(List.class);
        COLLECTION = TD.getObjectType(Collection.class);
        ITERATOR = TD.getObjectType(Iterator.class);
        ARRAY_UTILS = TD.getObjectType(ArrayUtils.class);
        LMAP = TD.getObjectType(LinkedHashMap.class);
        TREE_MAP = TD.getObjectType(TreeMap.class);
        NUMBER = TD.getObjectType(Number.class);
        PRINT_STREAM = TD.getObjectType(PrintStream.class);
        SYSTEM = TD.getObjectType(System.class);
        RUNTIME_EXCEPTION = TD.getObjectType(RuntimeException.class);
        CLASS = TD.getObjectType(Class.class);
        QUERY_OBJECT = TD.getObjectType(QueryObject.class);
        INVOKEABLE = TD.getObjectType(Invokeable.class);
        OBJECT_INPUT_STREAM = TD.getObjectType(ObjectInputStream.class);
        OBJECT_OUTPUT_STREAM = TD.getObjectType(ObjectOutputStream.class);
        IO_EXCEPTION = TD.getObjectType(IOException.class);
        DYNAMIC = TD.getObjectType(DynamicObject.class);
        OBJECT_ARRAY = new ArrayType((Type)OBJECT, 1);
        STRING_ARRAY = new ArrayType((Type)STRING, 1);
        BYTE_ARRAY = new ArrayType(BYTE, 1);
        INT_ARRAY = new ArrayType(INT, 1);
        TRACE = TD.getObjectType(Trace.class);
    }

    private static class BcelRepository
    extends ClassLoaderRepository {
        private Map<String, Object> otherTypes = new WeakValueHashMap<String, Object>();
        private static final long serialVersionUID = -693233760683953748L;

        BcelRepository() {
            super(BcelRepository.class.getClassLoader());
        }

        public void storeClass(JavaClass clazz) {
            super.storeClass(clazz);
            this.otherTypes.remove(clazz.getClassName());
        }

        public void removeClass(JavaClass clazz) {
            super.removeClass(clazz);
            this.otherTypes.remove(clazz.getClassName());
        }

        @Nullable
        public JavaClass findClass(String className) {
            JavaClass result = super.findClass(className);
            if (result != null) {
                this.otherTypes.remove(className);
            }
            return result;
        }

        @NotNull
        public JavaClass loadClass(String className) throws ClassNotFoundException {
            JavaClass result;
            ClassNotFoundException error = null;
            try {
                result = super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                result = null;
                error = e;
            }
            if (result != null) {
                this.otherTypes.remove(className);
            } else {
                result = this.checkOtherTypes(className);
                if (result == null) {
                    if (error == null) {
                        error = new ClassNotFoundException(className);
                    }
                    throw error;
                }
            }
            return result;
        }

        @NotNull
        public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
            JavaClass result;
            ClassNotFoundException error = null;
            try {
                result = super.loadClass(clazz);
            }
            catch (ClassNotFoundException e) {
                result = null;
                error = e;
            }
            String className = clazz.getName();
            if (result == null) {
                this.otherTypes.remove(className);
            } else {
                result = this.addToRepository(clazz);
            }
            if (result == null) {
                if (error == null) {
                    error = new ClassNotFoundException(className);
                }
                throw error;
            }
            return result;
        }

        public void clear() {
            super.clear();
            this.otherTypes.clear();
        }

        void registerType(TypeDescription type) {
            this.registerType(type.getJavaType(), type);
        }

        void registerType(Class clazz) {
            this.registerType(clazz.getName(), clazz);
        }

        private void registerType(String className, Object o) {
            if (super.findClass(className) != null) {
                return;
            }
            this.otherTypes.put(className, o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private JavaClass addToRepository(Class clazz) {
            Class<?>[] interfaces;
            JavaClass javaClass;
            InputStream inputStream;
            if (clazz.isArray()) {
                return null;
            }
            URL classURL = ResourceUtils.getClassURL(clazz);
            assert (classURL != null) : "cannot resolve url for " + clazz;
            try {
                inputStream = classURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
            try {
                ClassParser classParser = new ClassParser(inputStream, clazz.getName());
                try {
                    javaClass = classParser.parse();
                }
                catch (IOException e) {
                    JavaClass javaClass2 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return javaClass2;
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
            Class superclazz = clazz.getSuperclass();
            if (superclazz != null) {
                this.registerType(superclazz);
            }
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                this.registerType(anInterface);
            }
            this.storeClass(javaClass);
            return javaClass;
        }

        @Nullable
        private JavaClass addToRepository(String className, Boolean isInterface) {
            int accessFlags = 1;
            if (isInterface.booleanValue()) {
                accessFlags |= 0x200;
            }
            ConstantPool cp = new ConstantPool(new Constant[]{new ConstantClass(1), new ConstantUtf8(className)});
            JavaClass javaClass = new JavaClass(0, -1, null, -1, -1, accessFlags, cp, EMPTY_INTS, EMPTY_FIELDS, EMPTY_METHODS, EMPTY_ATTRIBUTES, 0);
            this.storeClass(javaClass);
            return javaClass;
        }

        @Nullable
        private JavaClass addToRepository(TypeDescription typeDescription) {
            Class<?> clazz;
            try {
                clazz = typeDescription.getJavaClass();
            }
            catch (RuntimeException e) {
                clazz = null;
            }
            if (clazz != null) {
                return this.addToRepository(clazz);
            }
            return this.addToRepository(typeDescription.getJavaType(), typeDescription.isInterface());
        }

        @Nullable
        private JavaClass checkOtherTypes(String className) {
            Object o = this.otherTypes.remove(className);
            if (o instanceof TypeDescription) {
                return this.addToRepository((TypeDescription)o);
            }
            if (o instanceof Class) {
                return this.addToRepository((Class)o);
            }
            if (o instanceof Boolean) {
                return this.addToRepository(className, (Boolean)o);
            }
            assert (o == null) : "Unexpected object class : \"" + o.getClass() + "\" for name :" + className;
            return null;
        }
    }
}

