/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.bcgen.BranchTarget;
import oracle.bpm.bcgen.ClassCode;
import oracle.bpm.bcgen.CodeBlock;
import oracle.bpm.bcgen.FieldD;
import oracle.bpm.bcgen.IfBlock;
import oracle.bpm.bcgen.IfBlockStack;
import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.JVMStack;
import oracle.bpm.bcgen.LocalVariable;
import oracle.bpm.bcgen.LogicalOperation;
import oracle.bpm.bcgen.LogicalStack;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.MethodD;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.bcgen.OpCode;
import oracle.bpm.bcgen.TD;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.bcgen.TargetInstruction;
import oracle.bpm.bcgen.TryBlock;
import oracle.bpm.bcgen.TryBlockStack;
import oracle.bpm.bcgen.WhileBlock;
import oracle.bpm.bcgen.WhileBlockStack;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ArithmeticInstruction;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class JVMCodeBuilderImpl
implements JVMCodeBuilder {
    private ClassCode classCode;
    private InstructionHandle currentLocation;
    private InstructionFactory ifac;
    private IfBlockStack ifBlockStack;
    private InstructionList il;
    private int lineNumber;
    private LogicalStack logicalStack;
    private MethodGen methodGen;
    private JVMStack stack;
    private List<TargetInstruction> targetsToFix;
    private TryBlockStack tryBlockStack = new TryBlockStack();
    private WhileBlockStack whileBlockStack;
    private static final Type[] NO_ARGS = new Type[0];
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final FieldD SYSTEM_OUT_FIELD = FieldD.createStatic(TD.SYSTEM, "out", (Type)TD.PRINT_STREAM);
    private static final ObjectType CLASS_TYPE = new ObjectType(Class.class.getName());

    JVMCodeBuilderImpl(ClassCode classCode, ModSet modifiers, Type returnType, String methodName, Type[] argTypes, String[] argNames) {
        this.ifBlockStack = new IfBlockStack();
        this.whileBlockStack = new WhileBlockStack();
        this.logicalStack = new LogicalStack();
        this.stack = new JVMStack();
        this.il = new InstructionList();
        this.classCode = classCode;
        this.ifac = classCode.getInstructionFactory();
        this.methodGen = new MethodGen(modifiers.getValue(), returnType, argTypes, argNames, methodName, classCode.getClassName(), this.il, classCode.getConstantPool());
        classCode.checkUnique(methodName + this.methodGen.getSignature());
        this.targetsToFix = new ArrayList<TargetInstruction>();
    }

    @Override
    public LocalVariable addCatch(ObjectType throwable, String throwableVarName) {
        this.stack.verifyIsEmpty();
        return this.tryBlockStack.top().addCatch(throwable, throwableVarName);
    }

    @Override
    public void addElse() {
        this.ifBlockStack.top().addElse();
    }

    @Override
    public void addFinally() {
        TryBlock tryBlock = this.tryBlockStack.top();
        tryBlock.addFinally();
        this.stack.verifyIsEmpty();
    }

    @Override
    public void addThen() {
        this.ifBlockStack.top().addThen();
    }

    @Override
    public void addWhileBody() {
        this.whileBlockStack.top().addBody();
    }

    @Override
    public void addWhileBody(OpCode opCode) {
        this.whileBlockStack.top().addBody(this.branch(this.cmp(opCode.negate())));
    }

    @Override
    public void arrayLoad() {
        JVMCodeBuilderImpl.verifyIsInt(this.stack.pop());
        Type reference = this.stack.pop();
        JVMCodeBuilderImpl.verifyIsArray(reference);
        Type elementType = ((ArrayType)reference).getElementType();
        this.append((Instruction)InstructionFactory.createArrayLoad((Type)elementType));
        this.stack.push(elementType);
    }

    @Override
    public void arrayStore() {
        Type value = this.stack.pop();
        JVMCodeBuilderImpl.verifyIsInt(this.stack.pop());
        Type reference = this.stack.pop();
        JVMCodeBuilderImpl.verifyIsArray(reference);
        Type elementType = ((ArrayType)reference).getElementType();
        this.verifyIsAssignableFrom(elementType, value);
        this.append((Instruction)InstructionFactory.createArrayStore((Type)elementType));
    }

    @Override
    public void beginIf() {
        this.ifBlockStack.push(new IfBlock(this));
    }

    @Override
    public void beginLabeledBlock(String text) {
        WhileBlock whileBlock = WhileBlock.labeledBlock(this, text);
        this.whileBlockStack.push(whileBlock);
    }

    @Override
    public void beginLogical(String operator) {
        LogicalOperation logicalOperation = new LogicalOperation(this, operator);
        this.logicalStack.push(logicalOperation);
    }

    @Override
    public void beginTry() {
        this.stack.verifyIsEmpty();
        this.beginTry(false);
    }

    @Override
    public void beginTry(boolean hasFinally) {
        this.tryBlockStack.push(new TryBlock(this, hasFinally));
    }

    @Override
    public void beginWhile() {
        this.stack.verifyIsEmpty();
        this.whileBlockStack.push(new WhileBlock(this));
    }

    @Override
    public void beginWhile(String name) {
        this.stack.verifyIsEmpty();
        this.whileBlockStack.push(new WhileBlock(this, name));
    }

    @Override
    public void bitNot() {
        Type top = this.stack.top();
        if (top.equals(TD.LONG)) {
            this.loadConstant(-1L);
        } else {
            this.loadConstant(-1);
        }
        this.math("^");
    }

    @Override
    public void compare(OpCode opCode) {
        this.pushIf(this.cmp(opCode));
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void compareNull(boolean notNull) {
        JVMCodeBuilderImpl.verifyIsReference(this.stack.pop());
        this.pushIf(notNull ? OpCode.IFNONNULL : OpCode.IFNULL);
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void compareZero(OpCode opCode) {
        JVMCodeBuilderImpl.verifyIsInt(this.stack.pop());
        this.pushIf(opCode);
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void construct(ObjectType type) {
        this.newObject((Type)type);
        this.dup();
        this.invokeConstructor(type);
    }

    @Override
    public void construct(ObjectType type, Type argType) {
        int local = this.methodGen.getMaxLocals();
        this.verifyIsAssignableFrom(argType, this.stack.pop());
        this.append((Instruction)InstructionFactory.createStore((Type)argType, (int)local));
        this.newObject((Type)type);
        this.dup();
        this.append((Instruction)InstructionFactory.createLoad((Type)argType, (int)local));
        this.stack.push(argType);
        this.invokeConstructor(type, argType);
    }

    @Override
    public void convert(Type to) {
        Type from = this.stack.top();
        Type newTo = to;
        Type newFrom = from;
        if (TD.isIntWord(from)) {
            newFrom = TD.INT;
        } else if (TD.isIntWord(to)) {
            newTo = TD.INT;
        }
        if (!newFrom.equals(newTo)) {
            this.stack.pop();
            try {
                this.append(this.ifac.createCast(newFrom, newTo));
            }
            catch (RuntimeException e) {
                throw JVMCodeBuilderImpl.exception("Can't not cast from : '" + newFrom + "' -> '" + newTo + '\'');
            }
            this.stack.push(to);
        } else if (!from.equals(to)) {
            this.stack.pop();
            this.stack.push(to);
        }
    }

    @Override
    public void createArray(ArrayType arrayType, Object[] values) {
        this.createArray(arrayType, values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            this.storeArrayValue(i, value);
        }
    }

    @Override
    public void createArray(ArrayType arrayType, int length) {
        this.loadConstant(length);
        this.createArray(arrayType);
    }

    @Override
    public LocalVariable createLocalVariable(String name, Type type) {
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(dot + 1);
        }
        return new LocalVariable(this.methodGen.addLocalVariable(name, type, null, null));
    }

    @Override
    public void createMap(Map<?, ?> values) {
        ArrayType arrayType = TD.OBJECT_ARRAY;
        Object[] array = new Object[values.size() * 2];
        int i = 0;
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            array[i++] = entry.getKey();
            array[i++] = entry.getValue();
        }
        this.createArray(arrayType, array);
        this.invoke(MethodD.createStatic((Type)TD.LMAP, TD.ARRAY_UTILS, "asMap", new Type[]{arrayType}));
    }

    @Override
    public void dup(int xn) {
        switch (xn) {
            case 0: {
                this.dup();
                break;
            }
            case 1: {
                this.dup_x1();
                break;
            }
            case 2: {
                this.dup_x2();
            }
        }
    }

    @Override
    public void dup() {
        Type top = this.stack.top();
        this.append((Instruction)InstructionFactory.createDup((int)top.getSize()));
        this.stack.push(top);
    }

    @Override
    public void dup_x1() {
        Type top = this.stack.pop();
        Type utop = this.stack.pop();
        this.append((Instruction)InstructionFactory.createDup_1((int)top.getSize()));
        this.stack.push(top);
        this.stack.push(utop);
        this.stack.push(top);
    }

    @Override
    public void dup_x2() {
        Type top = this.stack.pop();
        Type utop = this.stack.pop();
        Type uutop = this.stack.pop();
        this.append((Instruction)InstructionFactory.createDup_2((int)top.getSize()));
        this.stack.push(top);
        this.stack.push(uutop);
        this.stack.push(utop);
        this.stack.push(top);
    }

    @Override
    public void endCode() {
        this.stack.verifyIsEmpty();
        assert (this.whileBlockStack.isEmpty()) : "WhileBlockStack must be empty";
        assert (this.ifBlockStack.isEmpty()) : "'IfBlockStack must be empty";
        assert (this.tryBlockStack.isEmpty()) : "'IfBlockStack must be empty";
        if (this.il.getStart() == null) {
            throw JVMCodeBuilderImpl.exception("Empty method: " + this.methodGen.getName());
        }
        if (!this.targetsToFix.isEmpty()) {
            this.nop();
        }
        this.methodGen.setMaxStack();
        this.methodGen.setMaxLocals();
        this.classCode.getClassGen().addMethod(this.methodGen.getMethod());
        this.il.dispose();
        this.il = null;
        this.methodGen = null;
    }

    @Override
    public void endExprIf() {
        this.ifBlockStack.pop().end();
    }

    @Override
    public void endIf() {
        this.ifBlockStack.pop().end();
    }

    @Override
    public void endLabeledBlock() {
        this.whileBlockStack.pop().endLabeledBlock();
    }

    @Override
    public void endLogical() {
        JVMCodeBuilderImpl.verifyIsBoolean(this.stack.pop());
        this.logicalStack.pop().end();
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void endTry() {
        this.tryBlockStack.pop().end();
        this.stack.verifyIsEmpty();
    }

    @Override
    public void endWhile() {
        this.whileBlockStack.pop().end();
        this.stack.verifyIsEmpty();
    }

    @Override
    public void exitWhile() {
        this.whileBlockStack.top().exit();
    }

    @Override
    public void exitWhile(String text) {
        this.whileBlockStack.find(text).exit();
    }

    @Override
    public void fixTarget(BranchHandle handle) {
        handle.setTarget(this.currentLocation);
    }

    @Override
    public void fixTargetWithNext(TargetInstruction target) {
        this.targetsToFix.add(target);
    }

    @Override
    public JVMStack getStack() {
        return this.stack;
    }

    @Override
    public ObjectType getType() {
        return this.classCode.getType();
    }

    @Override
    public void inc(LocalVariable variable, int n) {
        JVMCodeBuilderImpl.verifyIsInt(variable.getType());
        this.append((Instruction)new IINC(variable.getIndex(), n));
        variable.setEnd(this.currentLocation);
    }

    @Override
    public void instanceOf(ObjectType objectType) {
        JVMCodeBuilderImpl.verifyIsReference(this.stack.pop());
        INSTANCEOF instruction = this.ifac.createInstanceOf((ReferenceType)objectType);
        this.append((Instruction)instruction);
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void invoke(MethodD md) {
        short kind;
        Type returnType = md.getReturnType();
        Type[] argTypes = md.getArgTypes();
        ObjectType targetType = md.getTargetType();
        this.verifyArguments(argTypes);
        if (md.isStatic()) {
            kind = 184;
        } else {
            Type reference = this.stack.pop();
            JVMCodeBuilderImpl.verifyInstanceOf(reference, targetType);
            kind = md.referencesInterface() ? (short)185 : 182;
        }
        this.append((Instruction)this.ifac.createInvoke(targetType.getClassName(), md.getName(), returnType, argTypes, kind));
        if (!returnType.equals(Type.VOID)) {
            this.stack.push(returnType);
        }
    }

    @Override
    public void invokeConstructor(ObjectType type) {
        this.invokeConstructor(type, NO_ARGS);
    }

    @Override
    public void invokeConstructor(ObjectType type, Type paramType) {
        this.invokeConstructor(type, new Type[]{paramType});
    }

    @Override
    public void invokeConstructor(ObjectType type, Type[] argTypes) {
        this.verifyArguments(argTypes);
        Type target = this.stack.pop();
        if (!type.equals((Object)target)) {
            throw JVMCodeBuilderImpl.exception("Invoking constructor of " + type + " over " + target);
        }
        this.append((Instruction)this.ifac.createInvoke(type.getClassName(), CONSTRUCTOR_METHOD_NAME, (Type)Type.VOID, argTypes, (short)183));
    }

    @Override
    public void invokeSuperConstructor(Type[] args) {
        this.verifyArguments(args);
        Type target = this.stack.pop();
        ObjectType thisType = this.classCode.getType();
        if (!thisType.equals((Object)target)) {
            throw JVMCodeBuilderImpl.exception("Invoking constructor of " + thisType + " over " + target);
        }
        this.append((Instruction)this.ifac.createInvoke(this.classCode.getSuperClassName(), CONSTRUCTOR_METHOD_NAME, (Type)Type.VOID, args, (short)183));
    }

    @Override
    public void loadArgument(int argument) {
        int index;
        Type[] types = this.methodGen.getArgumentTypes();
        if (argument < 0 || argument >= types.length) {
            throw new ArrayIndexOutOfBoundsException("Argument Number: " + argument);
        }
        Type type = types[argument];
        int n = index = this.methodGen.isStatic() ? 0 : 1;
        for (int i = 0; i < argument; ++i) {
            index += types[i].getSize();
        }
        this.append((Instruction)InstructionFactory.createLoad((Type)type, (int)index));
        this.stack.push(type);
    }

    @Override
    public void loadClassConstant(String className) {
        if (className == null) {
            this.loadNull();
        } else {
            this.append((Instruction)new LDC(this.ifac.getConstantPool().addClass(className)));
            this.stack.push((Type)CLASS_TYPE);
        }
    }

    @Override
    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
        } else {
            this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
            this.stack.push((Type)Type.STRING);
        }
    }

    @Override
    public void loadConstant(int value) {
        this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
        this.stack.push(TD.INT);
    }

    @Override
    public void loadConstant(boolean value) {
        this.pushBoolean(value);
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public void loadConstant(long value) {
        this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
        this.stack.push(TD.LONG);
    }

    @Override
    public void loadConstant(float value) {
        this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
        this.stack.push(TD.FLOAT);
    }

    @Override
    public void loadConstant(double value) {
        this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
        this.stack.push(TD.DOUBLE);
    }

    @Override
    public void loadField(FieldD field) {
        String className = field.getClassName();
        String fieldName = field.getName();
        Type fieldType = field.getType();
        if (field.isStatic()) {
            this.append((Instruction)this.ifac.createGetStatic(className, fieldName, fieldType));
        } else {
            JVMCodeBuilderImpl.verifyClass(this.stack.pop(), className);
            this.append((Instruction)this.ifac.createGetField(className, fieldName, fieldType));
        }
        this.stack.push(fieldType);
    }

    @Override
    public void loadLocal(LocalVariable variable) {
        Type type = variable.getType();
        this.append((Instruction)InstructionFactory.createLoad((Type)type, (int)variable.getIndex()));
        variable.setEnd(this.currentLocation);
        this.stack.push(type);
    }

    @Override
    public void loadNull() {
        this.append(InstructionFactory.createNull((Type)TD.OBJECT));
        this.stack.push((Type)Type.NULL);
    }

    @Override
    public void loadThis() {
        if (this.methodGen.isStatic()) {
            throw JVMCodeBuilderImpl.exception("Cannot reference this in an static method");
        }
        this.append(InstructionFactory.createThis());
        this.stack.push((Type)this.classCode.getType());
    }

    @Override
    public void loadSuper(Type superType) {
        if (this.methodGen.isStatic()) {
            throw JVMCodeBuilderImpl.exception("Cannot reference this in an static method");
        }
        if (superType == null) {
            throw JVMCodeBuilderImpl.exception("supertype cannot be null");
        }
        this.append(InstructionFactory.createThis());
        this.stack.push(superType);
    }

    @Override
    public void loadZero(Type td) {
        Instruction instruction = td.equals(TD.DOUBLE) ? InstructionConstants.DCONST_0 : (td.equals(TD.FLOAT) ? InstructionConstants.FCONST_0 : (td.equals(TD.LONG) ? InstructionConstants.LCONST_0 : InstructionConstants.ICONST_0));
        this.append(instruction);
        this.stack.push(td);
    }

    @Override
    public void logicalOperand() {
        JVMCodeBuilderImpl.verifyIsBoolean(this.stack.pop());
        this.logicalStack.top().nextOperand();
    }

    @Override
    public void math(String operator) {
        Type op1 = this.stack.pop();
        Type op2 = this.stack.pop();
        char oc = operator.charAt(0);
        if (!op1.equals(op2)) {
            throw JVMCodeBuilderImpl.exception("Incompatible types: " + op1 + ' ' + operator + ' ' + op2);
        }
        if (op2.equals(Type.LONG) && (oc == '<' || oc == '>')) {
            this.append((Instruction)InstructionConstants.L2I);
        } else if (op1.equals(Type.BOOLEAN)) {
            op1 = Type.INT;
        }
        ArithmeticInstruction instruction = oc != '%' ? InstructionFactory.createBinaryOperation((String)operator, (Type)op1) : (op1.equals(Type.FLOAT) ? InstructionConstants.FREM : (op1.equals(Type.DOUBLE) ? InstructionConstants.DREM : (op1.equals(Type.LONG) ? InstructionConstants.LREM : InstructionFactory.createBinaryOperation((String)operator, (Type)op1))));
        this.append((Instruction)instruction);
        this.stack.push(op1);
    }

    @Override
    public void negate() {
        ArithmeticInstruction instruction;
        Type operator = this.stack.pop();
        if (operator.equals(Type.DOUBLE)) {
            instruction = InstructionConstants.DNEG;
        } else if (operator.equals(Type.FLOAT)) {
            instruction = InstructionConstants.FNEG;
        } else if (operator.equals(Type.LONG)) {
            instruction = InstructionConstants.LNEG;
        } else {
            JVMCodeBuilderImpl.verifyIsInt(operator);
            instruction = InstructionConstants.INEG;
        }
        this.append((Instruction)instruction);
        this.stack.push(operator);
    }

    @Override
    public void newObject(Type type) {
        if (type instanceof ArrayType) {
            this.createArray((ArrayType)type);
        } else if (type instanceof ObjectType) {
            this.append((Instruction)this.ifac.createNew((ObjectType)type));
        } else {
            throw new IllegalArgumentException("Not an Object or array: " + type);
        }
        this.stack.push(type);
    }

    @Override
    public InstructionHandle nop() {
        this.append(InstructionConstants.NOP);
        return this.currentLocation;
    }

    @Override
    public void not() {
        JVMCodeBuilderImpl.verifyIsBoolean(this.stack.pop());
        BranchHandle pushFalse = this.branch(OpCode.IFNE);
        this.pushBoolean(true);
        BranchHandle end = this.branch(OpCode.GOTO);
        this.pushBoolean(false);
        this.fixTarget(pushFalse);
        this.fixTargetWithNext(end);
        this.stack.push(TD.BOOLEAN);
    }

    @Override
    public BranchHandle nullCheck() {
        Type top = this.stack.top();
        JVMCodeBuilderImpl.verifyIsObject(top);
        this.append((Instruction)InstructionFactory.createDup((int)top.getSize()));
        return this.append(InstructionFactory.createBranchInstruction((short)198, null));
    }

    @Override
    public void pop() {
        Type top = this.stack.pop();
        this.append((Instruction)InstructionFactory.createPop((int)top.getSize()));
    }

    @Override
    public void print(CodeBlock codeBlock) {
        this.loadField(SYSTEM_OUT_FIELD);
        codeBlock.generate(this);
        this.invoke(MDKit.PRINT_STREAM_STRING);
    }

    @Override
    public void print(String constant) {
        this.loadField(SYSTEM_OUT_FIELD);
        this.loadConstant(constant);
        this.invoke(MDKit.PRINT_STREAM_STRING);
    }

    @Override
    public void println(String constant) {
        this.append(this.ifac.createPrintln(constant));
    }

    @Override
    public void retrn() {
        Type retType = this.methodGen.getReturnType();
        if (this.tryBlockStack.hasFinally()) {
            if (TD.isVoid(retType)) {
                this.tryBlockStack.callFinally();
            } else {
                LocalVariable retrnValue = this.createLocalVariable("ret", retType);
                this.storeLocal(retrnValue);
                this.tryBlockStack.callFinally();
                this.loadLocal(retrnValue);
            }
        }
        if (!TD.isVoid(retType)) {
            this.verifyIsAssignableFrom(retType, this.stack.pop());
        }
        this.append((Instruction)InstructionFactory.createReturn((Type)retType));
        this.stack.verifyIsEmpty();
    }

    @Override
    public void setLineNumber(int line) {
        if (line > this.lineNumber) {
            this.lineNumber = line;
        }
    }

    @Override
    public Type stackTop() {
        return this.stack.top();
    }

    @Override
    public void storeArgument(int argument) {
        Type[] types = this.methodGen.getArgumentTypes();
        if (argument < 0 || argument >= types.length) {
            throw new ArrayIndexOutOfBoundsException("Argument Number: " + argument);
        }
        Type type = types[argument];
        this.verifyIsAssignableFrom(type, this.stack.pop());
        this.append((Instruction)InstructionFactory.createStore((Type)type, (int)(this.methodGen.isStatic() ? argument : argument + 1)));
    }

    @Override
    public void storeField(FieldD field) {
        String className = field.getClassName();
        Type fieldType = field.getType();
        String fieldName = field.getName();
        this.verifyIsAssignableFrom(fieldType, this.stack.pop());
        if (field.isStatic()) {
            this.append((Instruction)this.ifac.createPutStatic(className, fieldName, fieldType));
        } else {
            Type reference = this.stack.pop();
            JVMCodeBuilderImpl.verifyInstanceOf(reference, TD.getObjectType(className));
            this.append((Instruction)this.ifac.createPutField(className, fieldName, fieldType));
        }
    }

    @Override
    public void storeLocal(LocalVariable variable) {
        Type varType = variable.getType();
        this.verifyIsAssignableFrom(varType, this.stack.pop());
        this.append((Instruction)InstructionFactory.createStore((Type)varType, (int)variable.getIndex()));
        variable.setStart(this.currentLocation);
        variable.setEnd(this.currentLocation);
    }

    @Override
    public void swap() {
        Type top = this.stack.pop();
        Type newTop = this.stack.pop();
        this.append((Instruction)InstructionConstants.SWAP);
        this.stack.push(top);
        this.stack.push(newTop);
    }

    @Override
    public void throwObject() {
        JVMCodeBuilderImpl.verifyIsObject(this.stack.pop());
        this.append(InstructionConstants.ATHROW);
    }

    @Override
    public void addSourceCode(String code) {
        ConstantPoolGen cp = this.methodGen.getConstantPool();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(code);
            dos.close();
            byte[] data = baos.toByteArray();
            this.methodGen.addAttribute((Attribute)new Unknown(cp.addUtf8("fuego.source"), data.length, data, cp.getConstantPool()));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    void addMethod(ModSet modifiers, Type[] args, String[] argNames) {
        this.methodGen = new MethodGen(modifiers.getValue(), (Type)Type.VOID, args, argNames, CONSTRUCTOR_METHOD_NAME, this.classCode.getClassName(), this.il, this.classCode.getConstantPool());
        this.classCode.getClassGen().addMethod(this.methodGen.getMethod());
    }

    void append(Instruction instruction) {
        if (this.il == null) {
            throw JVMCodeBuilderImpl.exception("Instruction List closed");
        }
        this.setCurrentLocation(this.il.append(instruction));
    }

    BranchHandle append(BranchInstruction instruction) {
        if (this.il == null) {
            throw JVMCodeBuilderImpl.exception("Instruction List closed");
        }
        BranchHandle branchHandle = this.il.append(instruction);
        this.setCurrentLocation((InstructionHandle)branchHandle);
        return branchHandle;
    }

    BranchHandle branch(OpCode opcode) {
        return this.append(InstructionFactory.createBranchInstruction((short)opcode.getValue(), null));
    }

    void exceptionHandler(InstructionHandle start, InstructionHandle end, ObjectType throwable) {
        this.methodGen.addExceptionHandler(start, end, this.currentLocation, throwable);
    }

    void fixEnd(LocalVariable variable) {
        variable.setEnd(this.currentLocation);
    }

    void fixTarget(List<BranchHandle> branchList) {
        for (BranchHandle handle : branchList) {
            this.fixTarget(handle);
        }
    }

    void fixTargetWithNext(BranchHandle handle) {
        this.fixTargetWithNext(new BranchTarget(handle));
    }

    InstructionHandle getCurrentLocation() {
        return this.currentLocation;
    }

    BranchHandle goSub() {
        return this.append(InstructionFactory.createBranchInstruction((short)168, null));
    }

    BranchHandle goTo() {
        return this.append(InstructionFactory.createBranchInstruction((short)167, null));
    }

    void pushBoolean(boolean value) {
        this.append(new PUSH(this.ifac.getConstantPool(), value).getInstruction());
    }

    private static boolean subclass(ObjectType ot, String className) {
        ObjectType superclass = TD.getObjectType(className);
        return !ot.referencesInterface() && !superclass.referencesInterface() && JVMCodeBuilderImpl.subclass(TD.getValidJavaClass(ot.getClassName()), TD.getValidJavaClass(className));
    }

    private static boolean subclass(JavaClass ot, JavaClass superclass) {
        return ot == null || superclass == null || Repository.instanceOf((JavaClass)ot, (JavaClass)superclass);
    }

    private static RuntimeException exception(String msg) {
        return new IllegalStateException(msg);
    }

    private static void verifyClass(Type reference, String className) {
        JVMCodeBuilderImpl.verifyIsObject(reference);
        ObjectType ot = (ObjectType)reference;
        if (!ot.getClassName().equals(className) && !JVMCodeBuilderImpl.subclass(ot, className)) {
            throw JVMCodeBuilderImpl.exception("Bad class reference: " + ot.getClassName() + " vs " + className);
        }
    }

    private static void verifyInstanceOf(Type reference, ObjectType target) {
        JVMCodeBuilderImpl.verifyIsObject(reference);
        ObjectType ot = (ObjectType)reference;
        if (!(ot.equals((Object)target) || target.equals((Object)TD.OBJECT) || JVMCodeBuilderImpl.isCompatibleAssignment(ot, target))) {
            throw JVMCodeBuilderImpl.exception("Reference: " + ot.getClassName() + " is not an instance of " + target.getClassName());
        }
    }

    private static boolean isCompatibleAssignment(ObjectType ot, ObjectType target) {
        String otClassName;
        boolean result = ot.isAssignmentCompatibleWith((Type)target);
        if (!result && (otClassName = ot.getClassName()).startsWith("xobject") && TD.getValidJavaClass(otClassName) == null) {
            String targetClassName = target.getClassName();
            result = TDKit.isValidXMLObjectInterface(targetClassName);
        }
        return result;
    }

    private static void verifyIsArray(Type reference) {
        if (!(reference instanceof ArrayType)) {
            throw JVMCodeBuilderImpl.exception("Not an array Type: " + reference);
        }
    }

    private static void verifyIsBoolean(Type index) {
        if (index != TD.BOOLEAN) {
            throw JVMCodeBuilderImpl.exception("Not a boolean: " + index);
        }
    }

    private static void verifyIsDouble(Type t) {
        if (!t.equals(TD.DOUBLE)) {
            throw JVMCodeBuilderImpl.exception("Not a double: " + t);
        }
    }

    private static void verifyIsFloat(Type t) {
        if (!t.equals(TD.FLOAT)) {
            throw JVMCodeBuilderImpl.exception("Not a float: " + t);
        }
    }

    private static void verifyIsInt(Type index) {
        if (!TD.isIntWord(index)) {
            throw JVMCodeBuilderImpl.exception("Not an int: " + index);
        }
    }

    private static void verifyIsLong(Type t) {
        if (!t.equals(TD.LONG)) {
            throw JVMCodeBuilderImpl.exception("Not a long: " + t);
        }
    }

    private static void verifyIsObject(Type reference) {
        if (!(reference instanceof ObjectType)) {
            throw JVMCodeBuilderImpl.exception("Not an object reference: " + reference);
        }
    }

    private static void verifyIsPrimitive(Type type) {
        if (!(type instanceof BasicType)) {
            throw JVMCodeBuilderImpl.exception("Not a primitive type: " + type);
        }
    }

    private static void verifyIsReference(Type reference) {
        if (!(reference instanceof ReferenceType)) {
            throw JVMCodeBuilderImpl.exception("Not a reference: " + reference);
        }
    }

    private void append(InstructionList instructionList) {
        if (this.il == null) {
            throw JVMCodeBuilderImpl.exception("Instruction List closed");
        }
        this.setCurrentLocation(this.il.append(instructionList));
    }

    private OpCode cmp(OpCode opCode) {
        Type op1 = this.stack.pop();
        Type op2 = this.stack.pop();
        JVMCodeBuilderImpl.verifyIsPrimitive(op1);
        if (op1.equals(Type.DOUBLE)) {
            JVMCodeBuilderImpl.verifyIsDouble(op2);
            this.append(InstructionConstants.DCMPL);
        } else if (op1.equals(Type.FLOAT)) {
            JVMCodeBuilderImpl.verifyIsFloat(op2);
            this.append(InstructionConstants.FCMPL);
        } else if (op1.equals(Type.LONG)) {
            JVMCodeBuilderImpl.verifyIsLong(op2);
            this.append(InstructionConstants.LCMP);
        } else {
            if (op1.equals(Type.BOOLEAN)) {
                JVMCodeBuilderImpl.verifyIsBoolean(op2);
            } else {
                JVMCodeBuilderImpl.verifyIsInt(op1);
                JVMCodeBuilderImpl.verifyIsInt(op2);
            }
            opCode = opCode.IF_ICMP();
            assert (opCode != null);
        }
        return opCode;
    }

    private void createArray(ArrayType arrayType) {
        int dim = arrayType.getDimensions();
        for (int i = 0; i < dim; ++i) {
            JVMCodeBuilderImpl.verifyIsInt(this.stack.pop());
        }
        Instruction instruction = this.ifac.createNewArray(arrayType.getElementType(), (short)dim);
        this.append(instruction);
        this.stack.push((Type)arrayType);
    }

    private Instruction loadConstant(Object value) {
        ObjectType type;
        PUSH push;
        ConstantPoolGen cp = this.ifac.getConstantPool();
        if (value instanceof Number) {
            push = new PUSH(cp, (Number)value);
            type = TD.NUMBER;
        } else if (value instanceof String) {
            push = new PUSH(cp, (String)value);
            type = TD.STRING;
        } else if (value instanceof Boolean) {
            push = new PUSH(cp, (Boolean)value);
            type = TD.BOOLEAN;
        } else if (value instanceof Character) {
            push = new PUSH(cp, (Character)value);
            type = TD.CHAR;
        } else {
            throw new ClassGenException("Illegal type: " + value.getClass());
        }
        this.stack.push((Type)type);
        return push.getInstruction();
    }

    private void pushIf(OpCode opCode) {
        BranchHandle pushTrue = this.branch(opCode);
        this.pushBoolean(false);
        BranchHandle end = this.branch(OpCode.GOTO);
        this.pushBoolean(true);
        this.fixTarget(pushTrue);
        this.fixTargetWithNext(end);
    }

    private void setCurrentLocation(InstructionHandle currentLocation) {
        if (!this.targetsToFix.isEmpty()) {
            for (TargetInstruction handle : this.targetsToFix) {
                handle.setTarget(currentLocation);
            }
            this.targetsToFix.clear();
        }
        this.currentLocation = currentLocation;
        if (this.lineNumber > 0) {
            this.methodGen.addLineNumber(currentLocation, this.lineNumber);
        }
    }

    private void storeArrayValue(int index, Object value) {
        Type type = this.stack.top();
        JVMCodeBuilderImpl.verifyIsArray(type);
        this.dup();
        this.loadConstant(index);
        this.append(this.loadConstant(value));
        this.append((Instruction)InstructionFactory.createArrayStore((Type)((ArrayType)type).getElementType()));
        this.stack.remove(3);
    }

    private void verifyArguments(Type[] argTypes) {
        for (int i = argTypes.length - 1; i >= 0; --i) {
            Type to = argTypes[i];
            Type from = this.stack.pop();
            if (TD.isAssignableFrom(to, from) || TD.getValidJavaClass(to.toString()) == null) continue;
            throw this.stack.stackException("Argument (" + i + "). Invalid type: '" + from + "'. Must be: '" + argTypes[i] + '\'');
        }
    }

    private void verifyIsAssignableFrom(Type to, Type from) {
        if (!TD.isAssignableFrom(to, from) && TD.getValidJavaClass(to.toString()) != null) {
            throw this.stack.stackException("Invalid assignment: " + to + " <-- " + from);
        }
    }
}

