/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bcgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.bcgen.FieldD;
import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.JVMCodeBuilderFactory;
import oracle.bpm.bcgen.JVMCodeBuilderImpl;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.bcgen.TD;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NonNls;

public class ClassCode {
    private ClassGen classGen;
    private ConstantPoolGen constantPool;
    private boolean end;
    private JVMCodeBuilder initializer;
    private InstructionFactory instructionFactory;
    private Set<String> methodSignatures;
    private ObjectType type;
    private static final String OBJECT_CLASS_NAME = Object.class.getName();
    static final String[] NO_NAMES = new String[0];
    @NonNls
    private static final String INITIALIZER_METHOD_NAME = "<clinit>";
    @NonNls
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";

    private ClassCode(ClassGen classFile) {
        this.classGen = classFile;
        this.constantPool = classFile.getConstantPool();
        this.instructionFactory = new InstructionFactory(classFile, this.constantPool);
        this.type = TD.getDummyObjectType(this.classGen.getClassName());
        this.methodSignatures = new HashSet<String>();
    }

    public static ClassCode create(ModSet modifiers, String className, String superClass, String sourceFile) {
        ClassGen cg = new ClassGen(className, superClass == null ? OBJECT_CLASS_NAME : superClass, sourceFile, modifiers.getValue() | 0x20, NO_NAMES);
        cg.setMajor(49);
        cg.setMinor(0);
        return new ClassCode(cg);
    }

    public void addConstructor(ModSet modifiers) {
        JVMCodeBuilder codeGen = this.addConstructor(modifiers, Type.NO_ARGS, NO_NAMES);
        codeGen.loadThis();
        codeGen.invokeSuperConstructor(Type.NO_ARGS);
        codeGen.retrn();
        codeGen.endCode();
    }

    public JVMCodeBuilder addConstructor(ModSet modifiers, Type[] argTypes, String[] argNames) {
        return new JVMCodeBuilderImpl(this, modifiers, (Type)Type.VOID, CONSTRUCTOR_METHOD_NAME, argTypes, argNames);
    }

    public FieldD addField(ModSet modifiers, Type fieldType, String fieldName) {
        FieldGen fieldGen = new FieldGen(modifiers.getValue(), fieldType, fieldName, this.constantPool);
        this.classGen.addField(fieldGen.getField());
        return FieldD.create(this.classGen, fieldGen);
    }

    public FieldD addField(ModSet modifiers, Type fieldType, String fieldName, Object initialValue) {
        FieldGen fieldGen = new FieldGen(modifiers.getValue(), fieldType, fieldName, this.constantPool);
        if (initialValue != null && !ClassCode.isDefaultInitValue(initialValue) && fieldGen.isFinal()) {
            if (initialValue instanceof String) {
                fieldGen.setInitValue((String)initialValue);
            } else if (initialValue instanceof Integer) {
                fieldGen.setInitValue(((Integer)initialValue).intValue());
            } else if (initialValue instanceof Byte) {
                fieldGen.setInitValue(((Byte)initialValue).byteValue());
            } else if (initialValue instanceof Short) {
                fieldGen.setInitValue(((Short)initialValue).shortValue());
            } else if (initialValue instanceof Long) {
                fieldGen.setInitValue(((Long)initialValue).longValue());
            } else if (initialValue instanceof Double) {
                fieldGen.setInitValue(((Double)initialValue).doubleValue());
            } else if (initialValue instanceof Float) {
                fieldGen.setInitValue(((Float)initialValue).floatValue());
            } else if (initialValue instanceof Boolean) {
                fieldGen.setInitValue(((Boolean)initialValue).booleanValue());
            }
        }
        this.classGen.addField(fieldGen.getField());
        return FieldD.create(this.classGen, fieldGen);
    }

    public void addInterface(String interfaceClassName) {
        this.classGen.addInterface(interfaceClassName);
    }

    public JVMCodeBuilder addMain() {
        Type[] argTypes = new Type[]{new ArrayType((Type)Type.STRING, 1)};
        return JVMCodeBuilderFactory.create(this, Mod.PUBLIC.STATIC(), (Type)Type.VOID, "main", argTypes, "args");
    }

    public JVMCodeBuilder addMethod(ModSet modifiers, Type returnType, String methodName, Type[] argTypes, String[] argNames, Type[] exceptions) {
        return JVMCodeBuilderFactory.create(this, modifiers, returnType, methodName, argTypes == null ? Type.NO_ARGS : argTypes, argTypes == null || argNames == null ? NO_NAMES : argNames);
    }

    public void endCode() {
        if (!this.end) {
            this.end = true;
            if (this.initializer != null) {
                this.initializer.retrn();
                this.initializer.endCode();
            }
        }
    }

    public ClassGen getClassGen() {
        return this.classGen;
    }

    public String getClassName() {
        return this.type.getClassName();
    }

    public ConstantPoolGen getConstantPool() {
        return this.constantPool;
    }

    public JVMCodeBuilder getInitializer() {
        if (this.initializer == null) {
            this.initializer = JVMCodeBuilderFactory.create(this, Mod.STATIC, (Type)Type.VOID, INITIALIZER_METHOD_NAME, Type.NO_ARGS, NO_NAMES);
        }
        return this.initializer;
    }

    public String getSuperClassName() {
        return this.classGen.getSuperclassName();
    }

    public ObjectType getType() {
        return this.type;
    }

    public void save(String directoryName) throws IOException {
        File targetDir = new File(directoryName);
        this.save(targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File targetDir) throws IOException {
        File classFile = new File(targetDir, this.getClassName().replace('.', '/').concat(".class"));
        File directory = classFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new FileNotFoundException(classFile.toString());
        }
        FileOutputStream outputStream = new FileOutputStream(classFile);
        try {
            this.save(outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public void setExtends(TypeDescription javaBaseType) {
        this.classGen.addInterface(javaBaseType.getJavaType());
    }

    public void save(OutputStream outputStream) throws IOException {
        this.endCode();
        this.classGen.getJavaClass().dump(outputStream);
    }

    InstructionFactory getInstructionFactory() {
        return this.instructionFactory;
    }

    void checkUnique(String signature) {
        if (this.methodSignatures.contains(signature)) {
            throw new IllegalStateException("A method with the signature: '" + signature + "' has already been added.");
        }
        this.methodSignatures.add(signature);
    }

    private static boolean isDefaultInitValue(Object initialValue) {
        boolean ret = false;
        if (initialValue instanceof Integer) {
            ret = (Integer)initialValue == 0;
        } else if (initialValue instanceof Byte) {
            ret = (Byte)initialValue == 0;
        } else if (initialValue instanceof Short) {
            ret = (Short)initialValue == 0;
        } else if (initialValue instanceof Long) {
            ret = (Long)initialValue == 0L;
        } else if (initialValue instanceof Boolean) {
            ret = (Boolean)initialValue == false;
        }
        return ret;
    }
}

