/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration.reporter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.BaseRecordPrinter;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordFormat;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;

class XmlRecordPrinter
extends BaseRecordPrinter {
    XmlRecordPrinter() {
    }

    @Override
    public void printData(String field, String value) throws IOException {
        super.printData(field, value);
        if (value != null) {
            this.getWriter().append("<" + field + ">");
            this.getWriter().append(value);
            this.getWriter().append("</" + field + ">");
        }
    }

    @Override
    public <T> void printData(String field, String item, PrintableRecord<T> printableRecord, List<T> values, RecordOrientation recordOrientation) throws IOException {
        super.printData(field, item, printableRecord, values, recordOrientation);
        if (values != null) {
            this.getWriter().append("<" + field + ">");
            this.print(item, printableRecord, values, recordOrientation);
            this.getWriter().append("</" + field + ">");
        }
    }

    @Override
    public <T> void printReportData(PrintableRecord<T> printableRecord, T value) throws IOException {
        super.printReportData(printableRecord, value);
        this.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
        if (value != null) {
            this.print("report", printableRecord, Collections.singletonList(value), RecordOrientation.HORIZONTAL);
        }
    }

    private <T> void print(String item, PrintableRecord<T> printableRecord, List<T> values, RecordOrientation recordOrientation) throws IOException {
        RecordFormat recordFormat = this.createRecordFormat();
        recordFormat.recordOrientation = recordOrientation;
        this.getRecordFormats().push(recordFormat);
        if (values.size() > 1) {
            for (T value : values) {
                this.getWriter().append("<" + item + ">");
                printableRecord.print(value, this);
                this.getWriter().append("</" + item + ">");
            }
        } else {
            for (T value : values) {
                printableRecord.print(value, this);
            }
        }
        this.getRecordFormats().pop();
    }
}

