/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration.reporter;

import java.io.IOException;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.BasePrintableField;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordPrinter;

abstract class PrintableRecordField<T, S>
extends BasePrintableField<T> {
    private final String itemHeader;
    private final PrintableRecord<S> printableRecord;
    private final RecordOrientation recordOrientation;

    protected PrintableRecordField(String header, String itemHeader, PrintableRecord<S> printableRecord, RecordOrientation recordOrientation) {
        super(header);
        this.itemHeader = itemHeader;
        this.printableRecord = printableRecord;
        this.recordOrientation = recordOrientation;
    }

    @Override
    public void print(T record, RecordPrinter recordPrinter) throws IOException {
        recordPrinter.printData(this.getHeader(), this.getItemHeader(), this.getPrintableRecord(), this.getValue(record), this.getRecordOrientation());
    }

    protected abstract List<S> getValue(T var1);

    RecordOrientation getRecordOrientation() {
        return this.recordOrientation;
    }

    PrintableRecord<S> getPrintableRecord() {
        return this.printableRecord;
    }

    String getItemHeader() {
        return this.itemHeader;
    }
}

