/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration.reporter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.BaseRecordPrinter;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordFormat;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;

class HtmlRecordPrinter
extends BaseRecordPrinter {
    HtmlRecordPrinter() {
    }

    @Override
    public void printData(String field, String value) throws IOException {
        super.printData(field, value);
        if (value == null) {
            value = "&nbsp;";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (RecordOrientation.HORIZONTAL.equals((Object)this.getRecordOrientation())) {
            stringBuilder.append("<td>");
            stringBuilder.append(value);
            stringBuilder.append("</td>");
        } else if (RecordOrientation.VERTICAL.equals((Object)this.getRecordOrientation())) {
            stringBuilder.append("<tr><th align='right' valign='top'>");
            stringBuilder.append(field);
            stringBuilder.append(":</th><td>");
            stringBuilder.append(value);
            stringBuilder.append("</td></tr>");
        }
        this.getWriter().write(stringBuilder.toString());
    }

    @Override
    public <T> void printData(String field, String item, PrintableRecord<T> printableRecord, List<T> values, RecordOrientation recordOrientation) throws IOException {
        super.printData(field, item, printableRecord, values, recordOrientation);
        if (values != null) {
            if (RecordOrientation.HORIZONTAL.equals((Object)this.getRecordOrientation())) {
                this.getWriter().write("<td>");
                this.print(item, printableRecord, values, recordOrientation);
                this.getWriter().write("</td>");
            } else if (RecordOrientation.VERTICAL.equals((Object)this.getRecordOrientation())) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<tr><th align='right' valign='top'>");
                stringBuilder.append(field);
                stringBuilder.append(":</th><td>");
                this.getWriter().write(stringBuilder.toString());
                this.print(item, printableRecord, values, recordOrientation);
                stringBuilder = new StringBuilder();
                stringBuilder.append("</td></tr>");
                this.getWriter().write(stringBuilder.toString());
            }
        }
    }

    @Override
    public <T> void printReportData(PrintableRecord<T> printableRecord, T value) throws IOException {
        super.printReportData(printableRecord, value);
        this.getWriter().write("<html><body>");
        if (value != null) {
            this.print("report", printableRecord, Collections.singletonList(value), RecordOrientation.HORIZONTAL);
        }
        this.getWriter().write("</body></html>");
    }

    private <T> void print(String item, PrintableRecord<T> printableRecord, List<T> values, RecordOrientation recordOrientation) throws IOException {
        RecordFormat recordFormat = this.createRecordFormat();
        recordFormat.recordOrientation = recordOrientation;
        this.getRecordFormats().push(recordFormat);
        this.getWriter().write("<table border=1>");
        if (RecordOrientation.HORIZONTAL.equals((Object)this.getRecordOrientation())) {
            this.getWriter().write("<tr>");
            for (String label : printableRecord.getHeaders()) {
                this.getWriter().write("<th>");
                this.getWriter().write(label);
                this.getWriter().write("</th>");
            }
            this.getWriter().write("</tr>");
            for (String value : values) {
                this.getWriter().write("<tr>");
                printableRecord.print(value, this);
                this.getWriter().write("</tr>");
            }
        } else if (RecordOrientation.VERTICAL.equals((Object)this.getRecordOrientation())) {
            for (T value : values) {
                this.getWriter().write("<tr><td><table border=0>");
                printableRecord.print((String)value, this);
                this.getWriter().write("</table></td></tr>");
            }
        }
        this.getWriter().write("</table>");
        this.getRecordFormats().pop();
    }
}

