/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration.reporter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordFormat;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordPrinter;

abstract class BaseRecordPrinter
extends RecordPrinter {
    private Deque<RecordFormat> recordFormats = new LinkedList<RecordFormat>();
    private Writer writer;

    BaseRecordPrinter() {
    }

    @Override
    public void printData(String field, String value) throws IOException {
        if (field == null) {
            throw new IllegalArgumentException("null field");
        }
    }

    @Override
    public <T> void printData(String field, String item, PrintableRecord<T> printableRecord, List<T> values, RecordOrientation recordOrientation) throws IOException {
        if (field == null || item == null) {
            throw new IllegalArgumentException("null field or item");
        }
        if (printableRecord == null) {
            throw new IllegalArgumentException("null printable record");
        }
    }

    @Override
    public <T> void printReportData(PrintableRecord<T> printableRecord, T value) throws IOException {
        if (printableRecord == null) {
            throw new IllegalArgumentException("null printable record");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void printReport(PrintableRecord<T> printableRecord, T value, File file) throws IOException, UnsupportedEncodingException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.setWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF8")));
            this.printReportData(printableRecord, value);
        }
        finally {
            if (this.getWriter() != null) {
                try {
                    this.getWriter().flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.setWriter(null);
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected RecordFormat createRecordFormat() {
        return new RecordFormat();
    }

    protected RecordOrientation getRecordOrientation() {
        return this.getRecordFormats().peek().recordOrientation;
    }

    protected Deque<RecordFormat> getRecordFormats() {
        return this.recordFormats;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    private void setWriter(Writer writer) {
        this.writer = writer;
    }
}

