/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration.reporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableField;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecordField;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordPrinter;
import oracle.bpmn.engine.tools.pub.migration.reporter.SinglePrintableRecordField;
import oracle.bpmn.engine.tools.pub.migration.reporter.StringPrintableField;

public abstract class BasePrintableRecord<T>
implements PrintableRecord<T> {
    private List<String> headers;
    private final List<PrintableField<T>> printableFields = new ArrayList<PrintableField<T>>();

    protected BasePrintableRecord() {
    }

    @Override
    public List<String> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
            for (PrintableField<T> printableField : this.printableFields) {
                this.headers.add(printableField.getHeader());
            }
        }
        return this.headers;
    }

    @Override
    public void print(T value, RecordPrinter recordPrinter) throws IOException {
        for (PrintableField<T> printableField : this.printableFields) {
            printableField.print(value, recordPrinter);
        }
    }

    protected void addField(PrintableField<T> printableField) {
        this.printableFields.add(printableField);
    }

    public abstract class BaseStringPrintableField
    extends StringPrintableField<T> {
        public BaseStringPrintableField(String header) {
            super(header);
        }
    }

    public abstract class BaseSinglePrintableRecordField<S>
    extends SinglePrintableRecordField<T, S> {
        public BaseSinglePrintableRecordField(String header, PrintableRecord<S> printableRecord, RecordOrientation recordOrientation) {
            super(header, printableRecord, recordOrientation);
        }
    }

    public abstract class BasePrintableRecordField<S>
    extends PrintableRecordField<T, S> {
        public BasePrintableRecordField(String header, String itemHeader, PrintableRecord<S> printableRecord, RecordOrientation recordOrientation) {
            super(header, itemHeader, printableRecord, recordOrientation);
        }
    }
}

