/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class Utils {
    private static final String PROPERTY_DOCUMENTBUILDERFACTORY = "javax.xml.parsers.DocumentBuilderFactory";

    public static <T> T getProjectReference(Project project, String key, Class<T> clazz) {
        Object object = project.getReference(key);
        if (object == null) {
            throw new BuildException("Failed to resolve project reference " + key);
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new BuildException("Project reference class expected " + clazz.getSimpleName() + ", actual " + object.getClass().getSimpleName());
        }
        return (T)object;
    }

    public static String getExtension(File file) {
        return Utils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        return fileName.substring(dotPos + 1, fileName.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withDocumentBuilderFactory(RunnableCode<T> runnableCode, String documentBuilderFactoryClass) throws Exception {
        String oldProperty = System.getProperty(PROPERTY_DOCUMENTBUILDERFACTORY);
        System.setProperty(PROPERTY_DOCUMENTBUILDERFACTORY, documentBuilderFactoryClass);
        try {
            T t = runnableCode.run();
            return t;
        }
        finally {
            if (oldProperty != null) {
                System.setProperty(PROPERTY_DOCUMENTBUILDERFACTORY, oldProperty);
            }
        }
    }

    static interface RunnableCode<T> {
        public T run() throws Exception;
    }
}

