/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.MigrationReportPrinter;
import oracle.bpmn.engine.tools.pub.migration.MigrationResultPrinter;
import oracle.integration.platform.blocks.migration.ComponentInstanceReportFactory;
import oracle.integration.platform.blocks.migration.ComponentInstanceResultFactory;
import oracle.integration.platform.blocks.migration.CompositeInstanceReportFactory;
import oracle.integration.platform.blocks.migration.CompositeInstanceResultFactory;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.CompositeInstanceMigrationReport;
import oracle.soa.management.facade.CompositeInstanceMigrationResult;
import oracle.soa.management.facade.MigrationFeasibility;
import oracle.soa.management.facade.MigrationReport;
import oracle.soa.management.facade.MigrationResult;
import oracle.soa.management.internal.facade.MigrationReportFactory;
import oracle.soa.management.internal.facade.MigrationResultFactory;

public class SampleReports {
    public static void test() {
        File outputDir = new File("/mnt/sda2/home/julian/localwork/tasks/prometheus/specification/ps6/PRO-4437/resources/tmp");
        try {
            MigrationReport migrationReport = SampleReports.migrationReport_1();
            new MigrationReportPrinter().print(migrationReport, "xml", new File(outputDir, "migrationReport.xml"));
            new MigrationReportPrinter().print(migrationReport, "html", new File(outputDir, "migrationReport.html"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            MigrationResult migrationResult = SampleReports.migrationResult_1();
            new MigrationResultPrinter().print(migrationResult, "html", new File(outputDir, "migrationResult.html"));
            new MigrationResultPrinter().print(migrationResult, "xml", new File(outputDir, "migrationResult.xml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    private static ComponentInstanceMigrationReport componentInstanceMigrationReport(String name, String instanceId, MigrationFeasibility feasibility, String incompatibilityReason) {
        return ComponentInstanceReportFactory.getInstance().create(name, instanceId, feasibility, incompatibilityReason);
    }

    private static CompositeInstanceMigrationReport compositeInstanceMigrationReport(CompositeDN compositeDN, String instanceId, String revision, List<ComponentInstanceMigrationReport> componentInstanceReports) {
        return CompositeInstanceReportFactory.getInstance().create(compositeDN, instanceId, revision, componentInstanceReports, true);
    }

    private static MigrationReport migrationReport(String targetRevision, List<CompositeInstanceMigrationReport> compositeInstanceMigrationReports) {
        return MigrationReportFactory.getInstance().createReport(targetRevision, compositeInstanceMigrationReports);
    }

    private static MigrationReport migrationReport_1() {
        return SampleReports.migrationReport("2.0", SampleReports.list(SampleReports.compositeInstanceMigrationReport(new CompositeDN("default/App*1.0"), "1", "2.0", SampleReports.list(SampleReports.componentInstanceMigrationReport("compo1", "1", MigrationFeasibility.Automatic, null), SampleReports.componentInstanceMigrationReport("compo1", "2", MigrationFeasibility.Manual, null), SampleReports.componentInstanceMigrationReport("compo1", "3", MigrationFeasibility.Incompatible, "incompatible migration"))), SampleReports.compositeInstanceMigrationReport(new CompositeDN("default/App*1.0"), "2", "2.0", SampleReports.list(SampleReports.componentInstanceMigrationReport("compo1", "1", MigrationFeasibility.Automatic, null)))));
    }

    private static ComponentInstanceMigrationResult componentInstanceMigrationResult(String componentName, String componentType, String instanceId, boolean migrated, String failureReason) {
        return ComponentInstanceResultFactory.getInstance().create(componentName, componentType, instanceId, migrated, failureReason);
    }

    private static CompositeInstanceMigrationResult compositeInstanceMigrationResult(CompositeDN compositeDN, String instanceId, String revision, List<ComponentInstanceMigrationResult> componentInstanceMigrationResults) {
        return CompositeInstanceResultFactory.getInstance().create(compositeDN, instanceId, revision, componentInstanceMigrationResults, true);
    }

    private static MigrationResult migrationResult(String targetRevision, List<CompositeInstanceMigrationResult> compositeInstanceMigrationResults) {
        return MigrationResultFactory.getInstance().createResult(targetRevision, compositeInstanceMigrationResults);
    }

    private static MigrationResult migrationResult_1() {
        return SampleReports.migrationResult("2.0", SampleReports.list(SampleReports.compositeInstanceMigrationResult(new CompositeDN("default/App*1.0"), "1", "2.0", SampleReports.list(SampleReports.componentInstanceMigrationResult("compo1", "bpmn", "1", true, null), SampleReports.componentInstanceMigrationResult("compo1", "bpmn", "2", true, null), SampleReports.componentInstanceMigrationResult("compo1", "bpmn", "3", false, "failed to migrate"))), SampleReports.compositeInstanceMigrationResult(new CompositeDN("default/App*1.0"), "2", "2.0", SampleReports.list(SampleReports.componentInstanceMigrationResult("compo1", "bpmn", "4", true, null), SampleReports.componentInstanceMigrationResult("compo1", "bpmn", "5", false, "failed to migrate")))));
    }
}

