/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.BasePrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;
import oracle.bpmn.engine.tools.pub.migration.reporter.ReportPrinter;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.ComponentInstanceMigrationResult;
import oracle.soa.management.facade.CompositeInstanceMigrationResult;
import oracle.soa.management.facade.MigrationResult;

public class MigrationResultPrinter {
    public static MigrationResultPrinter getInstance() {
        return new MigrationResultPrinter();
    }

    public void print(MigrationResult migrationResult, String format, File file) throws IOException {
        ReportPrinter reportPrinter = new ReportPrinter();
        reportPrinter.printReport(new MigrationResultReportPrintableRecord(), migrationResult, format, file);
    }

    private static class MigrationResultReportPrintableRecord
    extends BasePrintableRecord<MigrationResult> {
        private static final String REPORT = "migrationResultsReport";

        MigrationResultReportPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseSinglePrintableRecordField<MigrationResult>(REPORT, (PrintableRecord)new MigrationResultPrintableRecord(), RecordOrientation.VERTICAL){

                @Override
                protected MigrationResult getSingleValue(MigrationResult record) {
                    return record;
                }
            });
        }
    }

    private static class MigrationResultPrintableRecord
    extends BasePrintableRecord<MigrationResult> {
        private static final String TARGET_REVISION = "targetRevision";
        private static final String COMPOSITE_COUNT = "compositeCount";
        private static final String FAILED_COUNT = "failedCount";
        private static final String FAILED_INSTANCES = "failedInstances";
        private static final String FAILED_INSTANCES_ITEM = "failedInstance";
        private static final String MIGRATED_COUNT = "migratedCount";
        private static final String MIGRATED_INSTANCES = "migratedInstances";
        private static final String MIGRATED_INSTANCES_ITEM = "migratedInstance";

        MigrationResultPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(TARGET_REVISION){

                @Override
                protected String getValue(MigrationResult record) {
                    return record.getTargetRevision();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPOSITE_COUNT){

                @Override
                protected String getValue(MigrationResult record) {
                    return String.valueOf(record.getCompositeCount());
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(FAILED_COUNT){

                @Override
                protected String getValue(MigrationResult record) {
                    return String.valueOf(record.getFailedCount());
                }
            });
            this.addField(new BasePrintableRecord.BasePrintableRecordField<CompositeInstanceMigrationResult>(FAILED_INSTANCES, FAILED_INSTANCES_ITEM, (PrintableRecord)new CompositeInstanceMigrationResultPrintableRecord(), RecordOrientation.HORIZONTAL){

                @Override
                protected List<CompositeInstanceMigrationResult> getValue(MigrationResult record) {
                    return record.getFailedInstances();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(MIGRATED_COUNT){

                @Override
                protected String getValue(MigrationResult record) {
                    return String.valueOf(record.getMigratedCount());
                }
            });
            this.addField(new BasePrintableRecord.BasePrintableRecordField<CompositeInstanceMigrationResult>(MIGRATED_INSTANCES, MIGRATED_INSTANCES_ITEM, (PrintableRecord)new CompositeInstanceMigrationResultPrintableRecord(), RecordOrientation.HORIZONTAL){

                @Override
                protected List<CompositeInstanceMigrationResult> getValue(MigrationResult record) {
                    return record.getMigratedInstances();
                }
            });
        }
    }

    private static class CompositeInstanceMigrationResultPrintableRecord
    extends BasePrintableRecord<CompositeInstanceMigrationResult> {
        private static final String ID = "id";
        private static final String COMPOSITE_DN = "compositeDn";
        private static final String TARGET_REVISION = "targetRevision";
        private static final String FAILURE_REASON = "failureReason";
        private static final String COMPONENT_INSTANCES = "componentInstances";
        private static final String COMPONENT_INSTANCE_ITEM = "componentInstance";

        CompositeInstanceMigrationResultPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(ID){

                @Override
                protected String getValue(CompositeInstanceMigrationResult record) {
                    return record.getId();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPOSITE_DN){

                @Override
                protected String getValue(CompositeInstanceMigrationResult record) {
                    return new CompositeDN(record.getPartition(), record.getName(), record.getRevision()).getStringDN();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(TARGET_REVISION){

                @Override
                protected String getValue(CompositeInstanceMigrationResult record) {
                    return record.getTargetRevision();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(FAILURE_REASON){

                @Override
                protected String getValue(CompositeInstanceMigrationResult record) {
                    return record.getFailureReason();
                }
            });
            this.addField(new BasePrintableRecord.BasePrintableRecordField<ComponentInstanceMigrationResult>(COMPONENT_INSTANCES, COMPONENT_INSTANCE_ITEM, (PrintableRecord)new ComponentInstanceMigrationResultPrintableRecord(), RecordOrientation.HORIZONTAL){

                @Override
                protected List<ComponentInstanceMigrationResult> getValue(CompositeInstanceMigrationResult record) {
                    return record.getComponentInstances();
                }
            });
        }
    }

    private static class ComponentInstanceMigrationResultPrintableRecord
    extends BasePrintableRecord<ComponentInstanceMigrationResult> {
        private static final String ID = "id";
        private static final String FAILURE_REASON = "failureReason";
        private static final String NAME = "name";
        private static final String TYPE = "type";

        ComponentInstanceMigrationResultPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(ID){

                @Override
                protected String getValue(ComponentInstanceMigrationResult record) {
                    return record.getId();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(NAME){

                @Override
                protected String getValue(ComponentInstanceMigrationResult record) {
                    return record.getName();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(FAILURE_REASON){

                @Override
                protected String getValue(ComponentInstanceMigrationResult record) {
                    return record.getFailureReason();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(TYPE){

                @Override
                protected String getValue(ComponentInstanceMigrationResult record) {
                    return record.getType();
                }
            });
        }
    }
}

