/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.reporter.BasePrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.PrintableRecord;
import oracle.bpmn.engine.tools.pub.migration.reporter.RecordOrientation;
import oracle.bpmn.engine.tools.pub.migration.reporter.ReportPrinter;
import oracle.soa.management.CompositeDN;
import oracle.soa.management.facade.ComponentInstanceMigrationReport;
import oracle.soa.management.facade.CompositeInstanceMigrationReport;
import oracle.soa.management.facade.MigrationReport;

public class MigrationReportPrinter {
    public static MigrationReportPrinter getInstance() {
        return new MigrationReportPrinter();
    }

    public void print(MigrationReport migrationReport, String format, File file) throws IOException {
        ReportPrinter reportPrinter = new ReportPrinter();
        reportPrinter.printReport(new MigrationReportReportPrintableRecord(), migrationReport, format, file);
    }

    private static class MigrationReportReportPrintableRecord
    extends BasePrintableRecord<MigrationReport> {
        private static final String REPORT = "migrationReport";

        MigrationReportReportPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseSinglePrintableRecordField<MigrationReport>(REPORT, (PrintableRecord)new MigrationReportPrintableRecord(), RecordOrientation.VERTICAL){

                @Override
                protected MigrationReport getSingleValue(MigrationReport record) {
                    return record;
                }
            });
        }
    }

    private static class MigrationReportPrintableRecord
    extends BasePrintableRecord<MigrationReport> {
        private static final String TARGET_REVISION = "targetRevision";
        private static final String FEASIBILITY = "feasibility";
        private static final String COMPOSITE_INSTANCE_COUNT = "compositeInstanceCount";
        private static final String COMPOSITE_INSTANCES = "compositeInstances";
        private static final String COMPOSITE_INSTANCES_ITEM = "compositeInstance";

        MigrationReportPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(TARGET_REVISION){

                @Override
                protected String getValue(MigrationReport record) {
                    return record.getTargetRevision();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(FEASIBILITY){

                @Override
                protected String getValue(MigrationReport record) {
                    return String.valueOf(record.getFeasibility());
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPOSITE_INSTANCE_COUNT){

                @Override
                protected String getValue(MigrationReport record) {
                    return String.valueOf(record.getCompositeInstanceCount());
                }
            });
            this.addField(new BasePrintableRecord.BasePrintableRecordField<CompositeInstanceMigrationReport>(COMPOSITE_INSTANCES, COMPOSITE_INSTANCES_ITEM, (PrintableRecord)new CompositeInstanceMigrationReportPrintableRecord(), RecordOrientation.HORIZONTAL){

                @Override
                protected List<CompositeInstanceMigrationReport> getValue(MigrationReport record) {
                    return record.getCompositeInstances();
                }
            });
        }
    }

    private static class CompositeInstanceMigrationReportPrintableRecord
    extends BasePrintableRecord<CompositeInstanceMigrationReport> {
        private static final String COMPOSITE_ID = "compositeId";
        private static final String COMPOSITE_DN = "compositeDn";
        private static final String TARGET_REVISION = "targetRevision";
        private static final String FEASIBILITY = "feasibility";
        private static final String INCOMPATIBILITY_REASON = "incompatibilityReason";
        private static final String COMPONENT_INSTANCE_COUNT = "componentInstanceCount";
        private static final String COMPONENT_INSTANCES = "componentInstances";
        private static final String COMPONENT_INSTANCES_ITEM = "componentInstance";

        CompositeInstanceMigrationReportPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPOSITE_ID){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return record.getCompositeId();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPOSITE_DN){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return new CompositeDN(record.getPartition(), record.getCompositeName(), record.getRevision()).getStringDN();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(TARGET_REVISION){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return record.getTargetRevision();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(FEASIBILITY){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return String.valueOf(record.getFeasibility());
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(INCOMPATIBILITY_REASON){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return record.getIncompatibilityReason();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPONENT_INSTANCE_COUNT){

                @Override
                protected String getValue(CompositeInstanceMigrationReport record) {
                    return String.valueOf(record.getComponentInstanceCount());
                }
            });
            this.addField(new BasePrintableRecord.BasePrintableRecordField<ComponentInstanceMigrationReport>(COMPONENT_INSTANCES, COMPONENT_INSTANCES_ITEM, (PrintableRecord)new ComponentInstanceMigrationReportPrintableRecord(), RecordOrientation.HORIZONTAL){

                @Override
                protected List<ComponentInstanceMigrationReport> getValue(CompositeInstanceMigrationReport record) {
                    return record.getComponentInstances();
                }
            });
        }
    }

    private static class ComponentInstanceMigrationReportPrintableRecord
    extends BasePrintableRecord<ComponentInstanceMigrationReport> {
        private static final String COMPONENT_ID = "componentId";
        private static final String COMPONENT_NAME = "componentName";
        private static final String INCOMPATIBILITY_REASON = "incompatibilityReason";
        private static final String MIGRATION_FEASIBILITY = "migrationFeasibility";

        ComponentInstanceMigrationReportPrintableRecord() {
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPONENT_ID){

                @Override
                protected String getValue(ComponentInstanceMigrationReport record) {
                    return record.getComponentId();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(COMPONENT_NAME){

                @Override
                protected String getValue(ComponentInstanceMigrationReport record) {
                    return record.getComponentName();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(INCOMPATIBILITY_REASON){

                @Override
                protected String getValue(ComponentInstanceMigrationReport record) {
                    return record.getIncompatibilityReason();
                }
            });
            this.addField(new BasePrintableRecord.BaseStringPrintableField(MIGRATION_FEASIBILITY){

                @Override
                protected String getValue(ComponentInstanceMigrationReport record) {
                    return record.getMigrationFeasibility().toString();
                }
            });
        }
    }
}

