/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import oracle.bpmn.engine.tools.pub.migration.CompositeInstanceFilterDef;
import oracle.bpmn.engine.tools.pub.migration.LocatorAction;
import oracle.bpmn.engine.tools.pub.migration.LocatorActionException;
import oracle.bpmn.engine.tools.pub.migration.LocatorSessionContext;
import oracle.bpmn.engine.tools.pub.migration.MigrationResultPrinter;
import oracle.bpmn.engine.tools.pub.migration.Utils;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.MigrationPlan;
import oracle.soa.management.facade.MigrationPlanFactory;
import oracle.soa.management.facade.MigrationResult;
import oracle.soa.management.util.CompositeInstanceFilter;

public class MigrateCompositeInstances
extends LocatorAction {
    private String filterId;
    private String migrationPlan;
    private String outputFile;
    private String revision;

    @Deprecated
    public String getRevision() {
        return this.revision;
    }

    public String getTargetRevision() {
        return this.revision;
    }

    @Deprecated
    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setTargetRevision(String revision) {
        this.revision = revision;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getMigrationPlan() {
        return this.migrationPlan;
    }

    public void setMigrationPlan(String migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    @Override
    public String getDescription() {
        return "Migrates composite instances";
    }

    @Override
    public void execute(LocatorSessionContext locatorSessionContext) throws LocatorActionException {
        super.execute(locatorSessionContext);
        try {
            Locator locator = locatorSessionContext.getLocator();
            CompositeInstanceFilterDef compositeInstanceFilterDef = Utils.getProjectReference(this.getProject(), this.getFilterId(), CompositeInstanceFilterDef.class);
            CompositeInstanceFilter compositeInstanceFilter = compositeInstanceFilterDef.createCompositeInstanceFilter();
            this.log("using compositeInstanceFilter: " + compositeInstanceFilter, 3);
            MigrationPlan migrationPlan = null;
            String migrationPlanPath = this.getMigrationPlan();
            if (migrationPlanPath != null) {
                File migrationPlanFile = new File(migrationPlanPath);
                migrationPlan = MigrateCompositeInstances.loadMigrationPlan(migrationPlanFile);
            }
            MigrationResult migrationResult = locator.migrateCompositeInstances(compositeInstanceFilter, this.getRevision(), migrationPlan);
            if (this.getOutputFile() != null) {
                MigrationResultPrinter.getInstance().print(migrationResult, this.getOutputFormat(), this.getOutputFile());
            }
        }
        catch (Exception e) {
            throw new LocatorActionException(e);
        }
    }

    private static MigrationPlan loadMigrationPlan(final File migrationPlanFile) throws Exception {
        return Utils.withDocumentBuilderFactory(new Utils.RunnableCode<MigrationPlan>(){

            @Override
            public MigrationPlan run() throws Exception {
                return MigrationPlanFactory.getInstance().create(migrationPlanFile);
            }
        }, "oracle.xml.jaxp.JXDocumentBuilderFactory");
    }

    private File getOutputFile() {
        return new File(this.outputFile);
    }

    private String getOutputFormat() {
        return Utils.getExtension(this.getOutputFile());
    }
}

