/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.GenerateMigrationReport;
import oracle.bpmn.engine.tools.pub.migration.LocatorAction;
import oracle.bpmn.engine.tools.pub.migration.LocatorActionException;
import oracle.bpmn.engine.tools.pub.migration.LocatorConfig;
import oracle.bpmn.engine.tools.pub.migration.LocatorConfigException;
import oracle.bpmn.engine.tools.pub.migration.LocatorSessionContext;
import oracle.bpmn.engine.tools.pub.migration.MigrateCompositeInstances;
import oracle.bpmn.engine.tools.pub.migration.Utils;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.LocatorFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.StringUtils;

public class LocatorSession
extends Task {
    private String configId;
    private List<LocatorAction> locatorActions = new ArrayList<LocatorAction>();

    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void addGenerateMigrationReport(GenerateMigrationReport locatorAction) {
        this.addLocatorAction(locatorAction);
    }

    public void addMigrateCompositeInstances(MigrateCompositeInstances locatorAction) {
        this.addLocatorAction(locatorAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Locator locator;
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.log("begin execution of locator session ", 3);
            LocatorConfig locatorConfig = Utils.getProjectReference(this.getProject(), this.getConfigId(), LocatorConfig.class);
            this.log("retrieved connection data object  " + (Object)((Object)locatorConfig), 3);
            try {
                locatorConfig.validate();
                this.log("using connection data " + (Object)((Object)locatorConfig), 3);
                Hashtable<String, String> jndiProps = new Hashtable<String, String>();
                jndiProps.put("java.naming.provider.url", "t3://" + locatorConfig.getHost() + ":" + locatorConfig.getPort());
                jndiProps.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                jndiProps.put("java.naming.security.principal", locatorConfig.getUser());
                jndiProps.put("java.naming.security.credentials", locatorConfig.getPassword());
                locator = LocatorFactory.createLocator(jndiProps);
            }
            catch (LocatorConfigException e) {
                this.log("locator config exception", 0);
                this.log(StringUtils.getStackTrace((Throwable)e), 0);
                throw new BuildException("Failed to validate locator data " + this.getConfigId() + ". Details: " + e.getMessage());
            }
            catch (Exception e) {
                this.log("failed to connect", 0);
                this.log(StringUtils.getStackTrace((Throwable)e), 0);
                throw new BuildException("Failed to create locator.", (Throwable)e);
            }
            if (locator != null) {
                LocatorSessionContext locatorSessionContext = new LocatorSessionContext(locator);
                for (LocatorAction locatorAction : this.getLocatorActions()) {
                    try {
                        locatorAction.execute(locatorSessionContext);
                    }
                    catch (LocatorActionException e) {
                        this.log("failed to connect", 0);
                        this.log(StringUtils.getStackTrace((Throwable)e), 0);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void addLocatorAction(LocatorAction locatorAction) {
        this.locatorActions.add(locatorAction);
    }

    private List<LocatorAction> getLocatorActions() {
        return this.locatorActions;
    }
}

