/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpmn.engine.tools.pub.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.bpmn.engine.tools.pub.migration.CompositeInstanceFilterDef;
import oracle.bpmn.engine.tools.pub.migration.LocatorAction;
import oracle.bpmn.engine.tools.pub.migration.LocatorActionException;
import oracle.bpmn.engine.tools.pub.migration.LocatorSessionContext;
import oracle.bpmn.engine.tools.pub.migration.MigrateReportedCompositeInstances;
import oracle.bpmn.engine.tools.pub.migration.MigrationReportAction;
import oracle.bpmn.engine.tools.pub.migration.MigrationReportActionContext;
import oracle.bpmn.engine.tools.pub.migration.MigrationReportPrinter;
import oracle.bpmn.engine.tools.pub.migration.Utils;
import oracle.soa.management.facade.Locator;
import oracle.soa.management.facade.MigrationReport;
import oracle.soa.management.util.CompositeInstanceFilter;

public class GenerateMigrationReport
extends LocatorAction {
    private String filterId;
    private List<MigrationReportAction> migrationReportActions = new ArrayList<MigrationReportAction>();
    private String outputFile;
    private String revision;
    private boolean synchronous;

    @Deprecated
    public String getRevision() {
        return this.revision;
    }

    public String getTargetRevision() {
        return this.revision;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    @Deprecated
    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setTargetRevision(String revision) {
        this.revision = revision;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    @Override
    public String getDescription() {
        return "Generates migration report";
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void addMigrateReportedCompositeInstances(MigrateReportedCompositeInstances migrateReportedCompositeInstances) {
        this.addMigrationReportAction(migrateReportedCompositeInstances);
    }

    public List<MigrationReportAction> getMigrationReportActions() {
        return this.migrationReportActions;
    }

    @Override
    public void execute(LocatorSessionContext locatorSessionContext) throws LocatorActionException {
        super.execute(locatorSessionContext);
        try {
            Locator locator = locatorSessionContext.getLocator();
            CompositeInstanceFilterDef compositeInstanceFilterDef = Utils.getProjectReference(this.getProject(), this.getFilterId(), CompositeInstanceFilterDef.class);
            CompositeInstanceFilter compositeInstanceFilter = compositeInstanceFilterDef.createCompositeInstanceFilter();
            this.log("using compositeInstanceFilter: " + compositeInstanceFilter, 3);
            MigrationReport migrationReport = locator.generateMigrationReport(compositeInstanceFilter, this.getRevision());
            MigrationReportActionContext migrationReportActionContext = new MigrationReportActionContext(locatorSessionContext, compositeInstanceFilter, this.getRevision(), migrationReport);
            for (MigrationReportAction migrationReportAction : this.getMigrationReportActions()) {
                migrationReportAction.execute(migrationReportActionContext);
            }
            if (this.getOutputFile() != null) {
                MigrationReportPrinter.getInstance().print(migrationReport, this.getOutputFormat(), this.getOutputFile());
            }
        }
        catch (Exception e) {
            throw new LocatorActionException(e);
        }
    }

    private File getOutputFile() {
        return new File(this.outputFile);
    }

    private String getOutputFormat() {
        return Utils.getExtension(this.getOutputFile());
    }

    private void addMigrationReportAction(MigrationReportAction migrationReportAction) {
        this.migrationReportActions.add(migrationReportAction);
    }
}

