/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.recognizer;

import java.net.URL;
import oracle.bpm.fusion.core.ProcessNode;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.UrlInputSource;
import oracle.bpm.fusion.core.model.TreeNodeAdapter;
import oracle.bpm.project.io.recognizer.ProjectRecognizer;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.NotRecognizableObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.UnknownProjectObject;
import oracle.bpm.project.model.deployment.DeploymentDescriptor;
import oracle.ide.model.Recognizer;

class ProjectRecognizerAdapter
extends Recognizer {
    private final ProjectRecognizer recognizer = ProjectRecognizer.getInstance();

    ProjectRecognizerAdapter() {
    }

    public Class<ProjectObjectNode> recognize(URL url) {
        Class<ProjectObjectNode> classFromExtension = null;
        Class<? extends ProjectObject> poc = this.recognizeProjectObject(url);
        if (poc != null && !poc.equals(UnknownProjectObject.class)) {
            classFromExtension = ProjectObjectNode.class;
        }
        return classFromExtension;
    }

    public ProjectObjectNode create(URL url, Class nodeType) throws IllegalAccessException, InstantiationException {
        ProjectObjectNode node = null;
        if (this.recognize(url) != null) {
            node = url.toString().endsWith(".bpmn") ? new ProcessNode(url) : new ProjectObjectNode(url);
        }
        return node;
    }

    public String[] getRecognizedExtensions() {
        return this.recognizer.getRecognizedExtensions();
    }

    private Class<? extends ProjectObject> recognizeProjectObject(URL url) {
        UrlInputSource inputSource = UrlInputSource.create(url);
        Class<? extends ProjectObject> result = this.recognizer.recognize(inputSource);
        if (this.mustExclude(result)) {
            result = null;
        }
        return result;
    }

    private boolean mustExclude(Class cl) {
        return cl != null && (TreeNodeAdapter.isExternalNode(cl) || ProjectPreferences.class.isAssignableFrom(cl) || FolderContainer.class.isAssignableFrom(cl) || DeploymentDescriptor.class.isAssignableFrom(cl) || UnknownProjectObject.class.isAssignableFrom(cl) || NotRecognizableObject.class.isAssignableFrom(cl));
    }
}

