/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.core.recognizer;

import java.net.URL;
import java.util.Iterator;
import oracle.bpm.fusion.core.recognizer.ProjectRecognizerAdapter;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;

public class FusionStudioRecognizer
extends Recognizer {
    private final ProjectRecognizerAdapter projectRecognizer = new ProjectRecognizerAdapter();
    private static FusionStudioRecognizer instance;

    private FusionStudioRecognizer() {
    }

    public static FusionStudioRecognizer getInstance() {
        if (instance == null) {
            instance = new FusionStudioRecognizer();
        }
        return instance;
    }

    public Class<? extends Node> recognize(URL url) {
        return this.projectRecognizer.recognize(url);
    }

    public Node create(URL url, Class type) throws IllegalAccessException, InstantiationException {
        if (url.getProtocol().equals("file")) {
            if (!URLFileSystem.exists((URL)url)) {
                return null;
            }
            if (!this.isProjectOpen(url)) {
                return null;
            }
        }
        return this.projectRecognizer.create(url, type);
    }

    public String[] getRecognizedExtensions() {
        return this.projectRecognizer.getRecognizedExtensions();
    }

    private boolean isProjectOpen(URL url) {
        for (Workspace workspace : Ide.getWorkspaces().workspaces()) {
            Iterator it = workspace.getChildren();
            while (it.hasNext()) {
                Project jdevProject;
                URL projectUrl;
                Element child = (Element)it.next();
                if (!(child instanceof Project) || !URLFileSystem.isBaseURLFor((URL)(projectUrl = URLFileSystem.getParent((URL)(jdevProject = (Project)child).getURL())), (URL)url)) continue;
                return true;
            }
        }
        return false;
    }
}

